/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;

public class RpcOptionsBuilder {
    private long timeout;
    private TimeUnit unit;
    private boolean fifoOrder;
    private boolean totalOrder;
    private ResponseFilter responseFilter;
    private ResponseMode responseMode;
    private boolean skipReplicationQueue;

    public RpcOptionsBuilder(long timeout, TimeUnit unit, ResponseMode responseMode, boolean fifoOrder) {
        this.timeout = timeout;
        this.unit = unit;
        this.fifoOrder = fifoOrder;
        this.totalOrder = false;
        this.responseFilter = null;
        this.responseMode = responseMode;
        this.skipReplicationQueue = false;
    }

    public RpcOptionsBuilder(RpcOptions template) {
        this.timeout = template.timeout();
        this.unit = template.timeUnit();
        this.fifoOrder = template.fifoOrder();
        this.totalOrder = template.totalOrder();
        this.responseFilter = template.responseFilter();
        this.responseMode = template.responseMode();
        this.skipReplicationQueue = template.skipReplicationQueue();
    }

    public RpcOptionsBuilder timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
        return this;
    }

    public RpcOptionsBuilder fifoOrder(boolean fifoOrder) {
        this.fifoOrder = fifoOrder;
        return this;
    }

    public RpcOptionsBuilder totalOrder(boolean totalOrder) {
        this.totalOrder = totalOrder;
        return this;
    }

    public RpcOptionsBuilder responseFilter(ResponseFilter responseFilter) {
        this.responseFilter = responseFilter;
        return this;
    }

    public RpcOptionsBuilder responseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public RpcOptionsBuilder skipReplicationQueue(boolean skipReplicationQueue) {
        this.skipReplicationQueue = skipReplicationQueue;
        return this;
    }

    public final RpcOptions build() {
        return new RpcOptions(this.timeout, this.unit, this.responseFilter, this.responseMode, this.skipReplicationQueue, this.fifoOrder, this.totalOrder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcOptionsBuilder that = (RpcOptionsBuilder)o;
        if (this.skipReplicationQueue != that.skipReplicationQueue) {
            return false;
        }
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.fifoOrder != that.fifoOrder) {
            return false;
        }
        if (this.totalOrder != that.totalOrder) {
            return false;
        }
        if (this.responseFilter != null ? !this.responseFilter.equals(that.responseFilter) : that.responseFilter != null) {
            return false;
        }
        if (this.responseMode != that.responseMode) {
            return false;
        }
        return this.unit == that.unit;
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + (this.fifoOrder ? 1 : 0);
        result = 31 * result + (this.totalOrder ? 1 : 0);
        result = 31 * result + (this.responseFilter != null ? this.responseFilter.hashCode() : 0);
        result = 31 * result + (this.responseMode != null ? this.responseMode.hashCode() : 0);
        result = 31 * result + (this.skipReplicationQueue ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RpcOptionsBuilder{timeout=" + this.timeout + ", unit=" + (Object)((Object)this.unit) + ", fifoOrder=" + this.fifoOrder + ", totalOrder=" + this.totalOrder + ", responseFilter=" + this.responseFilter + ", responseMode=" + (Object)((Object)this.responseMode) + ", skipReplicationQueue=" + this.skipReplicationQueue + '}';
    }
}

