/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.InboundTransferTask;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.totalorder.TotalOrderLatch;
import org.infinispan.transaction.totalorder.TotalOrderManager;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateConsumerImpl
implements StateConsumer {
    private static final Log log = LogFactory.getLog(StateConsumerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private ExecutorService executorService;
    private StateTransferManager stateTransferManager;
    private String cacheName;
    private Configuration configuration;
    private RpcManager rpcManager;
    private TransactionManager transactionManager;
    private CommandsFactory commandsFactory;
    private TransactionTable transactionTable;
    private DataContainer dataContainer;
    private CacheLoaderManager cacheLoaderManager;
    private InterceptorChain interceptorChain;
    private InvocationContextContainer icc;
    private StateTransferLock stateTransferLock;
    private CacheNotifier cacheNotifier;
    private TotalOrderManager totalOrderManager;
    private long timeout;
    private boolean isFetchEnabled;
    private boolean isTransactional;
    private boolean isInvalidationMode;
    private boolean isTotalOrder;
    private volatile CacheTopology cacheTopology;
    private volatile Set<Object> updatedKeys;
    private final AtomicBoolean rebalanceInProgress = new AtomicBoolean(false);
    private final AtomicBoolean waitingForState = new AtomicBoolean(false);
    private final Map<Address, List<InboundTransferTask>> transfersBySource = new HashMap<Address, List<InboundTransferTask>>();
    private final Map<Integer, InboundTransferTask> transfersBySegment = new HashMap<Integer, InboundTransferTask>();
    private final BlockingDeque<InboundTransferTask> taskQueue = new LinkedBlockingDeque<InboundTransferTask>();
    private boolean isTransferThreadRunning;
    private volatile boolean ownsData = false;
    private RpcOptions rpcOptions;

    @Override
    public void stopApplyingState() {
        if (trace) {
            log.tracef("Stop keeping track of changed keys for state transfer", new Object[0]);
        }
        this.updatedKeys = null;
    }

    @Override
    public void addUpdatedKey(Object key) {
        Set<Object> localUpdatedKeys = this.updatedKeys;
        if (localUpdatedKeys != null && this.cacheTopology.getWriteConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key)) {
            localUpdatedKeys.add(key);
        }
    }

    @Override
    public boolean isKeyUpdated(Object key) {
        Set<Object> localUpdatedKeys = this.updatedKeys;
        return localUpdatedKeys == null || localUpdatedKeys.contains(key);
    }

    @Inject
    public void init(Cache cache, @ComponentName(value="org.infinispan.executors.transport") ExecutorService executorService, StateTransferManager stateTransferManager, InterceptorChain interceptorChain, InvocationContextContainer icc, Configuration configuration, RpcManager rpcManager, TransactionManager transactionManager, CommandsFactory commandsFactory, CacheLoaderManager cacheLoaderManager, DataContainer dataContainer, TransactionTable transactionTable, StateTransferLock stateTransferLock, CacheNotifier cacheNotifier, TotalOrderManager totalOrderManager) {
        this.cacheName = cache.getName();
        this.executorService = executorService;
        this.stateTransferManager = stateTransferManager;
        this.interceptorChain = interceptorChain;
        this.icc = icc;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.transactionManager = transactionManager;
        this.commandsFactory = commandsFactory;
        this.cacheLoaderManager = cacheLoaderManager;
        this.dataContainer = dataContainer;
        this.transactionTable = transactionTable;
        this.stateTransferLock = stateTransferLock;
        this.cacheNotifier = cacheNotifier;
        this.totalOrderManager = totalOrderManager;
        this.isInvalidationMode = configuration.clustering().cacheMode().isInvalidation();
        this.isTransactional = configuration.transaction().transactionMode().isTransactional();
        this.isTotalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
        this.timeout = configuration.clustering().stateTransfer().timeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveTransfers() {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            return !this.transfersBySource.isEmpty();
        }
    }

    @Override
    public boolean isStateTransferInProgress() {
        return this.rebalanceInProgress.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStateTransferInProgressForKey(Object key) {
        if (this.isInvalidationMode) {
            return false;
        }
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            CacheTopology localCacheTopology = this.cacheTopology;
            if (localCacheTopology == null || localCacheTopology.getPendingCH() == null) {
                return false;
            }
            Address address = this.rpcManager.getAddress();
            boolean keyWillBeLocal = localCacheTopology.getPendingCH().isKeyLocalToNode(address, key);
            boolean keyIsLocal = localCacheTopology.getCurrentCH().isKeyLocalToNode(address, key);
            return keyWillBeLocal && !keyIsLocal;
        }
    }

    @Override
    public boolean ownsData() {
        return this.ownsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTopologyUpdate(CacheTopology cacheTopology, boolean isRebalance) {
        boolean isMember = cacheTopology.getMembers().contains(this.rpcManager.getAddress());
        if (trace) {
            log.tracef("Received new topology for cache %s, isRebalance = %b, isMember = %b, topology = %s", new Object[]{this.cacheName, isRebalance, isMember, cacheTopology});
        }
        if (isRebalance) {
            if (!this.ownsData && cacheTopology.getMembers().contains(this.rpcManager.getAddress())) {
                this.ownsData = true;
            }
            this.rebalanceInProgress.set(true);
            this.cacheNotifier.notifyDataRehashed(cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), cacheTopology.getTopologyId(), true);
            if (this.isTotalOrder) {
                if (log.isTraceEnabled()) {
                    log.trace("State Transfer in Total Order cache. Waiting for remote transactions to finish");
                }
                try {
                    for (TotalOrderLatch block : this.totalOrderManager.notifyStateTransferStart(cacheTopology.getTopologyId())) {
                        block.awaitUntilUnBlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheException(e);
                }
                if (log.isTraceEnabled()) {
                    log.trace("State Transfer in Total Order cache. All remote transactions are finished. Moving on...");
                }
            }
            if (log.isTraceEnabled()) {
                log.tracef("Lock State Transfer in Progress for topology ID %s", cacheTopology.getTopologyId());
            }
        } else if (cacheTopology.getMembers().size() == 1 && cacheTopology.getMembers().get(0).equals(this.rpcManager.getAddress())) {
            this.ownsData = true;
        }
        this.waitingForState.set(false);
        ConsistentHash previousReadCh = this.cacheTopology != null ? this.cacheTopology.getReadConsistentHash() : null;
        ConsistentHash previousWriteCh = this.cacheTopology != null ? this.cacheTopology.getWriteConsistentHash() : null;
        this.stateTransferLock.acquireExclusiveTopologyLock();
        this.cacheTopology = cacheTopology;
        if (isRebalance) {
            if (trace) {
                log.tracef("Start keeping track of keys for rebalance", new Object[0]);
            }
            this.updatedKeys = new ConcurrentHashSet<Object>();
        }
        this.stateTransferLock.releaseExclusiveTopologyLock();
        this.stateTransferLock.notifyTopologyInstalled(cacheTopology.getTopologyId());
        try {
            boolean changed;
            if (this.isTransactional || this.isFetchEnabled) {
                Set<Integer> addedSegments;
                if (previousWriteCh == null) {
                    addedSegments = this.getOwnedSegments(cacheTopology.getWriteConsistentHash());
                    if (trace) {
                        log.tracef("On cache %s we have: added segments: %s", this.cacheName, addedSegments);
                    }
                } else {
                    Set<Integer> previousSegments = this.getOwnedSegments(previousWriteCh);
                    Set<Integer> newSegments = this.getOwnedSegments(cacheTopology.getWriteConsistentHash());
                    HashSet<Integer> removedSegments = new HashSet<Integer>(previousSegments);
                    removedSegments.removeAll(newSegments);
                    addedSegments = new HashSet<Integer>(newSegments);
                    addedSegments.removeAll(previousSegments);
                    if (trace) {
                        log.tracef("On cache %s we have: removed segments: %s; new segments: %s; old segments: %s; added segments: %s", new Object[]{this.cacheName, removedSegments, newSegments, previousSegments, addedSegments});
                    }
                    this.cancelTransfers(removedSegments);
                    if (isMember) {
                        this.invalidateSegments(newSegments, removedSegments);
                    }
                    this.restartBrokenTransfers(cacheTopology, addedSegments);
                }
                if (!addedSegments.isEmpty()) {
                    this.addTransfers(addedSegments);
                }
            }
            log.tracef("Topology update processed, rebalanceInProgress = %s, isRebalance = %s, pending CH = %s", this.rebalanceInProgress.get(), isRebalance, cacheTopology.getPendingCH());
            if (this.rebalanceInProgress.get() && !isRebalance && cacheTopology.getPendingCH() == null && (changed = this.rebalanceInProgress.compareAndSet(true, false))) {
                this.cacheNotifier.notifyDataRehashed(previousReadCh, cacheTopology.getCurrentCH(), cacheTopology.getTopologyId(), false);
                if (log.isTraceEnabled()) {
                    log.tracef("Unlock State Transfer in Progress for topology ID %s", cacheTopology.getTopologyId());
                }
                if (this.isTotalOrder) {
                    this.totalOrderManager.notifyStateTransferEnd();
                }
            }
        }
        finally {
            this.stateTransferLock.notifyTransactionDataReceived(cacheTopology.getTopologyId());
            if (this.rebalanceInProgress.get()) {
                this.waitingForState.set(true);
            }
            this.notifyEndOfRebalanceIfNeeded(cacheTopology.getTopologyId());
            if (this.transactionTable != null) {
                this.transactionTable.cleanupStaleTransactions(cacheTopology);
            }
        }
    }

    private void notifyEndOfRebalanceIfNeeded(int topologyId) {
        if (this.waitingForState.get() && !this.hasActiveTransfers() && this.waitingForState.compareAndSet(true, false)) {
            log.debugf("Finished receiving of segments for cache %s for topology %d.", this.cacheName, topologyId);
            this.stopApplyingState();
            this.stateTransferManager.notifyEndOfRebalance(topologyId);
        }
    }

    private Set<Integer> getOwnedSegments(ConsistentHash consistentHash) {
        Address address = this.rpcManager.getAddress();
        return consistentHash.getMembers().contains(address) ? consistentHash.getSegmentsForOwner(address) : InfinispanCollections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyState(Address sender, int topologyId, Collection<StateChunk> stateChunks) {
        ConsistentHash wCh = this.cacheTopology.getWriteConsistentHash();
        if (!wCh.getMembers().contains(this.rpcManager.getAddress())) {
            if (trace) {
                log.tracef("Ignoring received state because we are no longer a member", new Object[0]);
            }
            return;
        }
        if (trace) {
            log.tracef("Before applying the received state the data container of cache %s has %d keys", this.cacheName, this.dataContainer.size());
        }
        for (StateChunk stateChunk : stateChunks) {
            InboundTransferTask inboundTransfer;
            if (!wCh.getSegmentsForOwner(this.rpcManager.getAddress()).contains(stateChunk.getSegmentId())) {
                log.warnf("Discarding received cache entries for segment %d of cache %s because they do not belong to this node.", stateChunk.getSegmentId(), this.cacheName);
                continue;
            }
            StateConsumerImpl stateConsumerImpl = this;
            synchronized (stateConsumerImpl) {
                inboundTransfer = this.transfersBySegment.get(stateChunk.getSegmentId());
            }
            if (inboundTransfer != null) {
                if (stateChunk.getCacheEntries() != null) {
                    this.doApplyState(sender, stateChunk.getSegmentId(), stateChunk.getCacheEntries());
                }
                inboundTransfer.onStateReceived(stateChunk.getSegmentId(), stateChunk.isLastChunk());
                continue;
            }
            log.warnf("Received unsolicited state from node %s for segment %d of cache %s", sender, stateChunk.getSegmentId(), this.cacheName);
        }
        if (trace) {
            log.tracef("After applying the received state the data container of cache %s has %d keys", this.cacheName, this.dataContainer.size());
            StateConsumerImpl stateConsumerImpl = this;
            synchronized (stateConsumerImpl) {
                log.tracef("Segments not received yet for cache %s: %s", this.cacheName, this.transfersBySource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyState(Address sender, int segmentId, Collection<InternalCacheEntry> cacheEntries) {
        log.debugf("Applying new state for segment %d of cache %s from node %s: received %d cache entries", new Object[]{segmentId, this.cacheName, sender, cacheEntries.size()});
        if (trace) {
            ArrayList<Object> keys = new ArrayList<Object>(cacheEntries.size());
            for (InternalCacheEntry e : cacheEntries) {
                keys.add(e.getKey());
            }
            log.tracef("Received keys %s for segment %d of cache %s from node %s", new Object[]{keys, segmentId, this.cacheName, sender});
        }
        EnumSet<Flag[]> flags = EnumSet.of(Flag.PUT_FOR_STATE_TRANSFER, new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_SHARED_CACHE_STORE, Flag.SKIP_OWNERSHIP_CHECK, Flag.SKIP_XSITE_BACKUP});
        for (InternalCacheEntry e : cacheEntries) {
            try {
                InvocationContext ctx;
                if (this.transactionManager != null) {
                    this.transactionManager.begin();
                    Transaction transaction = this.transactionManager.getTransaction();
                    ctx = this.icc.createInvocationContext(transaction);
                    ((TxInvocationContext)ctx).setImplicitTransaction(true);
                } else {
                    ctx = this.icc.createSingleKeyNonTxInvocationContext();
                }
                PutKeyValueCommand put = this.commandsFactory.buildPutKeyValueCommand(e.getKey(), e.getValue(), e.getMetadata(), flags);
                boolean success = false;
                try {
                    this.interceptorChain.invoke(ctx, put);
                    success = true;
                }
                finally {
                    if (!ctx.isInTxScope()) continue;
                    if (success) {
                        try {
                            this.transactionManager.commit();
                        }
                        catch (Throwable ex) {
                            log.errorf(ex, "Could not commit transaction created by state transfer of key %s", e.getKey());
                            if (this.transactionManager.getTransaction() == null) continue;
                            this.transactionManager.rollback();
                        }
                        continue;
                    }
                    this.transactionManager.rollback();
                }
            }
            catch (Exception ex) {
                log.problemApplyingStateForKey(ex.getMessage(), e.getKey(), ex);
            }
        }
        log.debugf("Finished applying state for segment %d of cache %s", segmentId, this.cacheName);
    }

    private void applyTransactions(Address sender, Collection<TransactionInfo> transactions) {
        log.debugf("Applying %d transactions for cache %s transferred from node %s", transactions.size(), this.cacheName, sender);
        if (this.isTransactional) {
            for (TransactionInfo transactionInfo : transactions) {
                AbstractCacheTransaction tx = this.transactionTable.getLocalTransaction(transactionInfo.getGlobalTransaction());
                if (tx == null && (tx = this.transactionTable.getRemoteTransaction(transactionInfo.getGlobalTransaction())) == null) {
                    tx = this.transactionTable.getOrCreateRemoteTransaction(transactionInfo.getGlobalTransaction(), transactionInfo.getModifications());
                    ((RemoteTransaction)tx).setMissingLookedUpEntries(true);
                }
                for (Object key : transactionInfo.getLockedKeys()) {
                    tx.addBackupLockForKey(key);
                }
            }
        }
    }

    @Start(priority=20)
    public void start() {
        this.isFetchEnabled = this.configuration.clustering().stateTransfer().fetchInMemoryState() || this.cacheLoaderManager.isFetchPersistentState();
        this.rpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS).timeout(this.timeout, TimeUnit.MILLISECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop(priority=20)
    public void stop() {
        if (trace) {
            log.tracef("Shutting down StateConsumer of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        try {
            StateConsumerImpl stateConsumerImpl = this;
            synchronized (stateConsumerImpl) {
                this.taskQueue.clear();
                Iterator<List<InboundTransferTask>> it = this.transfersBySource.values().iterator();
                while (it.hasNext()) {
                    List<InboundTransferTask> inboundTransfers = it.next();
                    it.remove();
                    for (InboundTransferTask inboundTransfer : inboundTransfers) {
                        inboundTransfer.cancel();
                    }
                }
                this.transfersBySource.clear();
                this.transfersBySegment.clear();
            }
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to stop StateConsumer of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
    }

    @Override
    public CacheTopology getCacheTopology() {
        return this.cacheTopology;
    }

    private void addTransfers(Set<Integer> segments) {
        log.debugf("Adding inbound state transfer for segments %s of cache %s", segments, this.cacheName);
        HashSet<Address> excludedSources = new HashSet<Address>();
        HashMap<Address, Set<Integer>> sources = new HashMap<Address, Set<Integer>>();
        if (this.isTransactional && !this.isTotalOrder) {
            this.requestTransactions(segments, sources, excludedSources);
        }
        if (this.isFetchEnabled) {
            this.requestSegments(segments, sources, excludedSources);
        }
        log.debugf("Finished adding inbound state transfer for segments %s of cache %s", segments, this.cacheName);
    }

    private void findSources(Set<Integer> segments, Map<Address, Set<Integer>> sources, Set<Address> excludedSources) {
        for (Integer segmentId : segments) {
            Address source = this.findSource(segmentId, excludedSources);
            if (source == null) continue;
            Set<Integer> segmentsFromSource = sources.get(source);
            if (segmentsFromSource == null) {
                segmentsFromSource = new HashSet<Integer>();
                sources.put(source, segmentsFromSource);
            }
            segmentsFromSource.add(segmentId);
        }
    }

    private Address findSource(int segmentId, Set<Address> excludedSources) {
        List<Address> owners = this.cacheTopology.getReadConsistentHash().locateOwnersForSegment(segmentId);
        if (!owners.contains(this.rpcManager.getAddress())) {
            for (int i = owners.size() - 1; i >= 0; --i) {
                Address o = owners.get(i);
                if (o.equals(this.rpcManager.getAddress()) || excludedSources.contains(o)) continue;
                return o;
            }
            log.noLiveOwnersFoundForSegment(segmentId, this.cacheName, owners, excludedSources);
        }
        return null;
    }

    private void requestTransactions(Set<Integer> segments, Map<Address, Set<Integer>> sources, Set<Address> excludedSources) {
        this.findSources(segments, sources, excludedSources);
        boolean seenFailures = false;
        while (true) {
            HashSet<Integer> failedSegments = new HashSet<Integer>();
            for (Map.Entry<Address, Set<Integer>> e : sources.entrySet()) {
                Set<Integer> segmentsFromSource;
                Address source = e.getKey();
                List<TransactionInfo> transactions = this.getTransactions(source, segmentsFromSource = e.getValue(), this.cacheTopology.getTopologyId());
                if (transactions != null) {
                    this.applyTransactions(source, transactions);
                    continue;
                }
                failedSegments.addAll(segmentsFromSource);
                excludedSources.add(source);
            }
            if (failedSegments.isEmpty()) break;
            seenFailures = true;
            sources.clear();
            this.findSources(failedSegments, sources, excludedSources);
        }
        if (seenFailures) {
            sources.clear();
        }
    }

    private List<TransactionInfo> getTransactions(Address source, Set<Integer> segments, int topologyId) {
        if (trace) {
            log.tracef("Requesting transactions for segments %s of cache %s from node %s", segments, this.cacheName, source);
        }
        try {
            StateRequestCommand cmd = this.commandsFactory.buildStateRequestCommand(StateRequestCommand.Type.GET_TRANSACTIONS, this.rpcManager.getAddress(), topologyId, segments);
            Map<Address, Response> responses = this.rpcManager.invokeRemotely(Collections.singleton(source), (ReplicableCommand)cmd, this.rpcOptions);
            Response response = responses.get(source);
            if (response instanceof SuccessfulResponse) {
                return (List)((SuccessfulResponse)response).getResponseValue();
            }
            log.failedToRetrieveTransactionsForSegments(segments, this.cacheName, source, null);
        }
        catch (CacheException e) {
            log.failedToRetrieveTransactionsForSegments(segments, this.cacheName, source, e);
        }
        return null;
    }

    private void requestSegments(Set<Integer> segments, Map<Address, Set<Integer>> sources, Set<Address> excludedSources) {
        if (sources.isEmpty()) {
            this.findSources(segments, sources, excludedSources);
        }
        for (Map.Entry<Address, Set<Integer>> e : sources.entrySet()) {
            this.addTransfer(e.getKey(), e.getValue());
        }
        this.startTransferThread(excludedSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransferThread(final Set<Address> excludedSources) {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            if (this.isTransferThreadRunning) {
                return;
            }
            this.isTransferThreadRunning = true;
        }
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        ArrayList<InboundTransferTask> failedTasks = new ArrayList<InboundTransferTask>();
                        while (true) {
                            StateConsumerImpl stateConsumerImpl;
                            InboundTransferTask task;
                            try {
                                task = (InboundTransferTask)StateConsumerImpl.this.taskQueue.pollFirst(200L, TimeUnit.MILLISECONDS);
                                if (task == null) {
                                    break;
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                stateConsumerImpl = StateConsumerImpl.this;
                                synchronized (stateConsumerImpl) {
                                    StateConsumerImpl.this.isTransferThreadRunning = false;
                                    return;
                                }
                            }
                            if (!task.requestSegments()) {
                                failedTasks.add(task);
                                continue;
                            }
                            try {
                                if (task.awaitCompletion()) continue;
                                failedTasks.add(task);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                stateConsumerImpl = StateConsumerImpl.this;
                                synchronized (stateConsumerImpl) {
                                    StateConsumerImpl.this.isTransferThreadRunning = false;
                                    return;
                                }
                            }
                        }
                        if (failedTasks.isEmpty() && StateConsumerImpl.this.taskQueue.isEmpty()) {
                            return;
                        }
                        log.tracef("Retrying %d failed tasks", failedTasks.size());
                        StateConsumerImpl stateConsumerImpl = StateConsumerImpl.this;
                        synchronized (stateConsumerImpl) {
                            HashSet<Integer> failedSegments = new HashSet<Integer>();
                            for (InboundTransferTask task : failedTasks) {
                                if (!StateConsumerImpl.this.removeTransfer(task)) continue;
                                excludedSources.add(task.getSource());
                                failedSegments.addAll(task.getSegments());
                            }
                            failedSegments.retainAll(StateConsumerImpl.this.getOwnedSegments(StateConsumerImpl.this.cacheTopology.getWriteConsistentHash()));
                            failedSegments.removeAll(StateConsumerImpl.this.getOwnedSegments(StateConsumerImpl.this.cacheTopology.getReadConsistentHash()));
                            HashMap sources = new HashMap();
                            StateConsumerImpl.this.findSources(failedSegments, sources, excludedSources);
                            for (Map.Entry e : sources.entrySet()) {
                                StateConsumerImpl.this.addTransfer((Address)e.getKey(), (Set)e.getValue());
                            }
                        }
                    }
                }
                finally {
                    StateConsumerImpl stateConsumerImpl = StateConsumerImpl.this;
                    synchronized (stateConsumerImpl) {
                        StateConsumerImpl.this.isTransferThreadRunning = false;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTransfers(Set<Integer> removedSegments) {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            ArrayList<Integer> segmentsToCancel = new ArrayList<Integer>(removedSegments);
            while (!segmentsToCancel.isEmpty()) {
                int segmentId = (Integer)segmentsToCancel.remove(0);
                InboundTransferTask inboundTransfer = this.transfersBySegment.get(segmentId);
                if (inboundTransfer == null) continue;
                HashSet<Integer> cancelledSegments = new HashSet<Integer>(removedSegments);
                cancelledSegments.retainAll(inboundTransfer.getSegments());
                segmentsToCancel.removeAll(cancelledSegments);
                this.transfersBySegment.keySet().removeAll(cancelledSegments);
                inboundTransfer.cancelSegments(cancelledSegments);
            }
        }
    }

    private void invalidateSegments(Set<Integer> newSegments, Set<Integer> segmentsToL1) {
        NonTxInvocationContext ctx;
        InvalidateCommand invalidateCmd;
        HashSet<Object> keysToL1 = new HashSet<Object>();
        HashSet<Object> keysToRemove = new HashSet<Object>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object key = ice.getKey();
            int keySegment = this.getSegment(key);
            if (segmentsToL1.contains(keySegment)) {
                keysToL1.add(key);
                continue;
            }
            if (newSegments.contains(keySegment)) continue;
            keysToRemove.add(key);
        }
        CacheStore cacheStore = this.getCacheStore();
        if (cacheStore != null) {
            try {
                Set<Object> storedKeys = cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer));
                for (Object key : storedKeys) {
                    int keySegment = this.getSegment(key);
                    if (segmentsToL1.contains(keySegment)) {
                        keysToL1.add(key);
                        continue;
                    }
                    if (newSegments.contains(keySegment)) continue;
                    keysToRemove.add(key);
                }
            }
            catch (CacheLoaderException e) {
                log.failedLoadingKeysFromCacheStore(e);
            }
        }
        if (this.configuration.clustering().l1().onRehash()) {
            log.debugf("Moving to L1 state for segments %s of cache %s", segmentsToL1, this.cacheName);
        } else {
            log.debugf("Removing state for segments %s of cache %s", segmentsToL1, this.cacheName);
        }
        if (!keysToL1.isEmpty()) {
            try {
                invalidateCmd = this.commandsFactory.buildInvalidateFromL1Command(true, EnumSet.of(Flag.CACHE_MODE_LOCAL, Flag.SKIP_LOCKING), keysToL1);
                ctx = this.icc.createNonTxInvocationContext();
                this.interceptorChain.invoke(ctx, invalidateCmd);
                log.debugf("Invalidated %d keys, data container now has %d keys", keysToL1.size(), this.dataContainer.size());
                if (trace) {
                    log.tracef("Invalidated keys: %s", keysToL1);
                }
            }
            catch (CacheException e) {
                log.failedToInvalidateKeys(e);
            }
        }
        log.debugf("Removing state for segments not in %s or %s for cache %s", newSegments, segmentsToL1, this.cacheName);
        if (!keysToRemove.isEmpty()) {
            try {
                invalidateCmd = this.commandsFactory.buildInvalidateCommand(EnumSet.of(Flag.CACHE_MODE_LOCAL, Flag.SKIP_LOCKING), keysToRemove.toArray());
                ctx = this.icc.createNonTxInvocationContext();
                this.interceptorChain.invoke(ctx, invalidateCmd);
                log.debugf("Invalidated %d keys, data container of cache %s now has %d keys", keysToRemove.size(), this.cacheName, this.dataContainer.size());
                if (trace) {
                    log.tracef("Invalidated keys: %s", keysToRemove);
                }
            }
            catch (CacheException e) {
                log.failedToInvalidateKeys(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartBrokenTransfers(CacheTopology cacheTopology, Set<Integer> addedSegments) {
        HashSet<Address> members = new HashSet<Address>(cacheTopology.getReadConsistentHash().getMembers());
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            Iterator<Address> it = this.transfersBySource.keySet().iterator();
            while (it.hasNext()) {
                Address source = it.next();
                if (members.contains(source)) continue;
                if (trace) {
                    log.tracef("Removing inbound transfers from source %s for cache %s", source, this.cacheName);
                }
                List<InboundTransferTask> inboundTransfers = this.transfersBySource.get(source);
                it.remove();
                for (InboundTransferTask inboundTransfer : inboundTransfers) {
                    if (trace) {
                        log.tracef("Removing inbound transfers for segments %s from source %s for cache %s", inboundTransfer.getSegments(), source, this.cacheName);
                    }
                    this.taskQueue.remove(inboundTransfer);
                    inboundTransfer.terminate();
                    this.transfersBySegment.keySet().removeAll(inboundTransfer.getSegments());
                    addedSegments.addAll(inboundTransfer.getUnfinishedSegments());
                }
            }
            addedSegments.removeAll(this.transfersBySegment.keySet());
        }
    }

    private int getSegment(Object key) {
        return this.cacheTopology.getReadConsistentHash().getSegment(key);
    }

    private CacheStore getCacheStore() {
        if (this.cacheLoaderManager.isEnabled() && !this.cacheLoaderManager.isShared()) {
            return this.cacheLoaderManager.getCacheStore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InboundTransferTask addTransfer(Address source, Set<Integer> segmentsFromSource) {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            log.tracef("Adding transfer from %s for segments %s", source, segmentsFromSource);
            segmentsFromSource.removeAll(this.transfersBySegment.keySet());
            if (!segmentsFromSource.isEmpty()) {
                InboundTransferTask inboundTransfer = new InboundTransferTask(segmentsFromSource, source, this.cacheTopology.getTopologyId(), this, this.rpcManager, this.commandsFactory, this.timeout, this.cacheName);
                for (int segmentId : segmentsFromSource) {
                    this.transfersBySegment.put(segmentId, inboundTransfer);
                }
                List<InboundTransferTask> inboundTransfers = this.transfersBySource.get(inboundTransfer.getSource());
                if (inboundTransfers == null) {
                    inboundTransfers = new ArrayList<InboundTransferTask>();
                    this.transfersBySource.put(inboundTransfer.getSource(), inboundTransfers);
                }
                inboundTransfers.add(inboundTransfer);
                this.taskQueue.add(inboundTransfer);
                return inboundTransfer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTransfer(InboundTransferTask inboundTransfer) {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            log.tracef("Removing inbound transfers for segments %s from source %s for cache %s", inboundTransfer.getSegments(), inboundTransfer.getSource(), this.cacheName);
            this.taskQueue.remove(inboundTransfer);
            List<InboundTransferTask> transfers = this.transfersBySource.get(inboundTransfer.getSource());
            if (transfers != null && transfers.remove(inboundTransfer)) {
                if (transfers.isEmpty()) {
                    this.transfersBySource.remove(inboundTransfer.getSource());
                }
                this.transfersBySegment.keySet().removeAll(inboundTransfer.getSegments());
                return true;
            }
        }
        return false;
    }

    void onTaskCompletion(InboundTransferTask inboundTransfer) {
        log.tracef("Completion of inbound transfer task: %s ", inboundTransfer);
        this.removeTransfer(inboundTransfer);
        this.notifyEndOfRebalanceIfNeeded(this.cacheTopology.getTopologyId());
    }
}

