/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.TotalOrderRemoteTransactionState;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.AnyEquivalence;
import org.infinispan.util.CollectionFactory;
import org.infinispan.util.Equivalence;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction
implements Cloneable {
    private static final Log log = LogFactory.getLog(RemoteTransaction.class);
    private volatile boolean missingLookedUpEntries = false;
    private volatile TotalOrderRemoteTransactionState transactionState;
    private final Object transactionStateLock = new Object();

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence) {
        super(tx, topologyId, keyEquivalence);
        this.modifications = modifications == null || modifications.length == 0 ? InfinispanCollections.emptyList() : Arrays.asList(modifications);
        this.lookedUpEntries = CollectionFactory.makeMap(this.modifications.size(), keyEquivalence, AnyEquivalence.getInstance());
    }

    public RemoteTransaction(GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence) {
        super(tx, topologyId, keyEquivalence);
        this.modifications = new LinkedList();
        this.lookedUpEntries = CollectionFactory.makeMap(2, keyEquivalence, AnyEquivalence.getInstance());
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.checkIfRolledBack();
        if (log.isTraceEnabled()) {
            log.tracef("Adding key %s to tx %s", key, this.getGlobalTransaction());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.checkIfRolledBack();
        if (log.isTraceEnabled()) {
            log.tracef("Adding keys %s to tx %s", entries.keySet(), this.getGlobalTransaction());
        }
        this.lookedUpEntries.putAll(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList(this.modifications);
            dolly.lookedUpEntries = CollectionFactory.makeMap(this.lookedUpEntries, this.keyEquivalence, AnyEquivalence.getInstance());
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", lockedKeys=" + this.lockedKeys + ", backupKeyLocks=" + this.backupKeyLocks + ", missingLookedUpEntries=" + this.missingLookedUpEntries + ", isMarkedForRollback=" + this.isMarkedForRollback() + ", tx=" + this.tx + ", state=" + this.transactionState + '}';
    }

    public void setMissingLookedUpEntries(boolean missingLookedUpEntries) {
        this.missingLookedUpEntries = missingLookedUpEntries;
    }

    public boolean isMissingLookedUpEntries() {
        return this.missingLookedUpEntries;
    }

    private void checkIfRolledBack() {
        if (this.isMarkedForRollback()) {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is already rolled back");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TotalOrderRemoteTransactionState getTransactionState() {
        if (this.transactionState != null) {
            return this.transactionState;
        }
        Object object = this.transactionStateLock;
        synchronized (object) {
            if (this.transactionState == null) {
                this.transactionState = new TotalOrderRemoteTransactionState(this.getGlobalTransaction());
            }
            return this.transactionState;
        }
    }
}

