/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.util.AnyEquivalence;
import org.infinispan.util.Equivalence;
import org.infinispan.util.EquivalentHashMap;
import org.infinispan.util.EquivalentHashSet;
import org.infinispan.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;

public class CollectionFactory {
    private static final ConcurrentMapCreator MAP_CREATOR;

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap() {
        return MAP_CREATOR.createConcurrentMap();
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity) {
        return MAP_CREATOR.createConcurrentMap(initCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, int concurrencyLevel) {
        return MAP_CREATOR.createConcurrentMap(initCapacity, concurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, float loadFactor, int concurrencyLevel) {
        return MAP_CREATOR.createConcurrentMap(initCapacity, loadFactor, concurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentConcurrentHashMapV8<K, V>(keyEq, valueEq);
        }
        return MAP_CREATOR.createConcurrentMap();
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentConcurrentHashMapV8<K, V>(initCapacity, keyEq, valueEq);
        }
        return MAP_CREATOR.createConcurrentMap(initCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, int concurrencyLevel, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentConcurrentHashMapV8<K, V>(initCapacity, concurrencyLevel, keyEq, valueEq);
        }
        return MAP_CREATOR.createConcurrentMap(initCapacity, concurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, float loadFactor, int concurrencyLevel, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentConcurrentHashMapV8<K, V>(initCapacity, loadFactor, concurrencyLevel, keyEq, valueEq);
        }
        return MAP_CREATOR.createConcurrentMap(initCapacity, loadFactor, concurrencyLevel);
    }

    public static <K, V> Map<K, V> makeMap(Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentHashMap<K, V>(keyEq, valueEq);
        }
        return new HashMap();
    }

    public static <K, V> Map<K, V> makeMap(int initialCapacity, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentHashMap<K, V>(initialCapacity, keyEq, valueEq);
        }
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> makeMap(Map<? extends K, ? extends V> entries, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (CollectionFactory.requiresEquivalent(keyEq, valueEq)) {
            return new EquivalentHashMap<K, V>(entries, keyEq, valueEq);
        }
        return new HashMap<K, V>(entries);
    }

    public static <T> Set<T> makeSet(Equivalence<T> entryEq) {
        if (CollectionFactory.requiresEquivalent(entryEq)) {
            return new EquivalentHashSet<T>(entryEq);
        }
        return new HashSet();
    }

    public static <T> Set<T> makeSet(int initialCapacity, Equivalence<T> entryEq) {
        if (CollectionFactory.requiresEquivalent(entryEq)) {
            return new EquivalentHashSet<T>(initialCapacity, entryEq);
        }
        return new HashSet(initialCapacity);
    }

    private static <K, V> boolean requiresEquivalent(Equivalence<K> keyEq, Equivalence<V> valueEq) {
        AnyEquivalence instance = AnyEquivalence.getInstance();
        return keyEq != instance || valueEq != instance;
    }

    private static <T> boolean requiresEquivalent(Equivalence<T> typeEq) {
        return typeEq != AnyEquivalence.getInstance();
    }

    static {
        boolean jdk8;
        boolean sunIncompatibleJvm;
        boolean allowExperimentalMap = Boolean.parseBoolean(System.getProperty("infinispan.unsafe.allow_jdk8_chm", "true"));
        try {
            Class.forName("sun.misc.Unsafe");
            sunIncompatibleJvm = false;
        }
        catch (ClassNotFoundException e) {
            sunIncompatibleJvm = true;
        }
        try {
            Class.forName("java.util.concurrent.atomic.LongAdder");
            jdk8 = true;
        }
        catch (ClassNotFoundException e) {
            jdk8 = false;
        }
        MAP_CREATOR = jdk8 || sunIncompatibleJvm || !allowExperimentalMap ? new JdkConcurrentMapCreator() : new BackportedV8ConcurrentMapCreator();
    }

    private static class BackportedV8ConcurrentMapCreator
    implements ConcurrentMapCreator {
        private BackportedV8ConcurrentMapCreator() {
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap() {
            return new EquivalentConcurrentHashMapV8(AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity) {
            return new EquivalentConcurrentHashMapV8(initialCapacity, AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, int concurrencyLevel) {
            return new EquivalentConcurrentHashMapV8(initialCapacity, 0.75f, concurrencyLevel, AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            return new EquivalentConcurrentHashMapV8(initialCapacity, loadFactor, concurrencyLevel, AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
        }
    }

    private static class JdkConcurrentMapCreator
    implements ConcurrentMapCreator {
        private JdkConcurrentMapCreator() {
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity) {
            return new ConcurrentHashMap(initialCapacity);
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, int concurrencyLevel) {
            return new ConcurrentHashMap(initialCapacity, 0.75f, concurrencyLevel);
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }
    }

    private static interface ConcurrentMapCreator {
        public <K, V> ConcurrentMap<K, V> createConcurrentMap();

        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int var1);

        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int var1, int var2);

        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int var1, float var2, int var3);
    }
}

