/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.util.AbstractMap;
import org.infinispan.util.Equivalence;

public class EquivalentHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private Node<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private int modCount;
    private final Equivalence<K> keyEq;
    private final Equivalence<V> valueEq;

    public EquivalentHashMap(Equivalence<K> keyEq, Equivalence<V> valueEq) {
        this(16, keyEq, valueEq);
    }

    public EquivalentHashMap(int initialCapacity, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)capacity * 0.75f);
        this.table = new Node[capacity];
        this.keyEq = keyEq;
        this.valueEq = valueEq;
    }

    public EquivalentHashMap(Map<? extends K, ? extends V> map, Equivalence<K> keyEq, Equivalence<V> valueEq) {
        if (map instanceof EquivalentHashMap) {
            EquivalentHashMap equivalentMap = (EquivalentHashMap)map;
            this.table = (Node[])equivalentMap.table.clone();
            this.loadFactor = equivalentMap.loadFactor;
            this.size = equivalentMap.size;
            this.threshold = equivalentMap.threshold;
        } else {
            this.loadFactor = 0.75f;
            this.init(map.size(), this.loadFactor);
            this.putAll(map);
        }
        this.keyEq = keyEq;
        this.valueEq = valueEq;
    }

    private void init(int initialCapacity, float loadFactor) {
        int c;
        for (c = 1; c < initialCapacity; c <<= 1) {
        }
        this.table = new Node[c];
        this.threshold = (int)((float)c * loadFactor);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        EquivalentHashMap.assertKeyNotNull(key);
        int hash = EquivalentHashMap.spread(this.keyEq.hashCode(key));
        int length = this.table.length;
        int index = EquivalentHashMap.index(hash, length);
        Node<K, V> e;
        while ((e = this.table[index]) != null) {
            if (e.hash == hash && this.keyEq.equals(e.key, key)) {
                return true;
            }
            index = EquivalentHashMap.nextIndex(index, length);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node<K, V> e : this.table) {
            if (e == null || !this.valueEq.equals(e.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        EquivalentHashMap.assertKeyNotNull(key);
        int hash = EquivalentHashMap.spread(this.keyEq.hashCode(key));
        int length = this.table.length;
        int index = EquivalentHashMap.index(hash, length);
        Node<K, V> e;
        while ((e = this.table[index]) != null) {
            if (e.hash == hash && this.keyEq.equals(e.key, key)) {
                return e.value;
            }
            index = EquivalentHashMap.nextIndex(index, length);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Node<K, V> e;
        int start;
        EquivalentHashMap.assertKeyNotNull(key);
        Node<K, V>[] table = this.table;
        int hash = EquivalentHashMap.spread(this.keyEq.hashCode(key));
        int length = table.length;
        int index = start = EquivalentHashMap.index(hash, length);
        while ((e = table[index]) != null) {
            if (e.hash == hash && this.keyEq.equals(e.key, key)) {
                table[index] = new Node(e.key, e.hash, value);
                return e.value;
            }
            if ((index = EquivalentHashMap.nextIndex(index, length)) != start) continue;
            throw new IllegalStateException("Table is full!");
        }
        ++this.modCount;
        table[index] = new Node<K, V>(key, hash, value);
        if (++this.size >= this.threshold) {
            this.resize(length);
        }
        return null;
    }

    private void resize(int from) {
        Node<K, V>[] old;
        int newLength = from << 1;
        if (newLength > 0x40000000 || newLength <= from) {
            return;
        }
        Node[] newTable = new Node[newLength];
        for (Node<K, V> e : old = this.table) {
            if (e == null) continue;
            int index = EquivalentHashMap.index(e.hash, newLength);
            while (newTable[index] != null) {
                index = EquivalentHashMap.nextIndex(index, newLength);
            }
            newTable[index] = e;
        }
        this.threshold = (int)(this.loadFactor * (float)newLength);
        this.table = newTable;
    }

    @Override
    public V remove(Object key) {
        int start;
        EquivalentHashMap.assertKeyNotNull(key);
        Node<K, V>[] table = this.table;
        int length = table.length;
        int hash = EquivalentHashMap.spread(this.keyEq.hashCode(key));
        int index = start = EquivalentHashMap.index(hash, length);
        do {
            Node<K, V> e;
            if ((e = table[index]) == null) {
                return null;
            }
            if (e.hash != hash || !this.keyEq.equals(e.key, key)) continue;
            table[index] = null;
            this.relocate(index);
            ++this.modCount;
            --this.size;
            return e.value;
        } while ((index = EquivalentHashMap.nextIndex(index, length)) != start);
        return null;
    }

    private void relocate(int start) {
        Node<K, V>[] table = this.table;
        int length = table.length;
        int current = EquivalentHashMap.nextIndex(start, length);
        Node<K, V> e;
        while ((e = table[current]) != null) {
            int prefer = EquivalentHashMap.index(e.hash, length);
            if (current < prefer && (prefer <= start || start <= current) || prefer <= start && start <= current) {
                table[start] = e;
                table[current] = null;
                start = current;
            }
            current = EquivalentHashMap.nextIndex(current, length);
        }
        return;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int size = map.size();
        if (size == 0) {
            return;
        }
        if (size > this.threshold) {
            int length;
            if (size > 0x40000000) {
                size = 0x40000000;
            }
            for (length = this.table.length; length < size; length <<= 1) {
            }
            this.resize(length);
        }
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        Node<K, V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !this.valueEq.equals(value, m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private static int spread(int hashCode) {
        hashCode ^= hashCode >>> 20 ^ hashCode >>> 12;
        return hashCode ^ hashCode >>> 7 ^ hashCode >>> 4;
    }

    private static int index(int hashCode, int length) {
        return hashCode & length - 1;
    }

    private static int nextIndex(int index, int length) {
        index = index >= length - 1 ? 0 : index + 1;
        return index;
    }

    static /* synthetic */ Node[] access$700(EquivalentHashMap x0) {
        return x0.table;
    }

    private static final class Node<K, V> {
        final K key;
        final int hash;
        final V value;

        Node(K key, int hash, V value) {
            this.key = key;
            this.hash = hash;
            this.value = value;
        }
    }

    private final class EntryIterator
    extends EquivalentHashMapIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    public class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = EquivalentHashMap.this.get(entry.getKey());
            return EquivalentHashMap.this.valueEq.equals(value, entry.getValue());
        }

        @Override
        public void clear() {
            EquivalentHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return EquivalentHashMap.this.isEmpty();
        }

        @Override
        public int size() {
            return EquivalentHashMap.this.size();
        }
    }

    private class ValueIterator
    extends EquivalentHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    public final class Values
    extends AbstractCollection<V> {
        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EquivalentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return EquivalentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            EquivalentHashMap.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            if (o != null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (!EquivalentHashMap.this.valueEq.equals(it.next(), o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }
    }

    private abstract class EquivalentHashMapIterator<E>
    implements Iterator<E> {
        private int next = 0;
        private int expectedCount = EquivalentHashMap.access$600(EquivalentHashMap.this);
        private int current = -1;
        private boolean hasNext;
        Node<K, V>[] table = EquivalentHashMap.access$700(EquivalentHashMap.this);

        private EquivalentHashMapIterator() {
        }

        @Override
        public final boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            Node<K, V>[] table = this.table;
            for (int i = this.next; i < table.length; ++i) {
                if (table[i] == null) continue;
                this.next = i;
                this.hasNext = true;
                return true;
            }
            this.next = table.length;
            return false;
        }

        final Map.Entry<K, V> nextEntry() {
            if (EquivalentHashMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.hasNext = false;
            Node node = this.table[this.current];
            return new MapEntry(node.key, node.value, EquivalentHashMap.this);
        }

        @Override
        public void remove() {
            if (EquivalentHashMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            int current = this.current;
            if (current == -1) {
                throw new IllegalStateException();
            }
            this.current = -1;
            this.next = current;
            EquivalentHashMap.this.remove(this.table[current].key);
            this.expectedCount = EquivalentHashMap.this.modCount;
        }
    }

    private final class KeyIterator
    extends EquivalentHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return EquivalentHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EquivalentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            EquivalentHashMap.this.remove(o);
            return this.size() < size;
        }

        @Override
        public void clear() {
            EquivalentHashMap.this.clear();
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final EquivalentHashMap<K, V> map;

        MapEntry(K key, V val, EquivalentHashMap<K, V> map) {
            this.key = key;
            this.val = val;
            this.map = map;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V v = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return v;
        }

        @Override
        public final int hashCode() {
            return ((EquivalentHashMap)this.map).keyEq.hashCode(this.key) ^ ((EquivalentHashMap)this.map).valueEq.hashCode(this.val);
        }

        public final String toString() {
            return ((EquivalentHashMap)this.map).keyEq.toString(this.key) + "=" + ((EquivalentHashMap)this.map).valueEq.toString(this.val);
        }

        @Override
        public final boolean equals(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !((EquivalentHashMap)this.map).keyEq.equals(this.key, k) || v != this.val && !((EquivalentHashMap)this.map).valueEq.equals(this.val, v));
        }
    }
}

