/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.util.AnyEquivalence;
import org.infinispan.util.ByRef;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.util.concurrent.locks.RefCountingLock;
import org.infinispan.util.concurrent.locks.containers.AbstractLockContainer;
import org.infinispan.util.logging.Log;

public abstract class AbstractPerEntryLockContainer<L extends RefCountingLock>
extends AbstractLockContainer<L> {
    protected final EquivalentConcurrentHashMapV8<Object, L> locks;

    protected AbstractPerEntryLockContainer(int concurrencyLevel) {
        this.locks = new EquivalentConcurrentHashMapV8(16, concurrencyLevel, AnyEquivalence.getInstance(), AnyEquivalence.getInstance());
    }

    protected abstract L newLock();

    @Override
    public final L getLock(Object key) {
        return (L)((RefCountingLock)this.locks.get(key));
    }

    @Override
    public int getNumLocksHeld() {
        return this.locks.size();
    }

    @Override
    public int size() {
        return this.locks.size();
    }

    @Override
    public L acquireLock(final Object lockOwner, Object key, long timeout, TimeUnit unit) throws InterruptedException {
        final ByRef<Boolean> lockAcquired = ByRef.create(Boolean.FALSE);
        RefCountingLock lock = (RefCountingLock)this.locks.compute(key, new EquivalentConcurrentHashMapV8.BiFun<Object, L, L>(){

            @Override
            public L apply(Object key, L lock) {
                if (lock == null) {
                    Log log = AbstractPerEntryLockContainer.this.getLog();
                    if (log.isTraceEnabled()) {
                        log.tracef("Creating and acquiring new lock instance for key %s", Util.toStr(key));
                    }
                    lock = AbstractPerEntryLockContainer.this.newLock();
                    AbstractPerEntryLockContainer.this.lock(lock, lockOwner);
                    lockAcquired.set(Boolean.TRUE);
                    return lock;
                }
                int refCount = lock.getReferenceCounter().incrementAndGet();
                if (refCount <= 1) {
                    throw new IllegalStateException("Lock " + key + " acquired although it should have been removed: " + lock);
                }
                return lock;
            }
        });
        if (!lockAcquired.get().booleanValue()) {
            lockAcquired.set(this.tryLock(lock, timeout, unit, lockOwner));
        }
        if (lockAcquired.get().booleanValue()) {
            return (L)lock;
        }
        this.getLog().tracef("Timed out attempting to acquire lock for key %s after %s", key, Util.prettyPrintTime(timeout, unit));
        this.locks.computeIfPresent(key, new EquivalentConcurrentHashMapV8.BiFun<Object, L, L>(){

            @Override
            public L apply(Object key, L lock) {
                boolean remove = lock.getReferenceCounter().decrementAndGet() == 0;
                return remove ? null : (Object)lock;
            }
        });
        return null;
    }

    @Override
    public void releaseLock(final Object lockOwner, Object key) {
        this.locks.computeIfPresent(key, new EquivalentConcurrentHashMapV8.BiFun<Object, L, L>(){

            @Override
            public L apply(Object key, L lock) {
                boolean remove;
                Log log = AbstractPerEntryLockContainer.this.getLog();
                if (log.isTraceEnabled()) {
                    log.tracef("Unlocking lock instance for key %s", Util.toStr(key));
                }
                AbstractPerEntryLockContainer.this.unlock(lock, lockOwner);
                int refCount = lock.getReferenceCounter().decrementAndGet();
                boolean bl = remove = refCount == 0;
                if (refCount < 0) {
                    throw new IllegalStateException("Negative reference count for lock " + key + ": " + lock);
                }
                return remove ? null : (Object)lock;
            }
        });
    }

    @Override
    public int getLockId(Object key) {
        Lock lock = this.getLock(key);
        return lock == null ? -1 : System.identityHashCode(lock);
    }

    public String toString() {
        return "AbstractPerEntryLockContainer{locks=" + this.locks + '}';
    }
}

