/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.api.jms.management.DestinationControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.management.impl.AbstractControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerSession;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.server.HornetQJMSServerLogger;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class JMSServerControlImpl
extends AbstractControl
implements JMSServerControl,
NotificationEmitter {
    private final JMSServerManager server;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    private static String[] convert(Object[] jndiBindings) {
        String[] bindings = new String[jndiBindings.length];
        int jndiBindingsLength = jndiBindings.length;
        for (int i = 0; i < jndiBindingsLength; ++i) {
            bindings[i] = jndiBindings[i].toString().trim();
        }
        return bindings;
    }

    private static String[] toArray(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return new String[0];
        }
        String[] values = commaSeparatedString.split(",");
        String[] trimmed = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            trimmed[i] = values[i].trim();
            trimmed[i] = trimmed[i].replace("&comma;", ",");
        }
        return trimmed;
    }

    private static String[] determineJMSDestination(String coreAddress) {
        String[] result = new String[2];
        if (coreAddress.startsWith("jms.queue.")) {
            result[0] = coreAddress.substring("jms.queue.".length());
            result[1] = "queue";
        } else if (coreAddress.startsWith("jms.tempqueue.")) {
            result[0] = coreAddress.substring("jms.tempqueue.".length());
            result[1] = "tempqueue";
        } else if (coreAddress.startsWith("jms.topic.")) {
            result[0] = coreAddress.substring("jms.topic.".length());
            result[1] = "topic";
        } else if (coreAddress.startsWith("jms.temptopic.")) {
            result[0] = coreAddress.substring("jms.temptopic.".length());
            result[1] = "temptopic";
        } else {
            HornetQJMSServerLogger.LOGGER.debug("JMSServerControlImpl.determineJMSDestination()" + coreAddress);
            return null;
        }
        return result;
    }

    public static MBeanNotificationInfo[] getNotificationInfos() {
        NotificationType[] values = NotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, JMSServerControl.class.getName(), "Notifications emitted by a JMS Server")};
    }

    public JMSServerControlImpl(JMSServerManager server) throws Exception {
        super(JMSServerControl.class, server.getHornetQServer().getStorageManager());
        this.server = server;
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String[] connectorNames, Object[] bindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (useDiscovery) {
                if (connectorNames == null || connectorNames.length == 0) {
                    throw new IllegalArgumentException("no discovery group name supplied");
                }
                this.server.createConnectionFactory(name, ha, JMSFactoryType.valueOf((int)cfType), connectorNames[0], JMSServerControlImpl.convert(bindings));
            } else {
                ArrayList<String> connectorList = new ArrayList<String>(connectorNames.length);
                for (String str : connectorNames) {
                    connectorList.add(str);
                }
                this.server.createConnectionFactory(name, ha, JMSFactoryType.valueOf((int)cfType), connectorList, JMSServerControlImpl.convert(bindings));
            }
            this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String connectors, String jndiBindings, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, int minLargeMessageSize, boolean compressLargeMessages, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId) throws Exception {
        this.createConnectionFactory(name, ha, useDiscovery, cfType, JMSServerControlImpl.toArray(connectors), JMSServerControlImpl.toArray(jndiBindings), clientID, clientFailureCheckPeriod, connectionTTL, callTimeout, callFailoverTimeout, minLargeMessageSize, compressLargeMessages, consumerWindowSize, consumerMaxRate, confirmationWindowSize, producerWindowSize, producerMaxRate, blockOnAcknowledge, blockOnDurableSend, blockOnNonDurableSend, autoGroup, preAcknowledge, loadBalancingPolicyClassName, transactionBatchSize, dupsOKBatchSize, useGlobalPools, scheduledThreadPoolMaxSize, threadPoolMaxSize, retryInterval, retryIntervalMultiplier, maxRetryInterval, reconnectAttempts, failoverOnInitialConnection, groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String[] connectorNames, String[] bindings, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, int minLargeMessageSize, boolean compressLargeMessages, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, ha, bindings);
            if (useDiscovery) {
                configuration.setDiscoveryGroupName(connectorNames[0]);
            } else {
                ArrayList<String> connectorNamesList = new ArrayList<String>();
                for (String nameC : connectorNames) {
                    connectorNamesList.add(nameC);
                }
                configuration.setConnectorNames(connectorNamesList);
            }
            configuration.setFactoryType(JMSFactoryType.valueOf((int)cfType));
            configuration.setClientID(clientID);
            configuration.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            configuration.setConnectionTTL(connectionTTL);
            configuration.setCallTimeout(callTimeout);
            configuration.setCallFailoverTimeout(callFailoverTimeout);
            configuration.setMinLargeMessageSize(minLargeMessageSize);
            configuration.setCompressLargeMessages(compressLargeMessages);
            configuration.setConsumerWindowSize(consumerWindowSize);
            configuration.setConsumerMaxRate(consumerMaxRate);
            configuration.setConfirmationWindowSize(confirmationWindowSize);
            configuration.setProducerWindowSize(producerWindowSize);
            configuration.setProducerMaxRate(producerMaxRate);
            configuration.setBlockOnAcknowledge(blockOnAcknowledge);
            configuration.setBlockOnDurableSend(blockOnDurableSend);
            configuration.setBlockOnNonDurableSend(blockOnNonDurableSend);
            configuration.setAutoGroup(autoGroup);
            configuration.setPreAcknowledge(preAcknowledge);
            if (loadBalancingPolicyClassName == null || loadBalancingPolicyClassName.trim().equals("")) {
                loadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
            }
            configuration.setLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            configuration.setTransactionBatchSize(transactionBatchSize);
            configuration.setDupsOKBatchSize(dupsOKBatchSize);
            configuration.setUseGlobalPools(useGlobalPools);
            configuration.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            configuration.setThreadPoolMaxSize(threadPoolMaxSize);
            configuration.setRetryInterval(retryInterval);
            configuration.setRetryIntervalMultiplier(retryIntervalMultiplier);
            configuration.setMaxRetryInterval(maxRetryInterval);
            configuration.setReconnectAttempts(reconnectAttempts);
            configuration.setFailoverOnInitialConnection(failoverOnInitialConnection);
            configuration.setGroupID(groupId);
            this.server.createConnectionFactory(true, configuration, bindings);
            this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String connectors, String jndiBindings) throws Exception {
        this.createConnectionFactory(name, ha, useDiscovery, cfType, JMSServerControlImpl.toArray(connectors), JMSServerControlImpl.toArray(jndiBindings));
    }

    public boolean createQueue(String name) throws Exception {
        return this.createQueue(name, null, null, true);
    }

    public boolean createQueue(String name, String jndiBindings) throws Exception {
        return this.createQueue(name, jndiBindings, null, true);
    }

    public boolean createQueue(String name, String jndiBindings, String selector) throws Exception {
        return this.createQueue(name, jndiBindings, selector, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String name, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String jndiBindings, @Parameter(name="selector", desc="the jms selector") String selector, @Parameter(name="durable", desc="is the queue persistent and resilient to restart") boolean durable) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean created = this.server.createQueue(true, name, selector, durable, JMSServerControlImpl.toArray(jndiBindings));
            if (created) {
                this.sendNotification(NotificationType.QUEUE_CREATED, name);
            }
            boolean bl = created;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyQueue(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyQueue(name);
            if (destroyed) {
                this.sendNotification(NotificationType.QUEUE_DESTROYED, name);
            }
            boolean bl = destroyed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean createTopic(String name) throws Exception {
        return this.createTopic(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTopic(String topicName, String jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean created = this.server.createTopic(true, topicName, JMSServerControlImpl.toArray(jndiBindings));
            if (created) {
                this.sendNotification(NotificationType.TOPIC_CREATED, topicName);
            }
            boolean bl = created;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyTopic(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyTopic(name);
            if (destroyed) {
                this.sendNotification(NotificationType.TOPIC_DESTROYED, name);
            }
            boolean bl = destroyed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnectionFactory(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyConnectionFactory(name);
            if (destroyed) {
                this.sendNotification(NotificationType.CONNECTION_FACTORY_DESTROYED, name);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public String getVersion() {
        this.checkStarted();
        return this.server.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueueNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] queueControls = this.server.getHornetQServer().getManagementService().getResources(JMSQueueControl.class);
            String[] names = new String[queueControls.length];
            for (int i = 0; i < queueControls.length; ++i) {
                JMSQueueControl queueControl = (JMSQueueControl)queueControls[i];
                names[i] = queueControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTopicNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] topicControls = this.server.getHornetQServer().getManagementService().getResources(TopicControl.class);
            String[] names = new String[topicControls.length];
            for (int i = 0; i < topicControls.length; ++i) {
                TopicControl topicControl = (TopicControl)topicControls[i];
                names[i] = topicControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionFactoryNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] cfControls = this.server.getHornetQServer().getManagementService().getResources(ConnectionFactoryControl.class);
            String[] names = new String[cfControls.length];
            for (int i = 0; i < cfControls.length; ++i) {
                ConnectionFactoryControl cfControl = (ConnectionFactoryControl)cfControls[i];
                names[i] = cfControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return JMSServerControlImpl.getNotificationInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses(ipAddress);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.closeConnectionsForAddress(ipAddress);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listConnectionIDs() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listConnectionIDs();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConnectionsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            Set connections = this.server.getHornetQServer().getRemotingService().getConnections();
            Set sessions = this.server.getHornetQServer().getSessions();
            HashMap<Object, ServerSession> jmsSessions = new HashMap<Object, ServerSession>();
            for (ServerSession session : sessions) {
                if (session.getMetaData("jms-session") == null) continue;
                jmsSessions.put(session.getConnectionID(), session);
            }
            for (RemotingConnection connection : connections) {
                ServerSession session = (ServerSession)jmsSessions.get(connection.getID());
                if (session == null) continue;
                JSONObject obj = new JSONObject();
                obj.put("connectionID", (Object)connection.getID().toString());
                obj.put("clientAddress", (Object)connection.getRemoteAddress());
                obj.put("creationTime", connection.getCreationTime());
                obj.put("clientID", (Object)session.getMetaData("jms-client-id"));
                obj.put("principal", (Object)session.getUsername());
                array.put((Object)obj);
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumersAsJSON(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            Set connections = this.server.getHornetQServer().getRemotingService().getConnections();
            for (RemotingConnection connection : connections) {
                if (!connectionID.equals(connection.getID().toString())) continue;
                List sessions = this.server.getHornetQServer().getSessions(connectionID);
                for (ServerSession session : sessions) {
                    Set consumers = session.getServerConsumers();
                    for (ServerConsumer consumer : consumers) {
                        JSONObject obj = this.toJSONObject(consumer);
                        if (obj == null) continue;
                        array.put((Object)obj);
                    }
                }
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAllConsumersAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            Set sessions = this.server.getHornetQServer().getSessions();
            for (ServerSession session : sessions) {
                Set consumers = session.getServerConsumers();
                for (ServerConsumer consumer : consumers) {
                    JSONObject obj = this.toJSONObject(consumer);
                    if (obj == null) continue;
                    array.put((Object)obj);
                }
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSessions(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listSessions(connectionID);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listPreparedTransactionDetailsAsJSON();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listPreparedTransactionDetailsAsHTML();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(JMSServerControl.class);
    }

    private void sendNotification(NotificationType type, String message) {
        Notification notif = new Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), message);
        this.broadcaster.sendNotification(notif);
    }

    private void checkStarted() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("HornetQ JMS Server is not started. it can not be managed yet");
        }
    }

    public String[] listTargetDestinations(String sessionID) throws Exception {
        Object[] topicControls;
        Object[] queueControls;
        String[] addresses = this.server.getHornetQServer().getHornetQServerControl().listTargetAddresses(sessionID);
        HashMap<String, Object> allDests = new HashMap<String, Object>();
        for (Object queueControl2 : queueControls = this.server.getHornetQServer().getManagementService().getResources(JMSQueueControl.class)) {
            JMSQueueControl queueControl = (JMSQueueControl)queueControl2;
            allDests.put(queueControl.getAddress(), queueControl);
        }
        for (Object topicControl2 : topicControls = this.server.getHornetQServer().getManagementService().getResources(TopicControl.class)) {
            TopicControl topicControl = (TopicControl)topicControl2;
            allDests.put(topicControl.getAddress(), topicControl);
        }
        ArrayList<String> destinations = new ArrayList<String>();
        for (String addresse : addresses) {
            DestinationControl control = (DestinationControl)allDests.get(addresse);
            if (control == null) continue;
            destinations.add(control.getAddress());
        }
        return destinations.toArray(new String[0]);
    }

    public String getLastSentMessageID(String sessionID, String address) throws Exception {
        ServerSession session = this.server.getHornetQServer().getSessionByID(sessionID);
        if (session != null) {
            return session.getLastSentMessageID(address);
        }
        return null;
    }

    public String getSessionCreationTime(String sessionID) throws Exception {
        ServerSession session = this.server.getHornetQServer().getSessionByID(sessionID);
        if (session != null) {
            return String.valueOf(session.getCreationTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSessionsAsJSON(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        JSONArray array = new JSONArray();
        try {
            List sessions = this.server.getHornetQServer().getSessions(connectionID);
            for (ServerSession sess : sessions) {
                JSONObject obj = new JSONObject();
                obj.put("sessionID", (Object)sess.getName());
                obj.put("creationTime", sess.getCreationTime());
                array.put((Object)obj);
            }
        }
        finally {
            this.blockOnIO();
        }
        return array.toString();
    }

    public String closeConnectionWithClientID(String clientID) throws Exception {
        return this.server.getHornetQServer().destroyConnectionWithSessionMetadata("jms-client-id", clientID);
    }

    private JSONObject toJSONObject(ServerConsumer consumer) throws Exception {
        String[] destinationInfo;
        JSONObject obj = new JSONObject();
        obj.put("consumerID", consumer.getID());
        obj.put("connectionID", consumer.getConnectionID());
        obj.put("sessionID", (Object)consumer.getSessionID());
        obj.put("queueName", (Object)consumer.getQueue().getName().toString());
        obj.put("browseOnly", consumer.isBrowseOnly());
        obj.put("creationTime", consumer.getCreationTime());
        Filter queueFilter = consumer.getQueue().getFilter();
        if (queueFilter != null) {
            obj.put("filter", (Object)queueFilter.getFilterString().toString());
        }
        if ((destinationInfo = JMSServerControlImpl.determineJMSDestination(consumer.getQueue().getAddress().toString())) == null) {
            return null;
        }
        obj.put("destinationName", (Object)destinationInfo[0]);
        obj.put("destinationType", (Object)destinationInfo[1]);
        if (destinationInfo[1].equals("topic")) {
            try {
                HornetQDestination.decomposeQueueNameForDurableSubscription((String)consumer.getQueue().getName().toString());
                obj.put("durable", true);
            }
            catch (IllegalArgumentException e) {
                obj.put("durable", false);
            }
        } else {
            obj.put("durable", false);
        }
        return obj;
    }

    public static enum NotificationType {
        QUEUE_CREATED,
        QUEUE_DESTROYED,
        TOPIC_CREATED,
        TOPIC_DESTROYED,
        CONNECTION_FACTORY_CREATED,
        CONNECTION_FACTORY_DESTROYED;

    }
}

