/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryStorageException;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.framework.Version;
import org.osgi.service.repository.RepositoryContent;

public final class MavenResourceHandler {
    public XResource toBundleResource(XResource resource) {
        return this.toBundleResource(resource, null, null);
    }

    public XResource toBundleResource(XResource resource, String symbolicName, Version version) {
        Manifest manifest;
        XResourceBuilder<XResource> builder;
        if (resource == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("resource");
        }
        XCapability ccap = (XCapability)resource.getCapabilities("osgi.content").iterator().next();
        String urlspec = (String)ccap.getAttribute("url");
        InputStream content = ((RepositoryContent)resource).getContent();
        try {
            builder = URLResourceBuilderFactory.create(new URL(urlspec), ccap.getAttributes());
            manifest = new JarInputStream(content).getManifest();
        }
        catch (IOException ex) {
            throw RepositoryMessages.MESSAGES.invalidMavenResource(ex, resource);
        }
        finally {
            this.safeClose(content);
        }
        if (OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest)) {
            OSGiMetaData metaData = OSGiMetaDataBuilder.load((Manifest)manifest);
            builder.loadFrom(metaData);
            return builder.getResource();
        }
        if (symbolicName == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("symbolicName");
        }
        if (version == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("version");
        }
        LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
        content = ((RepositoryContent)resource).getContent();
        try {
            JarInputStream jar = new JarInputStream(content);
            JarEntry jarEntry = jar.getNextJarEntry();
            while (jarEntry != null) {
                String packageName;
                String entryName = jarEntry.getName();
                if (entryName.endsWith(".class") && (packageName = entryName.substring(0, entryName.lastIndexOf(47))).indexOf("internal") < 0) {
                    packageNames.add(packageName);
                }
                jarEntry = jar.getNextJarEntry();
            }
        }
        catch (IOException ex) {
            throw RepositoryMessages.MESSAGES.invalidMavenResource(ex, resource);
        }
        finally {
            this.safeClose(content);
        }
        OSGiMetaDataBuilder mdbuilder = OSGiMetaDataBuilder.createBuilder((String)symbolicName, (Version)version);
        for (String packageName : packageNames) {
            mdbuilder.addExportPackages(new String[]{packageName + ";version='" + version + "'"});
        }
        OSGiMetaData metaData = mdbuilder.getOSGiMetaData();
        builder.loadFrom(metaData);
        return builder.getResource();
    }

    public XResource toModuleResource(XResource resource, ModuleIdentifier moduleId) throws RepositoryStorageException {
        XResourceBuilder<XResource> builder;
        if (resource == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("resource");
        }
        if (moduleId == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("moduleId");
        }
        XCapability ccap = (XCapability)resource.getCapabilities("osgi.content").iterator().next();
        String urlspec = (String)ccap.getAttribute("url");
        InputStream content = ((RepositoryContent)resource).getContent();
        try {
            builder = URLResourceBuilderFactory.create(new URL(urlspec), ccap.getAttributes());
        }
        catch (IOException ex) {
            throw RepositoryMessages.MESSAGES.invalidMavenResource(ex, resource);
        }
        finally {
            this.safeClose(content);
        }
        builder.addIdentityCapability(moduleId);
        return builder.getResource();
    }

    private void safeClose(InputStream content) {
        try {
            if (content != null) {
                content.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

