/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.osgi.repository.AttributeValueHandler;
import org.jboss.osgi.repository.Namespace100;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryWriter;
import org.jboss.osgi.resolver.XResource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class RepositoryXMLWriter
implements RepositoryWriter {
    private final XMLStreamWriter writer;

    public static RepositoryWriter create(OutputStream output) {
        return new RepositoryXMLWriter(output);
    }

    private RepositoryXMLWriter(OutputStream output) {
        try {
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
        }
        catch (Exception ex) {
            throw RepositoryMessages.MESSAGES.cannotInitializeRepositoryWriter(ex);
        }
    }

    @Override
    public void writeRepositoryElement(Map<String, String> attributes) {
        try {
            this.writer.writeStartDocument();
            this.writer.setDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
            this.writer.writeStartElement(Namespace100.Element.REPOSITORY.getLocalName());
            this.writer.writeDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.writer.writeAttribute(entry.getKey(), entry.getValue());
            }
        }
        catch (XMLStreamException ex) {
            throw RepositoryMessages.MESSAGES.cannotWriteRepositoryElement(ex);
        }
    }

    @Override
    public void writeResource(XResource resource) {
        try {
            this.writer.writeStartElement(Namespace100.Element.RESOURCE.getLocalName());
            for (Map.Entry entry : resource.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.writer.writeAttribute(key, "" + value);
            }
            for (Capability cap : resource.getCapabilities(null)) {
                this.writer.writeStartElement(Namespace100.Element.CAPABILITY.getLocalName());
                this.writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), cap.getNamespace());
                this.writeAttributes(cap.getAttributes());
                this.writeDirectives(cap.getDirectives());
                this.writer.writeEndElement();
            }
            for (Requirement req : resource.getRequirements(null)) {
                this.writer.writeStartElement(Namespace100.Element.REQUIREMENT.getLocalName());
                this.writer.writeAttribute(Namespace100.Attribute.NAMESPACE.getLocalName(), req.getNamespace());
                this.writeAttributes(req.getAttributes());
                this.writeDirectives(req.getDirectives());
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw RepositoryMessages.MESSAGES.cannotWriteRepositoryElement(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException ex) {
            throw RepositoryMessages.MESSAGES.cannotWriteRepositoryElement(ex);
        }
    }

    private void writeAttributes(Map<String, Object> attributes) throws XMLStreamException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            AttributeValueHandler.AttributeValue attval = AttributeValueHandler.AttributeValue.create(entry.getValue());
            this.writer.writeStartElement(Namespace100.Element.ATTRIBUTE.getLocalName());
            this.writer.writeAttribute(Namespace100.Attribute.NAME.getLocalName(), entry.getKey());
            if (attval.isListType()) {
                this.writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), attval.getValueString());
                this.writer.writeAttribute(Namespace100.Attribute.TYPE.getLocalName(), "List<" + (Object)((Object)attval.getType()) + ">");
            } else {
                this.writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), attval.getValueString());
                if (attval.getType() != Namespace100.Type.String) {
                    this.writer.writeAttribute(Namespace100.Attribute.TYPE.getLocalName(), attval.getType().toString());
                }
            }
            this.writer.writeEndElement();
        }
    }

    private void writeDirectives(Map<String, String> directives) throws XMLStreamException {
        for (Map.Entry<String, String> entry : directives.entrySet()) {
            this.writer.writeStartElement(Namespace100.Element.DIRECTIVE.getLocalName());
            this.writer.writeAttribute(Namespace100.Attribute.NAME.getLocalName(), entry.getKey());
            this.writer.writeAttribute(Namespace100.Attribute.VALUE.getLocalName(), entry.getValue());
            this.writer.writeEndElement();
        }
    }
}

