/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.spi;

import java.util.Collection;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryStorageFactory;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.AbstractRepository;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class AbstractPersistentRepository
extends AbstractRepository
implements XPersistentRepository {
    private final RepositoryStorage storage;
    private XRepository delegate;

    public AbstractPersistentRepository(RepositoryStorageFactory factory) {
        this(factory, null);
    }

    public AbstractPersistentRepository(RepositoryStorageFactory factory, XRepository delegate) {
        if (factory == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("factory");
        }
        this.storage = factory.create(this);
        this.delegate = delegate;
    }

    @Override
    public RepositoryStorage getRepositoryStorage() {
        return this.storage;
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        if (req == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("req");
        }
        Collection<Capability> providers = this.storage.findProviders(req);
        if (providers.isEmpty() && this.delegate != null) {
            providers = this.delegate.findProviders(req);
        }
        return providers;
    }
}

