/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.spi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.osgi.repository.RepositoryLogger;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.AbstractRepository;
import org.jboss.osgi.repository.spi.SecurityActions;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.osgi.framework.Filter;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class MavenDelegateRepository
extends AbstractRepository
implements XRepository {
    private final URL[] baserepos;

    public MavenDelegateRepository() {
        this(new ConfigurationPropertyProvider(){

            @Override
            public String getProperty(String key, String defaultValue) {
                return SecurityActions.getSystemProperty(key, defaultValue);
            }
        });
    }

    public MavenDelegateRepository(ConfigurationPropertyProvider provider) {
        this(MavenDelegateRepository.getDefaultConfiguration(provider));
    }

    public MavenDelegateRepository(Configuration configuration) {
        ArrayList<URL> repos = new ArrayList<URL>();
        for (URL baseURL : configuration.getBaseURLs()) {
            repos.add(baseURL);
        }
        this.baserepos = repos.toArray(new URL[repos.size()]);
    }

    public static Configuration getDefaultConfiguration(final ConfigurationPropertyProvider provider) {
        return new Configuration(){

            @Override
            public List<URL> getBaseURLs() {
                ArrayList<URL> result = new ArrayList<URL>();
                String property = provider.getProperty("org.jboss.osgi.repository.maven.base.urls", null);
                if (property == null) {
                    property = "";
                    String userhome = SecurityActions.getSystemProperty("user.home", "");
                    File localrepo = new File(userhome + File.separator + ".m2" + File.separator + "repository");
                    if (localrepo.isDirectory()) {
                        property = property + localrepo.toURI().toString() + ",";
                    }
                    property = property + "http://repository.jboss.org/nexus/content/groups/public,";
                    property = property + "http://repo1.maven.org/maven2";
                }
                for (String urlspec : property.split(",")) {
                    result.add(MavenDelegateRepository.getBaseURL(urlspec));
                }
                return Collections.unmodifiableList(result);
            }
        };
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        ArrayList<Capability> result = new ArrayList<Capability>();
        if ("maven.identity".equals(namespace)) {
            MavenCoordinates mavenId;
            if (req.getDirectives().get("filter") != null) {
                Filter filter = ((XRequirement)req).getFilter();
                String gpart = AbstractRequirement.getValueFromFilter((Filter)filter, (String)"groupId", null);
                String apart = AbstractRequirement.getValueFromFilter((Filter)filter, (String)"artifactId", null);
                String tpart = AbstractRequirement.getValueFromFilter((Filter)filter, (String)"type", null);
                String vpart = AbstractRequirement.getValueFromFilter((Filter)filter, (String)"version", null);
                String cpart = AbstractRequirement.getValueFromFilter((Filter)filter, (String)"classifier", null);
                mavenId = MavenCoordinates.create((String)gpart, (String)apart, (String)vpart, (String)tpart, (String)cpart);
            } else {
                String nsvalue = (String)req.getAttributes().get("maven.identity");
                mavenId = MavenCoordinates.parse((String)nsvalue);
            }
            RepositoryLogger.LOGGER.infoFindMavenProviders(mavenId);
            for (URL baseURL : this.baserepos) {
                URL url = mavenId.getArtifactURL(baseURL);
                try {
                    url.openStream().close();
                }
                catch (IOException e) {
                    RepositoryLogger.LOGGER.debugf("Cannot access input stream for: %s", url);
                    continue;
                }
                try {
                    XResourceBuilder<XResource> builder = URLResourceBuilderFactory.create(url, null);
                    XIdentityCapability icap = builder.addIdentityCapability(mavenId);
                    XResource resource = builder.getResource();
                    RepositoryLogger.LOGGER.infoFoundMavenResource(resource);
                    result.add((Capability)icap);
                    break;
                }
                catch (Exception ex) {
                    RepositoryLogger.LOGGER.errorCannotCreateResource(ex, mavenId);
                }
            }
        }
        return result;
    }

    private static URL getBaseURL(String urlspec) {
        try {
            return new URL(urlspec);
        }
        catch (MalformedURLException e) {
            throw RepositoryMessages.MESSAGES.invalidRepositoryBase(urlspec);
        }
    }

    public static interface ConfigurationPropertyProvider {
        public String getProperty(String var1, String var2);
    }

    public static interface Configuration {
        public static final String JBOSS_NEXUS_BASE = "http://repository.jboss.org/nexus/content/groups/public";
        public static final String MAVEN_CENTRAL_BASE = "http://repo1.maven.org/maven2";

        public List<URL> getBaseURLs();
    }
}

