/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.internal.AbstractLoadQueryImpl;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.loader.spi.LoadQueryAliasResolutionContext;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;

public abstract class AbstractEntityLoadQueryImpl
extends AbstractLoadQueryImpl {
    private final EntityReturn entityReturn;

    public AbstractEntityLoadQueryImpl(EntityReturn entityReturn, List<JoinableAssociation> associations) {
        super(associations);
        this.entityReturn = entityReturn;
    }

    protected final String generateSql(String whereString, String orderByString, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryAliasResolutionContext aliasResolutionContext) throws MappingException {
        return this.generateSql(null, whereString, orderByString, "", lockOptions, factory, aliasResolutionContext);
    }

    private String generateSql(String projection, String condition, String orderBy, String groupBy, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryAliasResolutionContext aliasResolutionContext) throws MappingException {
        JoinFragment ojf = this.mergeOuterJoins(factory, aliasResolutionContext);
        String entityReturnAlias = this.resolveEntityReturnAlias(aliasResolutionContext);
        Select select = new Select(factory.getDialect()).setLockOptions(lockOptions).setSelectClause(projection == null ? this.getPersister().selectFragment(entityReturnAlias, aliasResolutionContext.resolveEntityColumnAliases(this.entityReturn).getSuffix()) + this.associationSelectString(aliasResolutionContext) : projection).setFromClause(factory.getDialect().appendLockHint(lockOptions, this.getPersister().fromTableFragment(entityReturnAlias)) + this.getPersister().fromJoinFragment(entityReturnAlias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + this.getWhereFragment(aliasResolutionContext)).setOrderByClause(this.orderBy(orderBy, aliasResolutionContext)).setGroupByClause(groupBy);
        if (factory.getSettings().isCommentsEnabled()) {
            select.setComment(this.getComment());
        }
        return select.toStatementString();
    }

    protected String getWhereFragment(LoadQueryAliasResolutionContext aliasResolutionContext) throws MappingException {
        return this.getPersister().whereJoinFragment(this.resolveEntityReturnAlias(aliasResolutionContext), true, true);
    }

    protected abstract String getComment();

    protected final OuterJoinLoadable getPersister() {
        return (OuterJoinLoadable)this.entityReturn.getEntityPersister();
    }

    protected final String resolveEntityReturnAlias(LoadQueryAliasResolutionContext aliasResolutionContext) {
        return aliasResolutionContext.resolveEntityTableAlias(this.entityReturn);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getPersister().getEntityName() + ')';
    }
}

