/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.felix;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.felix.resolver.ResolverImpl;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.felix.LoggerDelegate;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public final class LoggingResolver
extends ResolverImpl {
    public LoggingResolver() {
        super(new LoggerDelegate());
    }

    @Override
    public Map<Resource, List<Wire>> resolve(ResolveContext context) throws ResolutionException {
        Collection mandatory = context.getMandatoryResources();
        Collection optional = context.getOptionalResources();
        ResolverLogger.LOGGER.debugf("Resolve: %s, %s", (Object)mandatory, (Object)optional);
        Map<Resource, List<Wire>> result = super.resolve(context);
        if (ResolverLogger.LOGGER.isDebugEnabled()) {
            ResolverLogger.LOGGER.debugf("Resolution result: %d", (Object)result.size());
            for (Map.Entry<Resource, List<Wire>> entry : result.entrySet()) {
                Resource res = entry.getKey();
                List<Wire> wires = entry.getValue();
                ResolverLogger.LOGGER.debugf("   %s: %d wires", (Object)res, (Object)wires.size());
                for (Wire wire : wires) {
                    ResolverLogger.LOGGER.debugf("      %s", (Object)wire);
                }
            }
        }
        return result;
    }
}

