/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractResolveContext;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

public class AbstractResolver
implements XResolver {
    private final Resolver delegate;

    public AbstractResolver() {
        ClassLoader classLoader = AbstractResolver.class.getClassLoader();
        ServiceLoader<Resolver> loader = ServiceLoader.load(Resolver.class, classLoader);
        this.delegate = loader.iterator().next();
    }

    @Override
    public XResolveContext createResolveContext(XEnvironment env, Collection<? extends Resource> mandatory, Collection<? extends Resource> optional) {
        final HashSet<Resource> manres = new HashSet<Resource>(mandatory != null ? mandatory : Collections.emptySet());
        final HashSet<Resource> optres = new HashSet<Resource>(optional != null ? optional : Collections.emptySet());
        this.removeUninstalled(manres, optres);
        this.appendOptionalFragments(env, manres, optres);
        this.appendOptionalHostBundles(env, manres, optres);
        return new AbstractResolveContext(env){

            @Override
            public Collection<Resource> getMandatoryResources() {
                return Collections.unmodifiableCollection(manres);
            }

            @Override
            public Collection<Resource> getOptionalResources() {
                return Collections.unmodifiableCollection(optres);
            }
        };
    }

    @Override
    public Map<Resource, List<Wire>> resolve(ResolveContext resolveContext) throws ResolutionException {
        return this.delegate.resolve(resolveContext);
    }

    @Override
    public Map<Resource, List<Wire>> resolveAndApply(XResolveContext context) throws ResolutionException {
        throw new UnsupportedOperationException();
    }

    private void removeUninstalled(Collection<Resource> manres, Collection<Resource> optres) {
        for (Resource res : this.getCombinedResources(manres, optres)) {
            XBundle bundle2;
            if (!(res instanceof XBundleRevision) || (bundle2 = ((XBundleRevision)res).getBundle()) == null || bundle2.getState() != 1) continue;
            manres.remove(res);
            optres.remove(res);
        }
    }

    private void appendOptionalFragments(XEnvironment env, Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashSet<Capability> hostcaps = new HashSet<Capability>();
        HashSet<Resource> combined = this.getCombinedResources(manres, optres);
        for (Resource res : combined) {
            for (Capability hostcap : res.getCapabilities("osgi.wiring.host")) {
                hostcaps.add(hostcap);
            }
        }
        HashSet<XBundleRevision> fragments = new HashSet<XBundleRevision>();
        Iterator<XResource> itres = env.getResources(Collections.singleton("osgi.fragment"));
        while (itres.hasNext()) {
            XBundleRevision brev = (XBundleRevision)itres.next();
            XBundle bundle2 = brev.getBundle();
            if (bundle2 == null || bundle2.getState() == 1) continue;
            XRequirement xreq = (XRequirement)brev.getRequirements("osgi.wiring.host").get(0);
            for (Capability cap : hostcaps) {
                if (!xreq.matches(cap) || combined.contains(brev)) continue;
                fragments.add(brev);
            }
        }
        if (!fragments.isEmpty()) {
            ResolverLogger.LOGGER.debugf("Adding attachable fragments: %s", fragments);
            optres.addAll(fragments);
        }
    }

    private void appendOptionalHostBundles(XEnvironment env, Collection<? extends Resource> manres, Collection<Resource> optres) {
        for (Resource res : this.getCombinedResources(manres, optres)) {
            for (Requirement req : res.getRequirements("osgi.wiring.package")) {
                XPackageRequirement preq = (XPackageRequirement)req;
                if (!preq.isOptional()) continue;
                Iterator<XResource> itres = env.getResources(Collections.singleton("osgi.bundle"));
                while (itres.hasNext()) {
                    XResource brev = itres.next();
                    if (brev.getWiring(false) != null || manres.contains(brev)) continue;
                    optres.add(brev);
                }
                return;
            }
        }
    }

    private HashSet<Resource> getCombinedResources(Collection<? extends Resource> manres, Collection<Resource> optres) {
        HashSet<Resource> combined = new HashSet<Resource>(manres);
        combined.addAll(optres);
        return combined;
    }
}

