/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.resolver.XWiring;
import org.jboss.osgi.resolver.spi.AbstractHostedCapability;
import org.jboss.osgi.resolver.spi.AbstractWire;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.HostedCapability;

public class AbstractWiring
implements XWiring {
    private final XResource resource;
    private final List<Wire> required = new ArrayList<Wire>();
    private final Map<String, List<Wire>> provided = new HashMap<String, List<Wire>>();

    public AbstractWiring(XResource resource, List<Wire> reqwires, List<Wire> provwires) {
        if (resource == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resource");
        }
        this.resource = resource;
        if (reqwires != null) {
            for (Wire wire : reqwires) {
                this.addRequiredWire(wire);
            }
        }
        if (provwires != null) {
            for (Wire wire : provwires) {
                this.addProvidedWire(wire);
            }
        }
    }

    public XResource getResource() {
        return this.resource;
    }

    @Override
    public boolean isEffective() {
        return this.resource.getWiringSupport().isEffective();
    }

    @Override
    public void addRequiredWire(Wire wire) {
        if (wire instanceof AbstractWire) {
            ((XWire)wire).setRequirerWiring(this);
        }
        this.required.add(wire);
    }

    @Override
    public void addProvidedWire(Wire wire) {
        Capability cap;
        List<Wire> nswires;
        if (wire instanceof AbstractWire) {
            ((XWire)wire).setProviderWiring(this);
        }
        if ((nswires = this.provided.get((cap = wire.getCapability()).getNamespace())) == null) {
            nswires = new ArrayList<Wire>();
            this.provided.put(cap.getNamespace(), nswires);
        }
        int index = 0;
        if (nswires.size() > 0) {
            int capindex = this.getCapabilityIndex(cap);
            for (Wire aux : nswires) {
                int auxindex = this.getCapabilityIndex(aux.getCapability());
                if (auxindex >= capindex) continue;
                ++index;
            }
        }
        nswires.add(index, wire);
    }

    private int getCapabilityIndex(Capability cap) {
        return this.getResource().getCapabilities(cap.getNamespace()).indexOf(cap);
    }

    public List<Capability> getResourceCapabilities(String namespace) {
        ArrayList<Capability> result = new ArrayList<Capability>(this.resource.getCapabilities(namespace));
        for (Wire wire : this.getProvidedResourceWires("osgi.wiring.host")) {
            for (Capability cap : wire.getRequirer().getCapabilities(namespace)) {
                if ("osgi.identity".equals(cap.getNamespace())) continue;
                result.add(cap);
            }
        }
        Iterator capit = result.iterator();
        while (capit.hasNext()) {
            boolean removed = false;
            XCapability cap = (XCapability)capit.next();
            XResource res = cap.getResource();
            String effdir = (String)cap.getDirectives().get("effective");
            if (effdir != null && !effdir.equals("resolve")) {
                capit.remove();
                removed = true;
            }
            if (!removed) {
                String capns = cap.getNamespace();
                Object capval = cap.getAttributes().get(capns);
                for (Wire wire : this.required) {
                    Capability wirecap = wire.getCapability();
                    Object wirecapval = wirecap.getAttributes().get(wirecap.getNamespace());
                    if (!capns.equals(wirecap.getNamespace()) || !capval.equals(wirecapval)) continue;
                    capit.remove();
                    removed = true;
                    break;
                }
            }
            String type = res.getIdentityCapability().getType();
            if (removed || !"osgi.identity".equals(cap.getNamespace()) || !"osgi.fragment".equals(type)) continue;
            capit.remove();
            removed = true;
        }
        return Collections.unmodifiableList(result);
    }

    protected HostedCapability getHostedCapability(XCapability cap) {
        return new AbstractHostedCapability(this.resource, cap);
    }

    public List<Requirement> getResourceRequirements(String namespace) {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        for (Wire wire : this.getRequiredResourceWires(namespace)) {
            Requirement req = wire.getRequirement();
            if (result.contains(req)) continue;
            result.add(req);
        }
        for (Requirement req : this.getResource().getRequirements(namespace)) {
            XPackageRequirement preq;
            if (!(req instanceof XPackageRequirement) || !(preq = (XPackageRequirement)req).isDynamic() || result.contains(req)) continue;
            result.add(req);
        }
        return Collections.unmodifiableList(result);
    }

    public List<Wire> getProvidedResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        if (namespace != null) {
            List<Wire> nswires = this.provided.get(namespace);
            if (nswires != null) {
                result.addAll(nswires);
            }
        } else {
            for (List<Wire> wire : this.provided.values()) {
                result.addAll(wire);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<Wire> getRequiredResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (Wire wire : this.required) {
            Requirement req = wire.getRequirement();
            if (namespace != null && !namespace.equals(req.getNamespace())) continue;
            result.add(wire);
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "Wiring[" + this.resource + "]";
    }
}

