/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.MemoryPoolMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class MemoryPoolMXBeanReadResourceHandler
implements OperationStepHandler {
    public static final MemoryPoolMXBeanReadResourceHandler INSTANCE = new MemoryPoolMXBeanReadResourceHandler();

    private MemoryPoolMXBeanReadResourceHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode store;
        String memPoolName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        MemoryPoolMXBean memoryPoolMXBean = MemoryPoolMXBeanAttributeHandler.getMemoryPoolMXBean(memPoolName);
        ModelNode result = context.getResult();
        for (String attribute : PlatformMBeanConstants.MEMORY_POOL_READ_ATTRIBUTES) {
            store = result.get(attribute);
            try {
                MemoryPoolMXBeanAttributeHandler.storeResult(attribute, store, memoryPoolMXBean, memPoolName);
            }
            catch (UnsupportedOperationException ignored) {}
        }
        for (String attribute : PlatformMBeanConstants.MEMORY_POOL_READ_WRITE_ATTRIBUTES) {
            store = result.get(attribute);
            try {
                MemoryPoolMXBeanAttributeHandler.storeResult(attribute, store, memoryPoolMXBean, memPoolName);
            }
            catch (UnsupportedOperationException ignored) {}
        }
        for (String attribute : PlatformMBeanConstants.MEMORY_POOL_METRICS) {
            store = result.get(attribute);
            try {
                MemoryPoolMXBeanAttributeHandler.storeResult(attribute, store, memoryPoolMXBean, memPoolName);
            }
            catch (UnsupportedOperationException ignored) {}
        }
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            ModelNode store2 = result.get("object-name");
            MemoryPoolMXBeanAttributeHandler.storeResult("object-name", store2, memoryPoolMXBean, memPoolName);
        }
        context.stepCompleted();
    }
}

