/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.RuntimeMXBeanAttributeHandler;
import org.jboss.dmr.ModelNode;

public class RuntimeMXBeanReadResourceHandler
implements OperationStepHandler {
    public static final RuntimeMXBeanReadResourceHandler INSTANCE = new RuntimeMXBeanReadResourceHandler();

    private RuntimeMXBeanReadResourceHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode store;
        ModelNode result = context.getResult();
        for (String attribute : PlatformMBeanConstants.RUNTIME_READ_ATTRIBUTES) {
            store = result.get(attribute);
            try {
                RuntimeMXBeanAttributeHandler.storeResult(attribute, store);
            }
            catch (SecurityException ignored) {
            }
            catch (UnsupportedOperationException ignored) {}
        }
        for (String attribute : PlatformMBeanConstants.RUNTIME_METRICS) {
            store = result.get(attribute);
            try {
                RuntimeMXBeanAttributeHandler.storeResult(attribute, store);
            }
            catch (SecurityException ignored) {
            }
            catch (UnsupportedOperationException ignored) {}
        }
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            ModelNode store2 = result.get("object-name");
            RuntimeMXBeanAttributeHandler.storeResult("object-name", store2);
        }
        context.stepCompleted();
    }
}

