/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import javax.ejb.Handle;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.component.deployers.AbstractComponentConfigProcessor;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.interceptors.EjbMetadataInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.HomeRemoveInterceptor;
import org.jboss.as.ejb3.component.interceptors.SessionBeanHomeInterceptorFactory;
import org.jboss.as.ejb3.component.session.InvalidRemoveExceptionMethodInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.msc.service.ServiceBuilder;

public class SessionBeanHomeProcessor
extends AbstractComponentConfigProcessor {
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        if (componentDescription instanceof SessionBeanComponentDescription) {
            EjbHomeViewDescription view;
            SessionBeanComponentDescription ejbComponentDescription = (SessionBeanComponentDescription)componentDescription;
            if (ejbComponentDescription.getEjbLocalHomeView() != null) {
                view = ejbComponentDescription.getEjbLocalHomeView();
                EJBViewDescription ejbLocalView = ejbComponentDescription.getEjbLocalView();
                this.configureHome(phaseContext, componentDescription, ejbComponentDescription, view, ejbLocalView);
            }
            if (ejbComponentDescription.getEjbHomeView() != null) {
                view = ejbComponentDescription.getEjbHomeView();
                EJBViewDescription ejbRemoteView = ejbComponentDescription.getEjbRemoteView();
                this.configureHome(phaseContext, componentDescription, ejbComponentDescription, view, ejbRemoteView);
            }
        }
    }

    private void configureHome(final DeploymentPhaseContext phaseContext, final ComponentDescription componentDescription, final SessionBeanComponentDescription ejbComponentDescription, EJBViewDescription homeView, final EJBViewDescription ejbObjectView) {
        homeView.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, final ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addClientPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
                configuration.addClientPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
                DeploymentClassIndex classIndex = (DeploymentClassIndex)phaseContext.getDeploymentUnit().getAttachment(Attachments.CLASS_INDEX);
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    Object factory;
                    if (method.getName().startsWith("create")) {
                        if (ejbObjectView == null) {
                            throw EjbMessages.MESSAGES.invalidEjbLocalInterface(componentDescription.getComponentName());
                        }
                        Method initMethod = SessionBeanHomeProcessor.this.resolveInitMethod(ejbComponentDescription, method);
                        factory = new SessionBeanHomeInterceptorFactory(initMethod);
                        configuration.getDependencies().add(new DependencyConfigurator<ViewService>(){

                            public void configureDependency(ServiceBuilder<?> serviceBuilder, ViewService service) throws DeploymentUnitProcessingException {
                                serviceBuilder.addDependency(ejbObjectView.getServiceName(), ComponentView.class, factory.getViewToCreate());
                            }
                        });
                        configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                        configuration.addViewInterceptor(method, (InterceptorFactory)factory, 1536);
                        continue;
                    }
                    if (method.getName().equals("getEJBMetaData") && method.getParameterTypes().length == 0) {
                        Class ejbObjectClass;
                        try {
                            ejbObjectClass = classIndex.classIndex(ejbObjectView.getViewClassName()).getModuleClass();
                        }
                        catch (ClassNotFoundException e) {
                            throw EjbMessages.MESSAGES.failedToLoadViewClassForComponent(e, componentDescription.getComponentName());
                        }
                        factory = new EjbMetadataInterceptorFactory(ejbObjectClass, configuration.getViewClass(), null, true, componentDescription instanceof StatelessComponentDescription);
                        componentConfiguration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>((EjbMetadataInterceptorFactory)factory){
                            final /* synthetic */ EjbMetadataInterceptorFactory val$factory;
                            {
                                this.val$factory = ejbMetadataInterceptorFactory;
                            }

                            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                                serviceBuilder.addDependency(configuration.getViewServiceName(), ComponentView.class, this.val$factory.getHomeView());
                            }
                        });
                        configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                        configuration.addViewInterceptor(method, (InterceptorFactory)factory, 1536);
                        continue;
                    }
                    if (method.getName().equals("remove") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                        configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                        configuration.addViewInterceptor(method, InvalidRemoveExceptionMethodInterceptor.FACTORY, 560);
                        continue;
                    }
                    if (!method.getName().equals("remove") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Handle.class) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)ViewDescription.CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 1536);
                    configuration.addViewInterceptor(method, HomeRemoveInterceptor.FACTORY, 1536);
                }
            }
        });
    }

    private Method resolveInitMethod(EJBComponentDescription description, Method method) throws DeploymentUnitProcessingException {
        if (description instanceof StatelessComponentDescription) {
            return null;
        }
        if (description instanceof StatefulComponentDescription) {
            return this.resolveStatefulInitMethod((StatefulComponentDescription)description, method);
        }
        throw EjbMessages.MESSAGES.localHomeNotAllow(description);
    }

    private Method resolveStatefulInitMethod(StatefulComponentDescription description, Method method) throws DeploymentUnitProcessingException {
        Method initMethod = null;
        for (Map.Entry<Method, String> entry : description.getInitMethods().entrySet()) {
            String name = entry.getValue();
            Method init = entry.getKey();
            if (name == null || !Arrays.equals(init.getParameterTypes(), method.getParameterTypes()) || !init.getName().equals(name)) continue;
            initMethod = init;
        }
        if (initMethod == null) {
            for (Map.Entry<Method, String> entry : description.getInitMethods().entrySet()) {
                Method init = entry.getKey();
                if (entry.getValue() != null || !Arrays.equals(init.getParameterTypes(), method.getParameterTypes())) continue;
                initMethod = init;
                break;
            }
        }
        if (initMethod == null) {
            throw EjbMessages.MESSAGES.failToCallEjbCreateForHomeInterface(method, description.getEJBClassName());
        }
        return initMethod;
    }
}

