/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;

public class SecurityRoleRefDDProcessor
extends AbstractEjbXmlDescriptorProcessor<EnterpriseBeanMetaData> {
    private static final Logger logger = Logger.getLogger(SecurityRoleRefDDProcessor.class);

    @Override
    protected Class<EnterpriseBeanMetaData> getMetaDataType() {
        return EnterpriseBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(EnterpriseBeanMetaData beanMetaData, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        SecurityRoleRefsMetaData securityRoleRefs = beanMetaData.getSecurityRoleRefs();
        if (securityRoleRefs == null) {
            return;
        }
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)moduleDescription.getComponentByName(beanMetaData.getEjbName());
        for (SecurityRoleRefMetaData securityRoleRef : securityRoleRefs) {
            String fromRole = securityRoleRef.getRoleName();
            String toRole = securityRoleRef.getRoleLink();
            if (fromRole == null || fromRole.trim().isEmpty()) {
                throw EjbMessages.MESSAGES.roleNamesIsNull(ejbComponentDescription.getEJBName());
            }
            if (toRole == null) {
                toRole = fromRole;
            }
            ejbComponentDescription.linkSecurityRoles(fromRole, toRole);
        }
    }
}

