/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.logging.Logger;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProviderMBean;
import org.jboss.modcluster.load.metric.LoadMetric;

public class DynamicLoadBalanceFactorProvider
implements LoadBalanceFactorProvider,
DynamicLoadBalanceFactorProviderMBean {
    public static final int DEFAULT_DECAY_FACTOR = 2;
    public static final int DEFAULT_HISTORY = 9;
    private final Logger log = Logger.getLogger(this.getClass());
    private final Map<LoadMetric, List<Double>> loadHistory = new LinkedHashMap<LoadMetric, List<Double>>();
    private volatile int decayFactor = 2;
    private volatile int history = 9;

    public DynamicLoadBalanceFactorProvider(Set<LoadMetric> metrics) {
        for (LoadMetric metric : metrics) {
            this.loadHistory.put(metric, new ArrayList(this.history + 1));
        }
    }

    @Override
    public synchronized Map<String, Double> getMetrics() {
        TreeMap<String, Double> metrics = new TreeMap<String, Double>();
        for (Map.Entry<LoadMetric, List<Double>> entry : this.loadHistory.entrySet()) {
            List<Double> history = entry.getValue();
            metrics.put(entry.getKey().getClass().getSimpleName(), history.isEmpty() ? 0.0 : history.get(0));
        }
        return metrics;
    }

    @Override
    public synchronized int getLoadBalanceFactor(Engine engine) {
        int totalWeight = 0;
        double totalWeightedLoad = 0.0;
        for (Map.Entry<LoadMetric, List<Double>> entry : this.loadHistory.entrySet()) {
            LoadMetric metric = entry.getKey();
            int weight = metric.getWeight();
            if (weight <= 0) continue;
            List<Double> metricLoadHistory = entry.getValue();
            try {
                this.recordLoad(metricLoadHistory, metric.getLoad(engine) / metric.getCapacity());
                totalWeight += weight;
                totalWeightedLoad += this.average(metricLoadHistory) * (double)weight;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        int load = (int)Math.round(100.0 * totalWeightedLoad / (double)totalWeight);
        return 100 - Math.max(0, Math.min(load, 99));
    }

    private void recordLoad(List<Double> queue, double load) {
        if (!queue.isEmpty()) {
            for (int i = queue.size() - 1; i >= this.history; --i) {
                queue.remove(i);
            }
        }
        queue.add(0, new Double(load));
    }

    private double average(List<Double> queue) {
        assert (!queue.isEmpty());
        double totalLoad = 0.0;
        double totalDecay = 0.0;
        double decayFactor = this.decayFactor;
        for (int i = 0; i < queue.size(); ++i) {
            double decay = 1.0 / Math.pow(decayFactor, i);
            totalDecay += decay;
            totalLoad += queue.get(i) * decay;
        }
        return totalLoad / totalDecay;
    }

    @Override
    public int getDecayFactor() {
        return this.decayFactor;
    }

    @Override
    public void setDecayFactor(int decayFactor) {
        this.decayFactor = Math.max(1, decayFactor);
    }

    @Override
    public int getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(int history) {
        this.history = Math.max(0, history);
    }
}

