/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.metric.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.jboss.logging.Logger;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.load.metric.impl.AbstractLoadMetric;

public class AverageSystemLoadMetric
extends AbstractLoadMetric {
    private static final Logger logger = Logger.getLogger(AverageSystemLoadMetric.class);
    private final OperatingSystemMXBean bean;

    public AverageSystemLoadMetric() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public AverageSystemLoadMetric(OperatingSystemMXBean bean) {
        this.bean = bean;
    }

    @Override
    public double getLoad(Engine engine) throws Exception {
        double load = this.bean.getSystemLoadAverage();
        if (load < 0.0) {
            logger.warnf("%s is not supported on this system and will be disabled.", (Object)this.getClass().getSimpleName());
            this.setWeight(0);
            return 0.0;
        }
        return load / (double)this.bean.getAvailableProcessors();
    }
}

