/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.RealmRole;
import org.jboss.as.domain.management.security.RealmUser;
import org.jboss.as.domain.management.security.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WhoAmIOperation
implements OperationStepHandler {
    public static final WhoAmIOperation INSTANCE = new WhoAmIOperation();
    private static final SimpleAttributeDefinition VERBOSE = new SimpleAttributeDefinitionBuilder("verbose", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("whoami", ControllerResolver.getResolver((String[])new String[]{"core", "management"})).setParameters(new AttributeDefinition[]{VERBOSE}).setReadOnly().build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean verbose = VERBOSE.resolveModelAttribute(context, operation).asBoolean();
        Subject subject = SecurityActions.getSecurityContextSubject();
        if (subject == null) {
            throw new OperationFailedException(new ModelNode().set(DomainManagementMessages.MESSAGES.noSecurityContextEstablished()));
        }
        Set<RealmUser> realmUsers = subject.getPrincipals(RealmUser.class);
        if (realmUsers.size() != 1) {
            throw new OperationFailedException(new ModelNode().set(DomainManagementMessages.MESSAGES.unexpectedNumberOfRealmUsers(realmUsers.size())));
        }
        RealmUser user = realmUsers.iterator().next();
        ModelNode result = context.getResult();
        ModelNode identity = result.get("identity");
        identity.get("username").set(user.getName());
        String realm = user.getRealm();
        if (realm != null) {
            identity.get("realm").set(realm);
        }
        if (verbose) {
            ModelNode roles = result.get("roles");
            Set<RealmRole> roleSet = subject.getPrincipals(RealmRole.class);
            for (RealmRole current : roleSet) {
                roles.add(current.getName());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

