/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.ir.gui.typesystem.Interface;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IRContainer;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRTypedef;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;

public class IRInterface
extends IRContainer
implements Interface {
    private IRInterface[] superInterfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;

    public IRInterface() {
    }

    public IRInterface(IRObject irObject) {
        super(irObject);
    }

    public String[] allowedToAdd() {
        String[] result = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName()};
        return result;
    }

    public String description() {
        String result = super.description();
        Interface[] superinterfaces = this.getSuperInterfaces();
        if (superinterfaces.length > 0) {
            result = result + "\nSuper-Interfaces:\t ";
            for (int i = 0; i < superinterfaces.length; ++i) {
                result = result + ((TypeSystemNode)((Object)superinterfaces[i])).getAbsoluteName();
                if (i == superinterfaces.length - 1) continue;
                result = result + ", ";
            }
        } else {
            result = result + "\nSuper-Interfaces:\t:none";
        }
        return result;
    }

    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            int i;
            Vector<ModelParticipant> fields = new Vector<ModelParticipant>();
            Interface[] superInterfaces = this.getSuperInterfaces();
            for (int i2 = 0; i2 < superInterfaces.length; ++i2) {
                TypeSystemNode[] nextFields = superInterfaces[i2].getAllFields();
                for (int n = 0; n < nextFields.length; ++n) {
                    fields.addElement(nextFields[n]);
                }
            }
            ModelParticipant[] contents = this.contents();
            for (i = 0; i < contents.length; ++i) {
                if (!(contents[i] instanceof IRAttribute)) continue;
                fields.addElement(contents[i]);
            }
            this.allFields = new IRAttribute[fields.size()];
            i = 0;
            Enumeration e = fields.elements();
            while (e.hasMoreElements()) {
                this.allFields[i] = (IRAttribute)e.nextElement();
                ++i;
            }
        }
        return this.allFields;
    }

    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            int i;
            Vector<ModelParticipant> operations = new Vector<ModelParticipant>();
            Interface[] superInterfaces = this.getSuperInterfaces();
            for (int i2 = 0; i2 < superInterfaces.length; ++i2) {
                TypeSystemNode[] nextOperations = superInterfaces[i2].getAllOperations();
                for (int n = 0; n < nextOperations.length; ++n) {
                    operations.addElement(nextOperations[n]);
                }
            }
            ModelParticipant[] contents = this.contents();
            for (i = 0; i < contents.length; ++i) {
                if (!(contents[i] instanceof IROperation)) continue;
                operations.addElement(contents[i]);
            }
            this.allOperations = new IROperation[operations.size()];
            i = 0;
            Enumeration e = operations.elements();
            while (e.hasMoreElements()) {
                this.allOperations[i] = (IROperation)e.nextElement();
                ++i;
            }
        }
        return this.allOperations;
    }

    public Interface[] getSuperInterfaces() {
        if (this.superInterfaces == null) {
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.irObject);
            InterfaceDef[] baseInterfaces = interfaceDef.base_interfaces();
            this.superInterfaces = new IRInterface[baseInterfaces.length];
            for (int i = 0; i < baseInterfaces.length; ++i) {
                IRInterface superInterface;
                this.superInterfaces[i] = superInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(baseInterfaces[i]);
            }
        }
        return this.superInterfaces;
    }

    public static String nodeTypeName() {
        return "interface";
    }

    protected void setIRObject(IRObject irObject) {
        super.setIRObject(irObject);
    }
}

