/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation.hibernate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.hibernate.validator.method.MethodValidator;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;
import org.jboss.resteasy.plugins.validation.hibernate.ConstraintTypeUtil10;
import org.jboss.resteasy.plugins.validation.hibernate.DoNotValidateRequest;
import org.jboss.resteasy.plugins.validation.hibernate.ValidateRequest;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.util.FindAnnotation;

public class GeneralValidatorImpl
implements GeneralValidator {
    private Validator validator;
    private MethodValidator methodValidator;
    private ConstraintTypeUtil util = new ConstraintTypeUtil10();

    public GeneralValidatorImpl(Validator validator, MethodValidator methodValidator) {
        this.validator = validator;
        this.methodValidator = methodValidator;
    }

    protected ViolationsContainer<Object> getViolationsContainer(HttpRequest request) {
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer == null) {
            violationsContainer = new ViolationsContainer();
            request.setAttribute(ViolationsContainer.class.getName(), (Object)violationsContainer);
        }
        return violationsContainer;
    }

    public void checkViolations(HttpRequest request) {
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer != null && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer);
        }
    }

    public void validate(HttpRequest request, Object object, Class<?> ... groups) {
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        try {
            Set cvs = this.validator.validate(object, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        violationsContainer.addViolations(rcvs);
    }

    public void validateAllParameters(HttpRequest request, Object object, Method method, Object[] parameterValues, Class<?> ... groups) {
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        try {
            Set cvs = this.methodValidator.validateAllParameters(object, method, parameterValues, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer);
        }
    }

    public void validateReturnValue(HttpRequest request, Object object, Method method, Object returnValue, Class<?> ... groups) {
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        try {
            Set cvs = this.methodValidator.validateReturnValue(object, method, returnValue, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer);
        }
    }

    public boolean isValidatable(Class<?> clazz) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])clazz.getAnnotations(), DoNotValidateRequest.class);
        return resourceValidateRequest != null && doNotValidateRequest == null;
    }

    public boolean isMethodValidatable(Method m) {
        ValidateRequest resourceValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getDeclaringClass().getAnnotations(), ValidateRequest.class);
        ValidateRequest methodValidateRequest = (ValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), ValidateRequest.class);
        DoNotValidateRequest doNotValidateRequest = (DoNotValidateRequest)FindAnnotation.findAnnotation((Annotation[])m.getAnnotations(), DoNotValidateRequest.class);
        return (resourceValidateRequest != null || methodValidateRequest != null) && doNotValidateRequest == null;
    }
}

