/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.bootstrapcontext;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.WorkContext;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.WorkManager;

public class BaseCloneableBootstrapContext
implements CloneableBootstrapContext {
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry = null;
    private WorkManager workManager = null;
    private XATerminator xaTerminator = null;
    private Set<Class> supportedContexts = new HashSet<Class>(3);

    public BaseCloneableBootstrapContext() {
        this.supportedContexts.add(HintsContext.class);
        this.supportedContexts.add(SecurityContext.class);
        this.supportedContexts.add(TransactionContext.class);
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        if (this.workManager != null) {
            this.workManager.setResourceAdapter(ra);
        }
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    public void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
        this.transactionSynchronizationRegistry = tsr;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager wm) {
        this.workManager = wm;
    }

    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public void setXATerminator(XATerminator xt) {
        this.xaTerminator = xt;
    }

    public Timer createTimer() {
        return new Timer(true);
    }

    public boolean isContextSupported(Class<? extends WorkContext> workContextClass) {
        if (workContextClass == null) {
            return false;
        }
        return this.supportedContexts.contains(workContextClass);
    }

    public CloneableBootstrapContext clone() throws CloneNotSupportedException {
        BaseCloneableBootstrapContext bcbc = (BaseCloneableBootstrapContext)super.clone();
        bcbc.setTransactionSynchronizationRegistry(this.getTransactionSynchronizationRegistry());
        bcbc.setWorkManager(this.getWorkManager().clone());
        bcbc.setXATerminator(this.getXATerminator());
        return bcbc;
    }
}

