/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.JMSDestinationMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.PropertyMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;

public class JMSDestinationMetaDataParser
extends MetaDataElementParser {
    public static JMSDestinationMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        JMSDestinationMetaData metaData = new JMSDestinationMetaData();
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JMSDestinationMetaDataParser.attributeHasNamespace(reader, i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    metaData.setId(value);
                    continue block10;
                }
                default: {
                    throw JMSDestinationMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions, propertyReplacer)) {
                if (metaData.getDescriptions() != null) continue;
                metaData.setDescriptions(descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    metaData.setName(JMSDestinationMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block11;
                }
                case CLASS_NAME: {
                    metaData.setClassName(JMSDestinationMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block11;
                }
                case RESOURCE_ADAPTER: {
                    metaData.setResourceAdapter(JMSDestinationMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block11;
                }
                case DESTINATION_NAME: {
                    metaData.setDestinationName(JMSDestinationMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block11;
                }
                case PROPERTY: {
                    PropertiesMetaData properties = metaData.getProperties();
                    if (properties == null) {
                        properties = new PropertiesMetaData();
                        metaData.setProperties(properties);
                    }
                    properties.add(PropertyMetaDataParser.parse(reader, propertyReplacer));
                    continue block11;
                }
            }
            throw JMSDestinationMetaDataParser.unexpectedElement(reader);
        }
        return metaData;
    }
}

