/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.GroupMembershipListener;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.service.ServiceProviderRegistry;
import org.jboss.as.clustering.service.ServiceProviderRegistryRpcHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

@Listener(sync=false)
public class ServiceProviderRegistryService
implements ServiceProviderRegistry,
ServiceProviderRegistryRpcHandler,
GroupMembershipListener,
Service<ServiceProviderRegistry> {
    final ServiceName name;
    final ServiceProviderRegistryRpcHandler handler = new RpcDispatcher();
    private final Value<Cache> cacheRef;
    private final Value<GroupMembershipNotifier> notifierRef;
    private final Value<GroupRpcDispatcher> dispatcherRef;
    private final Map<String, ServiceProviderRegistry.Listener> listeners = new ConcurrentHashMap<String, ServiceProviderRegistry.Listener>();
    private final CacheInvoker invoker = new BatchCacheInvoker();
    volatile GroupRpcDispatcher dispatcher;
    private volatile GroupMembershipNotifier notifier;
    private volatile Cache<String, Map<ClusterNode, Void>> cache;

    public static ServiceName getServiceName(String name) {
        return CoreGroupCommunicationService.getServiceName((String)name).append(new String[]{"registry"});
    }

    public ServiceProviderRegistryService(ServiceName name, Value<Cache> cacheRef, Value<GroupRpcDispatcher> dispatcherRef, Value<GroupMembershipNotifier> notifierRef) {
        this.name = name;
        this.cacheRef = cacheRef;
        this.notifierRef = notifierRef;
        this.dispatcherRef = dispatcherRef;
    }

    @Override
    public void register(final String service, ServiceProviderRegistry.Listener listener) {
        this.listeners.put(service, listener);
        final ClusterNode node = this.notifier.getClusterNode();
        Operation<Set<ClusterNode>> operation = new Operation<Set<ClusterNode>>(){

            public Set<ClusterNode> invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                Map map = (Map)cache.putIfAbsent((Object)service, null);
                if (!map.containsKey(node)) {
                    map.put(node, null);
                }
                return map.keySet();
            }
        };
        Set nodes = (Set)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        listener.serviceProvidersChanged(nodes, false);
    }

    @Override
    public void unregister(final String service) {
        final ClusterNode node = this.notifier.getClusterNode();
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                ((Map)cache.get((Object)service)).remove(node);
                return null;
            }
        };
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        this.listeners.remove(service);
    }

    @Override
    public Set<ClusterNode> getServiceProviders(String service) {
        return Collections.unmodifiableSet(((Map)this.cache.get((Object)service)).keySet());
    }

    @Override
    public List<String> getServices(final ClusterNode node) {
        Operation<List<String>> operation = new Operation<List<String>>(){

            public List<String> invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                Set services = cache.keySet();
                ArrayList<String> result = new ArrayList<String>(services.size());
                for (String service : services) {
                    if (!((Map)cache.get((Object)service)).keySet().contains(node)) continue;
                    result.add(service);
                }
                return result;
            }
        };
        return (List)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
    }

    public ServiceProviderRegistry getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.dispatcher = (GroupRpcDispatcher)this.dispatcherRef.getValue();
        this.dispatcher.registerRPCHandler(this.name.getCanonicalName(), (Object)this);
        this.notifier = (GroupMembershipNotifier)this.notifierRef.getValue();
        this.notifier.registerGroupMembershipListener((GroupMembershipListener)this);
        Cache cache = (Cache)this.cacheRef.getValue();
        this.cache = new AtomicMapCache(cache.getAdvancedCache());
        this.cache.addListener((Object)this);
    }

    public void stop(StopContext context) {
        this.cache.removeListener((Object)this);
        this.notifier.unregisterGroupMembershipListener((GroupMembershipListener)this);
        this.dispatcher.unregisterRPCHandler(this.name.getCanonicalName(), (Object)this);
    }

    public void membershipChanged(final List<ClusterNode> deadMembers, List<ClusterNode> newMembers, List<ClusterNode> allMembers) {
        Operation<Map<String, Set<ClusterNode>>> operation = new Operation<Map<String, Set<ClusterNode>>>(){

            public Map<String, Set<ClusterNode>> invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                HashMap<String, Set<ClusterNode>> updates = new HashMap<String, Set<ClusterNode>>();
                ServiceProviderRegistryService.this.purgeDeadMembers(deadMembers, updates);
                return updates;
            }
        };
        this.notifyListeners((Map)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]), false);
    }

    public void membershipChangedDuringMerge(final List<ClusterNode> deadMembers, final List<ClusterNode> newMembers, List<ClusterNode> allMembers, List<List<ClusterNode>> originatingGroups) {
        Operation<Map<String, Set<ClusterNode>>> operation = new Operation<Map<String, Set<ClusterNode>>>(){

            public Map<String, Set<ClusterNode>> invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                HashMap<String, Set<ClusterNode>> updates = new HashMap<String, Set<ClusterNode>>();
                if (newMembers.isEmpty()) {
                    for (String service : cache.keySet()) {
                        updates.put(service, ((Map)cache.get((Object)service)).keySet());
                    }
                } else {
                    for (ClusterNode node : newMembers) {
                        List<String> services = ServiceProviderRegistryService.this.handler.getServices(node);
                        for (String service : services) {
                            Map nodes = (Map)cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).putIfAbsent((Object)service, null);
                            nodes.put(node, null);
                            updates.put(service, Collections.unmodifiableSet(nodes.keySet()));
                        }
                    }
                }
                ServiceProviderRegistryService.this.purgeDeadMembers(deadMembers, updates);
                return updates;
            }
        };
        this.notifyListeners((Map)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]), true);
    }

    void purgeDeadMembers(List<ClusterNode> deadNodes, Map<String, Set<ClusterNode>> updates) {
        for (String key : this.cache.keySet()) {
            Set nodes;
            Map map = (Map)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).get((Object)key);
            if (map == null || !(nodes = map.keySet()).removeAll(deadNodes)) continue;
            updates.put(key, Collections.unmodifiableSet(nodes));
        }
    }

    private void notifyListeners(Map<String, Set<ClusterNode>> updates, boolean merge) {
        for (Map.Entry<String, Set<ClusterNode>> entry : updates.entrySet()) {
            ServiceProviderRegistry.Listener listener = this.listeners.get(entry.getKey());
            if (listener == null) continue;
            listener.serviceProvidersChanged(entry.getValue(), merge);
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<String, Map<ClusterNode, Void>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        this.notifyListeners(Collections.singletonMap(event.getKey(), ((Map)event.getValue()).keySet()), false);
    }

    class RpcDispatcher
    implements ServiceProviderRegistryRpcHandler {
        RpcDispatcher() {
        }

        @Override
        public List<String> getServices(ClusterNode node) {
            try {
                return (List)ServiceProviderRegistryService.this.dispatcher.callMethodOnNode(ServiceProviderRegistryService.this.name.getCanonicalName(), "getServices", new Object[]{node}, new Class[]{ClusterNode.class}, node);
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
    }

    static interface Operation<R>
    extends CacheInvoker.Operation<String, Map<ClusterNode, Void>, R> {
    }
}

