/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.ModuleRegistrationTracker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.osgi.metadata.OSGiMetaData;

public class ModuleRegisterProcessor
implements DeploymentUnitProcessor {
    private final ModuleRegistrationTracker registrationTracker;

    public ModuleRegisterProcessor(ModuleRegistrationTracker tracker) {
        this.registrationTracker = tracker;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)depUnit) || DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)depUnit)) {
            return;
        }
        if (depUnit.hasAttachment(OSGiConstants.BUNDLE_REVISION_KEY)) {
            return;
        }
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        ModuleSpecification moduleSpecification = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (module == null || moduleSpecification.isPrivateModule()) {
            return;
        }
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        this.registrationTracker.registerModule(module, metadata);
    }

    public void undeploy(DeploymentUnit depUnit) {
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        this.registrationTracker.unregisterModule(module);
    }
}

