/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.management;

import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.management.OperationAssociation;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;

public class BundleResourceHandler
extends AbstractRuntimeOnlyHandler {
    public static final BundleResourceHandler INSTANCE = new BundleResourceHandler();

    private BundleResourceHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            this.handleReadAttributeOperation(context, operation);
        } else {
            this.handleOperation(context, operationName, operation);
        }
    }

    private void handleReadAttributeOperation(OperationContext context, ModelNode operation) {
        String name = operation.require("name").asString();
        if ("id".equals(name)) {
            Bundle bundle2 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle2.getBundleId());
        } else if ("startlevel".equals(name)) {
            Bundle bundle3 = this.getTargetBundle(context, operation);
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle3.adapt(BundleStartLevel.class);
            int startlevel = bundleStartLevel.getStartLevel();
            context.getResult().set(startlevel);
        } else if ("state".equals(name)) {
            Bundle bundle4 = this.getTargetBundle(context, operation);
            context.getResult().set(BundleResourceHandler.getBundleState(bundle4));
        } else if ("symbolic-name".equals(name)) {
            Bundle bundle5 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle5.getSymbolicName());
        } else if ("location".equals(name)) {
            Bundle bundle6 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle6.getLocation());
        } else if ("type".equals(name)) {
            Bundle bundle7 = this.getTargetBundle(context, operation);
            if (bundle7.getHeaders().get("Fragment-Host") != null) {
                context.getResult().set("fragment");
            } else {
                context.getResult().set("bundle");
            }
        } else if ("version".equals(name)) {
            Bundle bundle8 = this.getTargetBundle(context, operation);
            context.getResult().set(bundle8.getVersion().toString());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOperation(OperationContext context, String operationName, ModelNode operation) {
        block7: {
            try {
                if ("start".equals(operationName)) {
                    OperationAssociation.INSTANCE.setAssociation(operation);
                    try {
                        Bundle bundle2 = this.getTargetBundle(context, operation);
                        bundle2.start();
                        break block7;
                    }
                    finally {
                        OperationAssociation.INSTANCE.removeAssociation();
                    }
                }
                if ("stop".equals(operationName)) {
                    Bundle bundle3 = this.getTargetBundle(context, operation);
                    bundle3.stop();
                    break block7;
                }
                throw new UnsupportedOperationException(operationName);
            }
            catch (Exception ex) {
                OSGiLogger.LOGGER.errorInOperationHandler(ex, operationName);
                context.getFailureDescription().set(ex.getLocalizedMessage());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private Bundle getTargetBundle(OperationContext context, ModelNode operation) {
        ModelNode addr = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)addr);
        String value = pathAddress.getLastElement().getValue();
        XBundle bundle2 = null;
        try {
            Long bundleId = Long.parseLong(value);
            bundle2 = this.getSystemContext(context).getBundle(bundleId.longValue());
        }
        catch (NumberFormatException ex) {
            bundle2 = this.getBundleManager(context).getBundleByLocation(value);
        }
        if (bundle2 == null) {
            throw OSGiMessages.MESSAGES.illegalArgumentCannotObtainBundleResource(value);
        }
        return bundle2;
    }

    static String getBundleState(Bundle bundle2) {
        switch (bundle2.getState()) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return null;
    }

    private BundleManager getBundleManager(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.BUNDLE_MANAGER);
        return controller != null ? (BundleManager)controller.getValue() : null;
    }

    private BundleContext getSystemContext(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.FRAMEWORK_CREATE);
        return controller != null ? (BundleContext)controller.getValue() : null;
    }
}

