/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.IOException;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.ModuleIdentityRepository;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryStorageFactory;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.AbstractPersistentRepository;
import org.jboss.osgi.repository.spi.AggregatingRepository;
import org.jboss.osgi.repository.spi.FileBasedRepositoryStorage;
import org.jboss.osgi.repository.spi.MavenDelegateRepository;

public final class RepositoryService
extends AbstractService<XPersistentRepository> {
    public static final ServiceName SERVICE_NAME = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"XRepository"});
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private XPersistentRepository repository;

    public static ServiceController<?> addService(ServiceTarget target) {
        RepositoryService service = new RepositoryService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(OSGiConstants.SUBSYSTEM_STATE_SERVICE_NAME, SubsystemState.class, service.injectedSubsystemState);
        return builder.install();
    }

    private RepositoryService() {
    }

    public synchronized void start(StartContext startContext) throws StartException {
        final MavenDelegateRepository.ConfigurationPropertyProvider propProvider = new MavenDelegateRepository.ConfigurationPropertyProvider(){

            public String getProperty(String key, String defaultValue) {
                SubsystemState subsystemState = (SubsystemState)RepositoryService.this.injectedSubsystemState.getValue();
                String value = subsystemState.getProperties().get(key);
                return value != null ? value : defaultValue;
            }
        };
        final ServerEnvironment serverenv = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        RepositoryStorageFactory factory = new RepositoryStorageFactory(){

            public RepositoryStorage create(XRepository repository) {
                File storageDir = RepositoryService.this.getRepositoryStorageDir(propProvider, serverenv);
                return new FileBasedRepositoryStorage(repository, storageDir, propProvider);
            }
        };
        AggregatingRepository aggregator = new AggregatingRepository();
        aggregator.addRepository((XRepository)new ModuleIdentityRepository(serverenv));
        aggregator.addRepository((XRepository)new MavenDelegateRepository(propProvider));
        this.repository = new AbstractPersistentRepository(factory, (XRepository)aggregator);
    }

    private File getRepositoryStorageDir(MavenDelegateRepository.ConfigurationPropertyProvider propProvider, ServerEnvironment serverenv) {
        String dirName = propProvider.getProperty("org.jboss.osgi.repository.storage.dir", null);
        if (dirName == null) {
            try {
                File storageDir = new File(serverenv.getServerDataDir().getPath() + File.separator + "repository");
                dirName = storageDir.getCanonicalPath();
            }
            catch (IOException ex) {
                throw RepositoryMessages.MESSAGES.cannotCreateRepositoryStorageArea((Throwable)ex);
            }
        }
        return new File(dirName).getAbsoluteFile();
    }

    public synchronized void stop(StopContext context) {
        this.repository = null;
    }

    public synchronized XPersistentRepository getValue() throws IllegalStateException {
        return this.repository;
    }
}

