/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.osgi.SubsystemExtension;
import org.jboss.as.osgi.management.OSGiRuntimeResource;
import org.jboss.as.osgi.service.RepositoryService;
import org.jboss.as.server.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemServices;
import org.jboss.osgi.framework.spi.SystemServicesPlugin;
import org.jboss.osgi.provision.AbstractResourceProvisioner;
import org.jboss.osgi.provision.ProvisionException;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.repository.RepositoryContent;
import org.osgi.util.xml.XMLParserActivator;

final class SystemServicesIntegration
extends SystemServicesPlugin {
    private final InjectedValue<ModelController> injectedModelController = new InjectedValue();
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
    private final InjectedValue<XPersistentRepository> injectedRepository = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final List<SubsystemExtension> extensions;
    private final OSGiRuntimeResource resource;
    private ServiceContainer serviceContainer;
    private ExecutorService controllerThreadExecutor;

    SystemServicesIntegration(OSGiRuntimeResource resource, List<SubsystemExtension> extensions) {
        this.extensions = extensions;
        this.resource = resource;
    }

    protected void addServiceDependencies(ServiceBuilder<SystemServices> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.injectedModelController);
        builder.addDependency(RepositoryService.SERVICE_NAME, XPersistentRepository.class, this.injectedRepository);
        builder.addDependency(org.jboss.osgi.framework.Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(org.jboss.osgi.framework.Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedBundleContext);
        builder.addDependency(org.jboss.osgi.framework.Services.RESOLVER, XResolver.class, this.injectedResolver);
        for (SubsystemExtension extension : this.extensions) {
            extension.configureServiceDependencies(this.getServiceName(), builder);
        }
    }

    public void start(StartContext startContext) throws StartException {
        this.serviceContainer = startContext.getController().getServiceContainer();
        super.start(startContext);
        BundleContext syscontext = (BundleContext)this.injectedBundleContext.getValue();
        for (SubsystemExtension extension : this.extensions) {
            extension.startSystemServices(startContext, syscontext);
        }
    }

    public void stop(StopContext context) {
        BundleContext syscontext = (BundleContext)this.injectedBundleContext.getValue();
        for (SubsystemExtension extension : this.extensions) {
            extension.stopSystemServices(context, syscontext);
        }
        super.stop(context);
    }

    protected SystemServices createServiceValue(StartContext startContext) throws StartException {
        final SystemServices delegate = super.createServiceValue(startContext);
        return new SystemServices(){

            public void registerServices(BundleContext syscontext) {
                delegate.registerServices(syscontext);
                BundleManager bundleManager = (BundleManager)SystemServicesIntegration.this.injectedBundleManager.getValue();
                SystemServicesIntegration.this.resource.getInjectedBundleManager().inject((Object)bundleManager);
                SystemServicesIntegration.this.registerJAXPServices(syscontext);
                SystemServicesIntegration.this.registerServiceContainer(syscontext);
                SystemServicesIntegration.this.registerSocketBindings(syscontext);
                SystemServicesIntegration.this.registerRepository(syscontext);
                SystemServicesIntegration.this.registerResourceProvisioner(syscontext);
                SystemServicesIntegration.this.registerModelControllerClient(syscontext);
            }

            public void unregisterServices() {
                SystemServicesIntegration.this.resource.getInjectedBundleManager().uninject();
                SystemServicesIntegration.this.controllerThreadExecutor.shutdown();
                delegate.unregisterServices();
            }
        };
    }

    private void registerJAXPServices(BundleContext syscontext) {
        try {
            final ClassLoader resloader = ((Object)((Object)this)).getClass().getClassLoader();
            XMLParserActivator activator = new XMLParserActivator(){

                protected URL getResourceURL(Bundle parserBundle, String resname) {
                    return resloader.getResource(resname);
                }
            };
            activator.start(syscontext);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void registerServiceContainer(BundleContext syscontext) {
        syscontext.registerService(ServiceContainer.class, (Object)this.serviceContainer, null);
    }

    private void registerRepository(BundleContext syscontext) {
        XRepository repository = (XRepository)this.injectedRepository.getValue();
        syscontext.registerService(XRepository.class, (Object)repository, null);
    }

    private void registerResourceProvisioner(final BundleContext syscontext) {
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        XPersistentRepository repository = (XPersistentRepository)this.injectedRepository.getValue();
        AbstractResourceProvisioner provisioner = new AbstractResourceProvisioner(resolver, repository, "osgi.bundle"){

            public <T> List<T> installResources(List<XResource> resources, Class<T> type) throws ProvisionException {
                ArrayList<Bundle> result = new ArrayList<Bundle>();
                for (XResource res : resources) {
                    String name = res.getIdentityCapability().getName();
                    String location = "provisioned-resource/" + name;
                    InputStream input = ((RepositoryContent)res).getContent();
                    try {
                        Bundle bundle2 = syscontext.installBundle(location, input);
                        result.add(bundle2);
                    }
                    catch (BundleException ex) {
                        throw new ProvisionException((Throwable)ex);
                    }
                }
                return Collections.unmodifiableList(result);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("type", "osgi.bundle");
        syscontext.registerService(XResourceProvisioner.class, (Object)provisioner, props);
    }

    private void registerModelControllerClient(BundleContext syscontext) {
        this.controllerThreadExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi ModelControllerClient Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        ModelController modelController = (ModelController)this.injectedModelController.getValue();
        ModelControllerClient client = modelController.createClient((Executor)this.controllerThreadExecutor);
        syscontext.registerService(ModelControllerClient.class, (Object)client, null);
    }

    private void registerSocketBindings(final BundleContext syscontext) {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        String bindingNames = syscontext.getProperty("org.jboss.as.osgi.socket.bindings");
        if (bindingNames != null) {
            final HashSet<ServiceName> socketBindingNames = new HashSet<ServiceName>();
            for (String suffix : bindingNames.split(",")) {
                socketBindingNames.add(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{suffix}));
            }
            ServiceTarget serviceTarget = bundleManager.getServiceTarget();
            ServiceName serviceName = IntegrationServices.SYSTEM_SERVICES_PLUGIN.append(new String[]{"BINDINGS"});
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    for (ServiceName serviceName : socketBindingNames) {
                        SocketBinding binding = (SocketBinding)SystemServicesIntegration.this.serviceContainer.getRequiredService(serviceName).getValue();
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        ((Dictionary)props).put("socketBinding", serviceName.getSimpleName());
                        InetSocketAddress value = binding.getSocketAddress();
                        syscontext.registerService(InetSocketAddress.class, (Object)value, props);
                    }
                }
            });
            ServiceName[] serviceNameArray = socketBindingNames.toArray(new ServiceName[socketBindingNames.size()]);
            builder.addDependencies(serviceNameArray);
            builder.install();
        }
    }
}

