/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.core.asyncio.BufferCallback;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.AIOSequentialFile;
import org.hornetq.core.journal.impl.AbstractSequentialFileFactory;
import org.hornetq.journal.HornetQJournalLogger;
import org.hornetq.utils.HornetQThreadFactory;

public final class AIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    private static final boolean trace = HornetQJournalLogger.LOGGER.isTraceEnabled();
    private final ReuseBuffersController buffersControl = new ReuseBuffersController();
    private ExecutorService pollerExecutor;

    private static final void trace(String message) {
        HornetQJournalLogger.LOGGER.trace(message);
    }

    public AIOSequentialFileFactory(String journalDir) {
        this(journalDir, 501760, 500000, false, null);
    }

    public AIOSequentialFileFactory(String journalDir, IOCriticalErrorListener listener) {
        this(journalDir, 501760, 500000, false, listener);
    }

    public AIOSequentialFileFactory(String journalDir, int bufferSize, int bufferTimeout, boolean logRates) {
        this(journalDir, bufferSize, bufferTimeout, logRates, null);
    }

    public AIOSequentialFileFactory(String journalDir, int bufferSize, int bufferTimeout, boolean logRates, IOCriticalErrorListener listener) {
        super(journalDir, true, bufferSize, bufferTimeout, logRates, listener);
    }

    @Override
    public SequentialFile createSequentialFile(String fileName, int maxIO) {
        return new AIOSequentialFile(this, this.bufferSize, this.bufferTimeout, this.journalDir, fileName, maxIO, this.buffersControl.callback, this.writeExecutor, this.pollerExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return true;
    }

    public static boolean isSupported() {
        return AsynchronousFileImpl.isLoaded();
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int blocks = size / 512;
        if (size % 512 != 0) {
            ++blocks;
        }
        ByteBuffer buffer = AsynchronousFileImpl.newBuffer(blocks * 512);
        buffer.limit(size);
        return buffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        AsynchronousFileImpl.destroyBuffer(buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        if (size % 512 != 0) {
            size = (size / 512 + 1) * 512;
        }
        return this.buffersControl.newBuffer(size);
    }

    @Override
    public void clearBuffer(ByteBuffer directByteBuffer) {
        AsynchronousFileImpl.clearBuffer(directByteBuffer);
    }

    @Override
    public int getAlignment() {
        return 512;
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        ByteBuffer newbuffer = this.newBuffer(bytes.length);
        newbuffer.put(bytes);
        return newbuffer;
    }

    @Override
    public int calculateBlockSize(int position) {
        int alignment = this.getAlignment();
        int pos = (position / alignment + (position % alignment != 0 ? 1 : 0)) * alignment;
        return pos;
    }

    @Override
    public synchronized void releaseBuffer(ByteBuffer buffer) {
        AsynchronousFileImpl.destroyBuffer(buffer);
    }

    @Override
    public void start() {
        super.start();
        this.pollerExecutor = Executors.newCachedThreadPool(new HornetQThreadFactory("HornetQ-AIO-poller-pool" + System.identityHashCode(this), true, AIOSequentialFileFactory.getThisClassLoader()));
    }

    @Override
    public void stop() {
        this.buffersControl.stop();
        if (this.pollerExecutor != null) {
            this.pollerExecutor.shutdown();
            try {
                if (!this.pollerExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    HornetQJournalLogger.LOGGER.timeoutOnPollerShutdown(new Exception("trace"));
                }
            }
            catch (InterruptedException e) {
                throw new HornetQInterruptedException(e);
            }
        }
        super.stop();
    }

    protected void finalize() {
        this.stop();
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return AIOSequentialFileFactory.class.getClassLoader();
            }
        });
    }

    public String toString() {
        return AIOSequentialFileFactory.class.getSimpleName() + "(buffersControl.stopped=" + this.buffersControl.stopped + "):" + super.toString();
    }

    private class ReuseBuffersController {
        private volatile long bufferReuseLastTime = System.currentTimeMillis();
        private final ConcurrentLinkedQueue<ByteBuffer> reuseBuffersQueue = new ConcurrentLinkedQueue();
        private boolean stopped = false;
        final BufferCallback callback = new LocalBufferCallback();

        private ReuseBuffersController() {
        }

        public ByteBuffer newBuffer(int size) {
            if (AIOSequentialFileFactory.this.bufferSize > 0 && System.currentTimeMillis() - this.bufferReuseLastTime > 10000L) {
                if (trace) {
                    AIOSequentialFileFactory.trace("Clearing reuse buffers queue with " + this.reuseBuffersQueue.size() + " elements");
                }
                this.bufferReuseLastTime = System.currentTimeMillis();
                this.clearPoll();
            }
            if (size > AIOSequentialFileFactory.this.bufferSize) {
                return AsynchronousFileImpl.newBuffer(size);
            }
            int alignedSize = AIOSequentialFileFactory.this.calculateBlockSize(size);
            ByteBuffer buffer = this.reuseBuffersQueue.poll();
            if (buffer == null) {
                buffer = AsynchronousFileImpl.newBuffer(AIOSequentialFileFactory.this.bufferSize);
                buffer.limit(alignedSize);
            } else {
                AIOSequentialFileFactory.this.clearBuffer(buffer);
                buffer.limit(alignedSize);
            }
            buffer.rewind();
            return buffer;
        }

        public synchronized void stop() {
            this.stopped = true;
            this.clearPoll();
        }

        public synchronized void clearPoll() {
            ByteBuffer reusedBuffer;
            while ((reusedBuffer = this.reuseBuffersQueue.poll()) != null) {
                AIOSequentialFileFactory.this.releaseBuffer(reusedBuffer);
            }
        }

        private class LocalBufferCallback
        implements BufferCallback {
            private LocalBufferCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bufferDone(ByteBuffer buffer) {
                ReuseBuffersController reuseBuffersController = ReuseBuffersController.this;
                synchronized (reuseBuffersController) {
                    if (ReuseBuffersController.this.stopped) {
                        AIOSequentialFileFactory.this.releaseBuffer(buffer);
                    } else {
                        ReuseBuffersController.this.bufferReuseLastTime = System.currentTimeMillis();
                        if (buffer.capacity() == AIOSequentialFileFactory.this.bufferSize) {
                            ReuseBuffersController.this.reuseBuffersQueue.offer(buffer);
                        } else {
                            AIOSequentialFileFactory.this.releaseBuffer(buffer);
                        }
                    }
                }
            }
        }
    }
}

