/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.WriteListener;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Response;
import org.apache.coyote.ActionCode;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;
import org.jboss.web.CatalinaMessages;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private ByteChunk bb;
    private CharChunk cb;
    private boolean initial = true;
    private long bytesWritten = 0L;
    private long charsWritten = 0L;
    private boolean closed = false;
    private boolean doFlush = false;
    private ByteChunk outputChunk = new ByteChunk();
    private CharChunk outputCharChunk = new CharChunk();
    private String enc;
    private boolean gotEnc = false;
    protected HashMap<String, C2BConverter> encoders = new HashMap();
    protected C2BConverter conv;
    private org.apache.coyote.Response coyoteResponse;
    private Response response;
    private boolean suspended = false;
    private WriteListener writeListener = null;

    public OutputBuffer(Response response) {
        this(response, 8192);
    }

    public OutputBuffer(Response response, int size) {
        this.response = response;
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteOutputChannel(this);
        this.cb = new CharChunk(size);
        this.cb.setLimit(size);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharOutputChannel(this);
    }

    public void setResponse(org.apache.coyote.Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
    }

    public org.apache.coyote.Response getResponse() {
        return this.coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void recycle() {
        this.initial = true;
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.bb.recycle();
        this.cb.recycle();
        this.outputCharChunk.setChars(null, 0, 0);
        this.closed = false;
        this.suspended = false;
        this.doFlush = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
        this.writeListener = null;
    }

    public void clearEncoders() {
        this.encoders.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (this.cb.getLength() > 0) {
            this.cb.flushBuffer();
        }
        if (!this.coyoteResponse.isCommitted() && this.coyoteResponse.getContentLengthLong() == -1L && !this.coyoteResponse.isCommitted()) {
            this.coyoteResponse.setContentLength(this.bb.getLength());
        }
        this.doFlush(false);
        this.closed = true;
        this.coyoteResponse.finish();
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        this.doFlush = true;
        if (this.initial) {
            this.coyoteResponse.sendHeaders();
            this.initial = false;
        }
        if (this.cb.getLength() > 0) {
            this.cb.flushBuffer();
        }
        if (this.bb.getLength() > 0) {
            this.bb.flushBuffer();
        }
        this.doFlush = false;
        if (realFlush) {
            this.coyoteResponse.action(ActionCode.ACTION_CLIENT_FLUSH, this.coyoteResponse);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    protected int lastWrite() {
        int res = this.coyoteResponse.getLastWrite();
        if (res == 0) {
            this.coyoteResponse.action(ActionCode.ACTION_EVENT_WRITE, null);
        }
        return res;
    }

    @Override
    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (cnt > 0) {
            this.outputChunk.setBytes(buf, off, cnt);
            try {
                this.coyoteResponse.doWrite(this.outputChunk);
            }
            catch (IOException e) {
                throw new ClientAbortException(e);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(b, off, len);
        this.bytesWritten += (long)len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    @Override
    public void realWriteChars(char[] buf, int off, int len) throws IOException {
        this.outputCharChunk.setChars(buf, off, len);
        while (this.outputCharChunk.getLength() > 0) {
            this.conv.convert(this.outputCharChunk, this.bb);
            if (this.bb.getLength() == 0) break;
            if (this.outputCharChunk.getLength() <= 0) continue;
            this.bb.flushBuffer();
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.cb.append((char)c);
        ++this.charsWritten;
    }

    @Override
    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.cb.append(c, off, len);
        this.charsWritten += (long)len;
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s == null) {
            s = "null";
        }
        this.cb.append(s, off, len);
        this.charsWritten += (long)len;
    }

    @Override
    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s == null) {
            s = "null";
        }
        this.cb.append(s);
        this.charsWritten += (long)s.length();
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setConverter() throws IOException {
        if (this.coyoteResponse != null) {
            this.enc = this.coyoteResponse.getCharacterEncoding();
        }
        this.gotEnc = true;
        this.enc = this.enc == null ? "ISO-8859-1" : this.enc.toUpperCase(Locale.US);
        this.conv = this.encoders.get(this.enc);
        if (this.conv == null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    this.conv = AccessController.doPrivileged(new PrivilegedExceptionAction<C2BConverter>(){

                        @Override
                        public C2BConverter run() throws IOException {
                            return new C2BConverter(OutputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    e = ex.getException();
                    if (!(e instanceof IOException)) ** GOTO lbl16
                    throw (IOException)e;
                }
            } else {
                this.conv = new C2BConverter(this.enc);
            }
lbl16:
            // 3 sources

            this.encoders.put(this.enc, this.conv);
        }
    }

    public void flushBytes() throws IOException {
        this.bb.flushBuffer();
    }

    public int getBytesWritten() {
        if (this.bytesWritten < Integer.MAX_VALUE) {
            return (int)this.bytesWritten;
        }
        return -1;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public int getCharsWritten() {
        if (this.charsWritten < Integer.MAX_VALUE) {
            return (int)this.charsWritten;
        }
        return -1;
    }

    public int getContentWritten() {
        long size = this.bytesWritten + this.charsWritten;
        if (size < Integer.MAX_VALUE) {
            return (int)size;
        }
        return -1;
    }

    public long getContentWrittenLong() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0L && this.charsWritten == 0L;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.cb.recycle();
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.gotEnc = false;
        this.enc = null;
        this.initial = true;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }

    public WriteListener getWriteListener() {
        return this.writeListener;
    }

    public void setWriteListener(WriteListener writeListener) {
        if (this.writeListener != null) {
            throw CatalinaMessages.MESSAGES.writeListenerAlreadySet();
        }
        if (writeListener == null) {
            throw CatalinaMessages.MESSAGES.nullListener();
        }
        if (!this.response.getRequest().isEventMode()) {
            throw CatalinaMessages.MESSAGES.cannotSetListenerWithoutUpgradeOrAsync();
        }
        this.writeListener = writeListener;
        this.coyoteResponse.action(ActionCode.ACTION_EVENT_WRITE_BEGIN, null);
    }
}

