/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.tomcat.jni.Library;
import org.jboss.web.CatalinaLogger;

public class AprLifecycleListener
implements LifecycleListener {
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 1;
    protected static final int TCN_REQUIRED_PATCH = 8;
    protected static final int TCN_RECOMMENDED_PV = 21;
    protected static String SSLEngine = "on";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean aprInitialized = false;

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType()) && (aprInitialized = this.init())) {
            try {
                AprLifecycleListener.initializeSSL();
            }
            catch (Throwable t) {
                if (!CatalinaLogger.CORE_LOGGER.isDebugEnabled()) {
                    CatalinaLogger.CORE_LOGGER.aprSslEngineInitFailed();
                }
                CatalinaLogger.CORE_LOGGER.aprSslEngineInitFailedWithThrowable(t);
            }
        }
    }

    private boolean init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (aprInitialized) {
            return true;
        }
        try {
            String methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
        }
        catch (Throwable t) {
            if (!CatalinaLogger.CORE_LOGGER.isDebugEnabled()) {
                CatalinaLogger.CORE_LOGGER.aprInitFailed(System.getProperty("java.library.path"));
            } else {
                CatalinaLogger.CORE_LOGGER.aprInitFailedWithThrowable(System.getProperty("java.library.path"), t);
            }
            return false;
        }
        if (major != 1 || minor != 1 || patch < 8) {
            CatalinaLogger.CORE_LOGGER.aprInvalidVersion(major, minor, patch, 1, 1, 8);
            return false;
        }
        if (patch < 21) {
            CatalinaLogger.CORE_LOGGER.aprRecommendedVersion(major, minor, patch, 1, 1, 21);
        }
        CatalinaLogger.CORE_LOGGER.aprInit(major, minor, patch, Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_RANDOM);
        return true;
    }

    private static synchronized void initializeSSL() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        sslInitialized = true;
    }

    public static boolean isAprInitialized() {
        return aprInitialized;
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine2) {
        SSLEngine = SSLEngine2;
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
    }
}

