/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CatalinaMessages;

public class EventOrAsyncConnectionManagerValve
extends ValveBase
implements Lifecycle,
HttpSessionListener,
LifecycleListener {
    protected static final String info = "org.apache.catalina.valves.CometConnectionManagerValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected boolean started = false;
    protected List<Request> cometRequests = Collections.synchronizedList(new ArrayList());
    protected String cometRequestsAttribute = "org.apache.tomcat.comet.connectionList";

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.valveAlreadyStarted());
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container instanceof Context) {
            ((Lifecycle)((Object)this.container)).addLifecycleListener(this);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(CatalinaMessages.MESSAGES.valveNotStarted());
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.container instanceof Context) {
            ((Lifecycle)((Object)this.container)).removeLifecycleListener(this);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "before_stop") {
            for (Request request : this.cometRequests) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    try {
                        session.removeAttribute(this.cometRequestsAttribute);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                try {
                    request.getEvent().close();
                }
                catch (Exception e) {
                    this.container.getLogger().warn((Object)CatalinaMessages.MESSAGES.eventValveExceptionDuringEvent(), (Throwable)e);
                }
            }
            this.cometRequests.clear();
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (request.isEventMode() && !response.isClosed()) {
            HttpSession session = request.getSession(true);
            this.cometRequests.add(request);
            HttpSession httpSession = session;
            synchronized (httpSession) {
                Request[] requests = (Request[])session.getAttribute(this.cometRequestsAttribute);
                if (requests == null) {
                    requests = new Request[]{request};
                    session.setAttribute(this.cometRequestsAttribute, (Object)requests);
                } else {
                    Request[] newRequests = new Request[requests.length + 1];
                    for (int i = 0; i < requests.length; ++i) {
                        newRequests[i] = requests[i];
                    }
                    newRequests[requests.length] = request;
                    session.setAttribute(this.cometRequestsAttribute, (Object)newRequests);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        block27: {
            boolean ok = false;
            try {
                this.getNext().event(request, response, event);
                ok = true;
                if (ok && !response.isClosed() && event.getType() != HttpEvent.EventType.END && event.getType() != HttpEvent.EventType.ERROR) break block27;
                this.cometRequests.remove(request);
            }
            catch (Throwable throwable) {
                if (!ok || response.isClosed() || event.getType() == HttpEvent.EventType.END || event.getType() == HttpEvent.EventType.ERROR) {
                    this.cometRequests.remove(request);
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        HttpSession httpSession = session;
                        synchronized (httpSession) {
                            Request[] reqs = (Request[])session.getAttribute(this.cometRequestsAttribute);
                            if (reqs != null) {
                                boolean found = false;
                                for (int i = 0; !found && i < reqs.length; ++i) {
                                    found = reqs[i] == request;
                                }
                                if (found) {
                                    if (reqs.length > 1) {
                                        Request[] newConnectionInfos = new Request[reqs.length - 1];
                                        int pos = 0;
                                        for (int i = 0; i < reqs.length; ++i) {
                                            if (reqs[i] == request) continue;
                                            newConnectionInfos[pos++] = reqs[i];
                                        }
                                        session.setAttribute(this.cometRequestsAttribute, (Object)newConnectionInfos);
                                    } else {
                                        try {
                                            session.removeAttribute(this.cometRequestsAttribute);
                                        }
                                        catch (IllegalStateException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw throwable;
            }
            HttpSession session = request.getSession(false);
            if (session != null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    Request[] reqs = (Request[])session.getAttribute(this.cometRequestsAttribute);
                    if (reqs != null) {
                        boolean found = false;
                        for (int i = 0; !found && i < reqs.length; ++i) {
                            found = reqs[i] == request;
                        }
                        if (found) {
                            if (reqs.length > 1) {
                                Request[] newConnectionInfos = new Request[reqs.length - 1];
                                int pos = 0;
                                for (int i = 0; i < reqs.length; ++i) {
                                    if (reqs[i] == request) continue;
                                    newConnectionInfos[pos++] = reqs[i];
                                }
                                session.setAttribute(this.cometRequestsAttribute, (Object)newConnectionInfos);
                            } else {
                                try {
                                    session.removeAttribute(this.cometRequestsAttribute);
                                }
                                catch (IllegalStateException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Request[] reqs = (Request[])se.getSession().getAttribute(this.cometRequestsAttribute);
        if (reqs != null) {
            for (int i = 0; i < reqs.length; ++i) {
                Request req = reqs[i];
                try {
                    req.getEvent().close();
                    continue;
                }
                catch (Exception e) {
                    req.getWrapper().getParent().getLogger().warn((Object)CatalinaMessages.MESSAGES.eventValveSessionListenerException(), (Throwable)e);
                }
            }
        }
    }
}

