/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.Constants;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.web.CoyoteLogger;

public class AjpAprProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected ObjectName tpOname;
    protected ObjectName rgOname;
    protected AprEndpoint endpoint = new AprEndpoint();
    protected Hashtable attributes = new Hashtable();
    private Adapter adapter;
    private AjpConnectionHandler cHandler;
    private boolean canDestroy = false;
    protected int processorCache = -1;
    protected boolean tomcatAuthentication = org.apache.coyote.ajp.Constants.DEFAULT_TOMCAT_AUTHENTICATION;
    protected String requiredSecret = null;
    protected int packetSize = org.apache.coyote.ajp.Constants.MAX_PACKET_SIZE;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public AjpAprProtocol() {
        this.cHandler = new AjpConnectionHandler(this);
        this.setSoLinger(-1);
        this.setSoTimeout(org.apache.coyote.ajp.Constants.DEFAULT_CONNECTION_TIMEOUT);
        this.setTcpNoDelay(true);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean hasIoEvents() {
        return false;
    }

    @Override
    public RequestGroupInfo getRequestGroupInfo() {
        return this.cHandler.global;
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        this.endpoint.setUseSendfile(false);
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            CoyoteLogger.AJP_LOGGER.errorInitializingEndpoint(ex);
            throw ex;
        }
    }

    @Override
    public void start() throws Exception {
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                CoyoteLogger.AJP_LOGGER.errorRegisteringPool(e);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            CoyoteLogger.AJP_LOGGER.errorStartingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.AJP_LOGGER.startingAjpProtocol(this.getName());
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            CoyoteLogger.AJP_LOGGER.errorPausingEndpoint(ex);
            throw ex;
        }
        this.canDestroy = false;
        RequestInfo[] states = this.cHandler.global.getRequestProcessors();
        int retry = 0;
        boolean done = false;
        while (!done && retry < Constants.MAX_PAUSE_WAIT) {
            ++retry;
            done = true;
            for (int i = 0; i < states.length; ++i) {
                if (states[i].getStage() != 3) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                done = false;
                break;
            }
            if (!done) continue;
            this.canDestroy = true;
        }
        CoyoteLogger.AJP_LOGGER.pausingAjpProtocol(this.getName());
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            CoyoteLogger.AJP_LOGGER.errorResumingEndpoint(ex);
            throw ex;
        }
        CoyoteLogger.AJP_LOGGER.resumingAjpProtocol(this.getName());
    }

    @Override
    public void destroy() throws Exception {
        CoyoteLogger.AJP_LOGGER.stoppingAjpProtocol(this.getName());
        if (this.canDestroy) {
            this.endpoint.destroy();
        } else {
            CoyoteLogger.AJP_LOGGER.cannotDestroyAjpProtocol(this.getName());
            try {
                RequestInfo[] states = this.cHandler.global.getRequestProcessors();
                for (int i = 0; i < states.length; ++i) {
                    if (states[i].getStage() != 3) continue;
                }
            }
            catch (Exception ex) {
                CoyoteLogger.AJP_LOGGER.cannotDestroyAjpProtocolWithException(this.getName(), ex);
                throw ex;
            }
        }
        if (org.apache.tomcat.util.Constants.ENABLE_MODELER) {
            if (this.tpOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
            }
            if (this.rgOname != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
            }
        }
    }

    public String getJmxName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            encodedAddr = URLEncoder.encode(encodedAddr.replace('/', '-').replace(':', '_').replace('%', '-')) + "-";
        }
        return "ajp-" + encodedAddr + this.endpoint.getPort();
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = this.getAddress() + ":";
        }
        return "ajp-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getReverseConnection() {
        return this.endpoint.isReverseConnection();
    }

    public void setReverseConnection(boolean reverseConnection) {
        this.endpoint.setReverseConnection(reverseConnection);
    }

    public boolean getDeferAccept() {
        return this.endpoint.getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        this.endpoint.setDeferAccept(deferAccept);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int timeout) {
        this.endpoint.setKeepAliveTimeout(timeout);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
    }

    public int getPollTime() {
        return this.endpoint.getPollTime();
    }

    public void setPollTime(int pollTime) {
        this.endpoint.setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setPollerSize(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getPollerSize();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    protected static class AjpConnectionHandler
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Long, AjpAprProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<AjpAprProcessor> recycledProcessors = new ConcurrentLinkedQueue<AjpAprProcessor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(AjpAprProcessor processor) {
                boolean offer = AjpConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < AjpConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    AjpConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public AjpAprProcessor poll() {
                AjpAprProcessor result = (AjpAprProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                AjpAprProcessor next = this.poll();
                while (next != null) {
                    AjpConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        public AjpConnectionHandler(AjpAprProtocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AprEndpoint.Handler.SocketState event(long socket, SocketStatus status) {
            AjpAprProcessor result = this.connections.get(socket);
            AprEndpoint.Handler.SocketState state = AprEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                result.startProcessing();
                try {
                    state = result.event(status);
                }
                catch (SocketException e) {
                    CoyoteLogger.AJP_LOGGER.socketException(e);
                }
                catch (IOException e) {
                    CoyoteLogger.AJP_LOGGER.socketException(e);
                }
                catch (Throwable e) {
                    CoyoteLogger.AJP_LOGGER.socketError(e);
                }
                finally {
                    if (state != AprEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                        if (this.proto.endpoint.isRunning() && state == AprEndpoint.Handler.SocketState.OPEN) {
                            this.proto.endpoint.getPoller().add(socket);
                        }
                    } else if (this.proto.endpoint.isRunning()) {
                        this.proto.endpoint.getEventPoller().add(socket, result.getTimeout(), false, false, result.getResumeNotification(), false);
                    }
                    result.endProcessing();
                }
            }
            return state;
        }

        @Override
        public AprEndpoint.Handler.SocketState process(long socket) {
            AjpAprProcessor processor = this.recycledProcessors.poll();
            try {
                AprEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if ((state = processor.process(socket)) == AprEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    this.proto.endpoint.getEventPoller().add(socket, processor.getTimeout(), false, false, processor.getResumeNotification(), false);
                } else {
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                CoyoteLogger.AJP_LOGGER.socketException(e);
            }
            catch (IOException e) {
                CoyoteLogger.AJP_LOGGER.socketException(e);
            }
            catch (Throwable e) {
                CoyoteLogger.AJP_LOGGER.socketError(e);
            }
            this.recycledProcessors.offer(processor);
            return AprEndpoint.Handler.SocketState.CLOSED;
        }

        protected AjpAprProcessor createProcessor() {
            AjpAprProcessor processor = new AjpAprProcessor(this.proto.packetSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AjpAprProcessor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(this.global);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getJmxName() + ",name=AjpRequest" + count);
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        CoyoteLogger.AJP_LOGGER.errorRegisteringRequest(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(AjpAprProcessor processor) {
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(null);
            if (org.apache.tomcat.util.Constants.ENABLE_MODELER && this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        ObjectName rpName = rp.getRpName();
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        CoyoteLogger.AJP_LOGGER.errorUnregisteringRequest(e);
                    }
                }
            }
        }
    }
}

