/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class RunningServerUpdateTask
extends ServerUpdateTask {
    private final ModelNode serverUpdate;

    RunningServerUpdateTask(ServerIdentity serverId, ModelNode serverUpdate, ServerUpdatePolicy updatePolicy, ServerUpdateTask.ServerUpdateResultHandler resultHandler) {
        super(serverId, updatePolicy, resultHandler);
        this.serverUpdate = serverUpdate;
    }

    @Override
    public ModelNode getOperation() {
        return this.getServerOp();
    }

    private ModelNode getServerOp() {
        ModelNode op = this.serverUpdate.clone();
        ModelNode address = new ModelNode();
        address.add("host", this.serverId.getHostName());
        address.add("server", this.serverId.getServerName());
        if (this.serverUpdate.hasDefined("address")) {
            for (Property prop : this.serverUpdate.get("address").asPropertyList()) {
                address.add(prop.getName(), prop.getValue().asString());
            }
        }
        op.get("address").set(address);
        return op;
    }
}

