/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalContextObjectFactory
implements ObjectFactory {
    private static final AtomicInteger PROXY_ID = new AtomicInteger();
    public static final String CACHE_CONTEXT = "cache-context";
    public static final String INITIAL_CONTEXT_CLASS = "initial-context-class";
    public static final String INITIAL_CONTEXT_MODULE = "initial-context-module";
    private volatile Context cachedObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean cache;
        String cacheString = (String)environment.get(CACHE_CONTEXT);
        boolean bl = cache = cacheString != null && cacheString.toLowerCase().equals("true");
        if (cache) {
            if (this.cachedObject == null) {
                ExternalContextObjectFactory externalContextObjectFactory = this;
                synchronized (externalContextObjectFactory) {
                    if (this.cachedObject == null) {
                        this.cachedObject = this.createContext(environment, true);
                    }
                }
            }
            return this.cachedObject;
        }
        return this.createContext(environment, false);
    }

    private Context createContext(Hashtable<?, ?> environment, boolean useProxy) throws NamingException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ModuleLoadException {
        Context context;
        String initialContextClassName = (String)environment.get(INITIAL_CONTEXT_CLASS);
        String initialContextModule = (String)environment.get(INITIAL_CONTEXT_MODULE);
        Hashtable newEnvironment = new Hashtable(environment);
        newEnvironment.remove(CACHE_CONTEXT);
        newEnvironment.remove(INITIAL_CONTEXT_CLASS);
        newEnvironment.remove(INITIAL_CONTEXT_MODULE);
        ClassLoader loader = !WildFlySecurityManager.isChecking() ? this.getClass().getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return this.getClass().getClassLoader();
            }
        });
        Class<?> initialContextClass = null;
        if (initialContextModule == null) {
            initialContextClass = Class.forName(initialContextClassName);
            Constructor<?> ctor = initialContextClass.getConstructor(Hashtable.class);
            context = (Context)ctor.newInstance(newEnvironment);
        } else {
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.fromString((String)initialContextModule));
            loader = module.getClassLoader();
            initialContextClass = Class.forName(initialContextClassName, true, (ClassLoader)module.getClassLoader());
            Constructor<?> ctor = initialContextClass.getConstructor(Hashtable.class);
            context = (Context)ctor.newInstance(newEnvironment);
        }
        if (!useProxy) {
            return context;
        }
        ProxyConfiguration config = new ProxyConfiguration();
        config.setClassLoader(loader);
        config.setSuperClass(initialContextClass);
        config.setProxyName(initialContextClassName + "$$$$Proxy" + PROXY_ID.incrementAndGet());
        ProxyFactory factory = new ProxyFactory(config);
        return (Context)factory.newInstance((InvocationHandler)new CachedContext(context));
    }

    static class CachedContext
    implements InvocationHandler {
        Context externalCtx;

        CachedContext(Context externalCtx) {
            this.externalCtx = externalCtx;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            if (!method.getName().equals("close")) {
                try {
                    value = method.invoke((Object)this.externalCtx, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return value;
        }
    }
}

