/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.GroupCommunicationService;
import org.jboss.as.clustering.GroupMembershipListener;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.GroupStateTransferService;
import org.jboss.as.clustering.ResponseFilter;
import org.jboss.as.clustering.SerializableStateTransferResult;
import org.jboss.as.clustering.StateTransferProvider;
import org.jboss.as.clustering.StateTransferResult;
import org.jboss.as.clustering.StreamStateTransferResult;
import org.jboss.as.clustering.impl.AsynchEventHandler;
import org.jboss.as.clustering.impl.ClusterNodeFactory;
import org.jboss.as.clustering.impl.ClusterNodeImpl;
import org.jboss.as.clustering.impl.ClusteringImplLogger;
import org.jboss.as.clustering.impl.ClusteringImplMessages;
import org.jboss.as.clustering.impl.CoreGroupClassTable;
import org.jboss.as.clustering.impl.RspFilterAdapter;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.ReflectiveCreator;
import org.jboss.marshalling.reflect.SunReflectiveCreator;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.StateTransferException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class CoreGroupCommunicationService
implements Service<CoreGroupCommunicationService>,
GroupRpcDispatcher,
GroupMembershipNotifier,
GroupStateTransferService {
    private static final byte NULL_VALUE = 0;
    private static final byte SERIALIZABLE_VALUE = 1;
    private final Value<Channel> channelRef;
    private final Value<ModuleLoader> loaderRef;
    static final MarshallerFactory marshallerFactory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader());
    final MarshallingConfiguration marshallingConfig = new MarshallingConfiguration();
    volatile Channel channel;
    volatile ClusterNode me = null;
    private volatile GroupView groupView = new GroupView();
    private long method_call_timeout = 60000L;
    final short scopeId;
    private volatile RpcDispatcher dispatcher = null;
    final Map<String, Object> rpcHandlers = new ConcurrentHashMap<String, Object>();
    private boolean directlyInvokeLocal;
    private boolean allowSyncListeners = false;
    final List<GroupMembershipListener> asyncMembershipListeners = new CopyOnWriteArrayList<GroupMembershipListener>();
    private final List<GroupMembershipListener> syncMembershipListeners = new CopyOnWriteArrayList<GroupMembershipListener>();
    private final AsynchEventHandler asynchHandler = new AsynchEventHandler(new ViewChangeEventProcessor(), "AsynchViewChangeHandler");
    private long state_transfer_timeout = 60000L;
    volatile String stateIdPrefix;
    final Map<String, StateTransferProvider> stateProviders = new ConcurrentHashMap<String, StateTransferProvider>();
    final Map<String, StateTransferTask<?, ?>> stateTransferTasks = new ConcurrentHashMap();
    private final List<String> history = new LinkedList<String>();
    private int maxHistoryLength = 100;
    Executor threadPool;
    final ThreadGate flushBlockGate = new ThreadGate();
    private final ClusterNodeFactory nodeFactory = new ClusterNodeFactoryImpl();

    public static ServiceName getServiceName(String name) {
        return ServiceName.JBOSS.append(new String[]{"cluster"}).append(new String[]{name});
    }

    public CoreGroupCommunicationService(short scope, Value<Channel> channel, Value<ModuleLoader> loader) {
        this.scopeId = scope;
        this.channelRef = channel;
        this.loaderRef = loader;
    }

    public CoreGroupCommunicationService getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.channel = (Channel)this.channelRef.getValue();
        this.marshallingConfig.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.loaderRef.getValue())));
        this.marshallingConfig.setSerializedCreator((Creator)new SunReflectiveCreator());
        this.marshallingConfig.setExternalizerCreator((Creator)new ReflectiveCreator());
        this.marshallingConfig.setClassTable((ClassTable)CoreGroupClassTable.INSTANCE);
        try {
            this.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.stop();
    }

    public boolean isConsistentWith(GroupCommunicationService other) {
        return this == other;
    }

    public String getNodeName() {
        return this.me != null ? this.me.getName() : null;
    }

    public String getGroupName() {
        return this.channel != null ? this.channel.getClusterName() : null;
    }

    public List<String> getCurrentView() {
        GroupView curView = this.groupView;
        ArrayList<String> result = new ArrayList<String>(curView.allMembers.size());
        for (ClusterNode member : curView.allMembers) {
            result.add(member.getName());
        }
        return result;
    }

    public long getCurrentViewId() {
        return this.groupView.viewId;
    }

    public List<ClusterNode> getClusterNodes() {
        return new ArrayList<ClusterNode>(this.groupView.allMembers);
    }

    public ClusterNode getClusterNode() {
        return this.me;
    }

    public boolean isCoordinator() {
        GroupView curView = this.groupView;
        if (curView.allMembers.isEmpty() || this.me == null) {
            return false;
        }
        return curView.allMembers.get(0).equals(this.me);
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.put(objName, subscriber);
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.remove(objName);
    }

    public <T> List<T> callMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws InterruptedException {
        return this.callMethodOnCluster(serviceName, methodName, args, types, excludeSelf, null, this.getMethodCallTimeout(), false);
    }

    public <T> List<T> callMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, ResponseFilter filter) throws InterruptedException {
        return this.callMethodOnCluster(serviceName, methodName, args, types, excludeSelf, filter, this.getMethodCallTimeout(), false);
    }

    public <T> List<T> callMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, ResponseFilter filter, long methodTimeout, boolean unordered) throws InterruptedException {
        boolean trace;
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, methodTimeout, false, (RspFilter)new NoHandlerForRPCRspFilter(filter));
        if (excludeSelf) {
            options.setExclusionList(new Address[]{this.channel.getAddress()});
        }
        if (this.channel.flushSupported()) {
            this.flushBlockGate.await(this.getMethodCallTimeout());
        }
        if (trace = ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled()) {
            ClusteringImplLogger.ROOT_LOGGER.tracef("calling synchronous method on cluster, serviceName=%s, methodName=%s, members=%s, excludeSelf=%s", new Object[]{serviceName, methodName, this.groupView, excludeSelf});
        }
        try {
            List<T> result;
            block11: {
                RspList rsp = this.dispatcher.callRemoteMethods(null, m, options);
                result = this.processResponseList(rsp, serviceName, methodName, args, trace);
                if (!excludeSelf && this.directlyInvokeLocal && (filter == null || filter.needMoreResponses())) {
                    try {
                        this.invokeDirectly(serviceName, methodName, args, types, result, filter);
                    }
                    catch (Exception e) {
                        if (filter != null && !filter.isAcceptable((Object)e, this.me)) break block11;
                        ClusteringImplLogger.ROOT_LOGGER.debugf(e, "%s local invocation failure: %s(%s)", serviceName, methodName, args != null ? Arrays.asList(args) : "");
                    }
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    <T> T invokeDirectly(String serviceName, String methodName, Object[] args, Class<?>[] types, List<T> remoteResponses, ResponseFilter filter) throws Exception {
        Object retVal = null;
        Object handler = this.rpcHandlers.get(serviceName);
        if (handler != null) {
            MethodCall call = new MethodCall(methodName, args, (Class[])types);
            try {
                Object result;
                retVal = result = call.invoke(handler);
                if (remoteResponses != null && (filter == null || filter.isAcceptable(retVal, this.me))) {
                    remoteResponses.add(retVal);
                }
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return (T)retVal;
    }

    public <T> T callMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws Exception {
        return this.callMethodOnCoordinatorNode(serviceName, methodName, args, types, excludeSelf, this.getMethodCallTimeout(), false);
    }

    public <T> T callMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, long methodTimeout, boolean unordered) throws Exception {
        boolean trace = ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            ClusteringImplLogger.ROOT_LOGGER.tracef("callMethodOnCoordinatorNode(false), objName=%s, methodName=%s", serviceName, methodName);
        }
        if (this.isCoordinator()) {
            if (excludeSelf) {
                return null;
            }
            if (this.directlyInvokeLocal) {
                return this.invokeDirectly(serviceName, methodName, args, types, null, null);
            }
        }
        Address coord = this.groupView.coordinator;
        RequestOptions opt = new RequestOptions(ResponseMode.GET_ALL, methodTimeout, false, (RspFilter)new NoHandlerForRPCRspFilter());
        if (unordered) {
            opt.setFlags(new Message.Flag[]{Message.OOB});
        }
        try {
            return (T)this.dispatcher.callRemoteMethod(coord, m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw ClusteringImplMessages.MESSAGES.caughtRemoteInvocationThrowable(e);
        }
    }

    public <T> T callMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, ClusterNode targetNode) throws Exception {
        return this.callMethodOnNode(serviceName, methodName, args, types, this.getMethodCallTimeout(), targetNode, false);
    }

    public <T> T callMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, long methodTimeout, ClusterNode targetNode) throws Exception {
        return this.callMethodOnNode(serviceName, methodName, args, types, methodTimeout, targetNode, false);
    }

    public <T> T callMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, long methodTimeout, ClusterNode targetNode, boolean unordered) throws Exception {
        if (!(targetNode instanceof ClusterNodeImpl)) {
            throw ClusteringImplMessages.MESSAGES.invalidTargetNodeInstance(targetNode, ClusterNodeImpl.class);
        }
        boolean trace = ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            ClusteringImplLogger.ROOT_LOGGER.tracef("callMethodOnNode( objName=%s, methodName=%s )", serviceName, methodName);
        }
        if (this.directlyInvokeLocal && this.me.equals(targetNode)) {
            return this.invokeDirectly(serviceName, methodName, args, types, null, null);
        }
        RequestOptions opt = new RequestOptions(ResponseMode.GET_FIRST, methodTimeout, false, (RspFilter)new NoHandlerForRPCRspFilter());
        if (unordered) {
            opt.setFlags(new Message.Flag[]{Message.OOB});
        }
        try {
            return (T)this.dispatcher.callRemoteMethod(((ClusterNodeImpl)targetNode).getOriginalJGAddress(), m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw ClusteringImplMessages.MESSAGES.caughtRemoteInvocationThrowable(e);
        }
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, ClusterNode targetNode) throws Exception {
        this.callAsyncMethodOnNode(serviceName, methodName, args, types, targetNode, false);
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, ClusterNode targetNode, boolean unordered) throws Exception {
        if (!(targetNode instanceof ClusterNodeImpl)) {
            throw ClusteringImplMessages.MESSAGES.invalidTargetNodeInstance(targetNode, ClusterNodeImpl.class);
        }
        boolean trace = ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            ClusteringImplLogger.ROOT_LOGGER.tracef("callAsyncMethodOnNode( objName=%s, methodName=%s )" + methodName, serviceName, methodName);
        }
        if (this.directlyInvokeLocal && this.me.equals(targetNode)) {
            new AsynchronousLocalInvocation(serviceName, methodName, args, types).invoke();
            return;
        }
        RequestOptions opt = new RequestOptions(ResponseMode.GET_NONE, this.getMethodCallTimeout(), false, (RspFilter)new NoHandlerForRPCRspFilter());
        if (unordered) {
            opt.setFlags(new Message.Flag[]{Message.OOB});
        }
        try {
            this.dispatcher.callRemoteMethod(((ClusterNodeImpl)targetNode).getOriginalJGAddress(), m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw ClusteringImplMessages.MESSAGES.caughtRemoteInvocationThrowable(e);
        }
    }

    public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws InterruptedException {
        this.callAsynchMethodOnCluster(serviceName, methodName, args, types, excludeSelf, false);
    }

    public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, boolean unordered) throws InterruptedException {
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, this.getMethodCallTimeout(), false, (RspFilter)new NoHandlerForRPCRspFilter());
        if (excludeSelf) {
            options.setExclusionList(new Address[]{this.channel.getAddress()});
        }
        if (this.channel.flushSupported()) {
            this.flushBlockGate.await(this.getMethodCallTimeout());
        }
        if (ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled()) {
            ClusteringImplLogger.ROOT_LOGGER.tracef("calling asynch method on cluster, serviceName=%s, methodName=%s, members=%s, excludeSelf=%s", new Object[]{serviceName, methodName, this.groupView, excludeSelf});
        }
        try {
            this.dispatcher.callRemoteMethods(null, m, options);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!excludeSelf && this.directlyInvokeLocal) {
                new AsynchronousLocalInvocation(serviceName, methodName, args, types).invoke();
            }
        }
    }

    public void callAsyncMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws Exception {
        this.callAsyncMethodOnCoordinatorNode(serviceName, methodName, args, types, excludeSelf, false);
    }

    public void callAsyncMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, boolean unordered) throws Exception {
        boolean trace = ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            ClusteringImplLogger.ROOT_LOGGER.tracef("callMethodOnCoordinatorNode(false), objName=%s, methodName=%s", serviceName, methodName);
        }
        if (this.isCoordinator()) {
            if (!excludeSelf) {
                if (this.directlyInvokeLocal) {
                    new AsynchronousLocalInvocation(serviceName, methodName, args, types).invoke();
                }
            } else {
                return;
            }
        }
        Address coord = this.groupView.coordinator;
        RequestOptions opt = new RequestOptions(ResponseMode.GET_ALL, this.getMethodCallTimeout(), false, (RspFilter)new NoHandlerForRPCRspFilter());
        if (unordered) {
            opt.setFlags(new Message.Flag[]{Message.OOB});
        }
        try {
            this.dispatcher.callRemoteMethod(coord, m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw ClusteringImplMessages.MESSAGES.caughtRemoteInvocationThrowable(e);
        }
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.allowSyncListeners;
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.allowSyncListeners = allowSync;
    }

    public void registerGroupMembershipListener(GroupMembershipListener listener) {
        this.registerGroupMembershipListener(listener, false);
    }

    public void unregisterGroupMembershipListener(GroupMembershipListener listener) {
        this.unregisterGroupMembershipListener(listener, false);
    }

    public long getStateTransferTimeout() {
        return this.state_transfer_timeout;
    }

    public void setStateTransferTimeout(long timeout) {
        this.state_transfer_timeout = timeout;
    }

    public Future<SerializableStateTransferResult> getServiceState(String serviceName, ClassLoader classloader) {
        FutureTask<SerializableStateTransferResult> future = null;
        StateTransferTask<?, ?> task = this.stateTransferTasks.get(serviceName);
        if (task == null || task.result != null && !task.result.stateReceived()) {
            SerializableStateTransferTask newTask = new SerializableStateTransferTask(serviceName, classloader);
            this.stateTransferTasks.put(serviceName, newTask);
            future = new FutureTask<SerializableStateTransferResult>(newTask);
        } else if (task instanceof SerializableStateTransferTask) {
            ClusteringImplLogger.ROOT_LOGGER.receivedConcurrentStateRequests(serviceName);
            future = new FutureTask<SerializableStateTransferResult>((SerializableStateTransferTask)task);
        } else {
            throw ClusteringImplMessages.MESSAGES.stateTransferAlreadyPending(serviceName, "input stream");
        }
        Executor e = this.getThreadPool();
        if (e == null) {
            e = Executors.newSingleThreadExecutor();
        }
        e.execute(future);
        return future;
    }

    public Future<SerializableStateTransferResult> getServiceState(String serviceName) {
        return this.getServiceState(serviceName, null);
    }

    public Future<StreamStateTransferResult> getServiceStateAsStream(String serviceName) {
        FutureTask<StreamStateTransferResult> future = null;
        StateTransferTask<?, ?> task = this.stateTransferTasks.get(serviceName);
        if (task == null || task.result != null && !task.result.stateReceived()) {
            StreamStateTransferTask newTask = new StreamStateTransferTask(serviceName);
            this.stateTransferTasks.put(serviceName, newTask);
            future = new FutureTask<StreamStateTransferResult>(newTask);
        } else if (task instanceof StreamStateTransferTask) {
            ClusteringImplLogger.ROOT_LOGGER.receivedConcurrentStateRequests(serviceName);
            future = new FutureTask<StreamStateTransferResult>((StreamStateTransferTask)task);
        } else {
            throw ClusteringImplMessages.MESSAGES.stateTransferAlreadyPending(serviceName, "deserialized object");
        }
        Executor e = this.getThreadPool();
        if (e == null) {
            e = Executors.newSingleThreadExecutor();
        }
        e.execute(future);
        return future;
    }

    public void registerStateTransferProvider(String serviceName, StateTransferProvider provider) {
        this.stateProviders.put(serviceName, provider);
    }

    public void unregisterStateTransferProvider(String serviceName) {
        this.stateProviders.remove(serviceName);
    }

    public String showHistory() {
        StringBuffer buff = new StringBuffer();
        Vector<String> data = new Vector<String>(this.history);
        for (String info : data) {
            buff.append(info).append("\n");
        }
        return buff.toString();
    }

    public String showHistoryAsXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<events>\n");
        Vector<String> data = new Vector<String>(this.history);
        Iterator<String> row = data.iterator();
        while (row.hasNext()) {
            buff.append("   <event>\n      ");
            String info = row.next();
            buff.append(info);
            buff.append("\n   </event>\n");
        }
        buff.append("</events>\n");
        return buff.toString();
    }

    public int getMaxHistoryLength() {
        return this.maxHistoryLength;
    }

    public void setMaxHistoryLength(int maxHistoryLength) {
        this.maxHistoryLength = maxHistoryLength;
    }

    public Executor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(Executor threadPool) {
        this.threadPool = threadPool;
    }

    public String getJGroupsVersion() {
        return "3.3.1.Final( " + Version.string_version + ")";
    }

    public long getMethodCallTimeout() {
        return this.method_call_timeout;
    }

    public void setMethodCallTimeout(long timeout) {
        this.method_call_timeout = timeout;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void start() {
        if (this.channel == null) {
            throw ClusteringImplMessages.MESSAGES.channelNotDefined();
        }
        if (!this.channel.isConnected()) {
            throw ClusteringImplMessages.MESSAGES.channelNotConnected(this.channel.getName());
        }
        this.stateIdPrefix = this.getClass().getName() + "." + this.scopeId + ".";
        MembershipListenerImpl meml = new MembershipListenerImpl();
        MessageListenerImpl msgl = this.stateIdPrefix == null ? null : new MessageListenerImpl();
        this.dispatcher = new RpcHandler(this.scopeId, this.channel, msgl, meml, new RequestMarshallerImpl(), new ResponseMarshallerImpl());
        meml.viewAccepted(this.channel.getView());
        this.flushBlockGate.open();
        this.directlyInvokeLocal = this.channel.getDiscardOwnMessages();
        this.me = this.nodeFactory.getClusterNode(this.channel.getAddress());
        this.verifyNodeIsUnique();
        this.asynchHandler.start();
    }

    public void stop() {
        this.asynchHandler.stop();
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerGroupMembershipListener(GroupMembershipListener listener, boolean sync) {
        if (sync && this.allowSyncListeners) {
            List<GroupMembershipListener> list = this.syncMembershipListeners;
            synchronized (list) {
                this.syncMembershipListeners.add(listener);
            }
        }
        List<GroupMembershipListener> list = this.asyncMembershipListeners;
        synchronized (list) {
            this.asyncMembershipListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterGroupMembershipListener(GroupMembershipListener listener, boolean sync) {
        if (sync && this.allowSyncListeners) {
            List<GroupMembershipListener> list = this.syncMembershipListeners;
            synchronized (list) {
                this.syncMembershipListeners.remove(listener);
            }
        }
        List<GroupMembershipListener> list = this.asyncMembershipListeners;
        synchronized (list) {
            this.asyncMembershipListeners.remove(listener);
        }
    }

    protected void logHistory(String pattern, Object ... args) {
        if (this.maxHistoryLength > 0) {
            try {
                ArrayList<Object> list = new ArrayList<Object>(args.length + 1);
                list.add(new Date());
                list.addAll(Arrays.asList(args));
                this.history.add(String.format("%c : " + pattern, list.toArray()));
                if (this.history.size() > this.maxHistoryLength) {
                    this.history.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object objectFromByteBufferInternal(byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        unmarshaller.start(Marshalling.createByteInput((InputStream)new ByteArrayInputStream(buffer, offset, length)));
        try (Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(this.marshallingConfig);){
            Object object = unmarshaller.readObject();
            return object;
        }
    }

    byte[] objectToByteBufferInternal(Object object) throws Exception {
        Marshaller marshaller = marshallerFactory.createMarshaller(this.marshallingConfig);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        marshaller.start(Marshalling.createByteOutput((OutputStream)output));
        marshaller.writeObject(object);
        marshaller.close();
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object objectFromByteBufferResponseInternal(byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        if (buffer[offset] == 0) {
            return null;
        }
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(this.marshallingConfig);
        unmarshaller.start(Marshalling.createByteInput((InputStream)new ByteArrayInputStream(buffer, offset, length)));
        unmarshaller.read();
        try {
            Object object = unmarshaller.readObject();
            return object;
        }
        finally {
            unmarshaller.close();
        }
    }

    byte[] objectToByteBufferResponseInternal(Object obj) throws Exception {
        if (obj == null) {
            return new byte[]{0};
        }
        Marshaller marshaller = marshallerFactory.createMarshaller(this.marshallingConfig);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        marshaller.start(Marshalling.createByteOutput((OutputStream)output));
        marshaller.write(1);
        marshaller.writeObject(obj);
        marshaller.close();
        return output.toByteArray();
    }

    private <T> List<T> processResponseList(RspList<T> rspList, String serviceName, String methodName, Object[] args, boolean trace) {
        ArrayList<Object> result = new ArrayList<Object>(rspList.size());
        if (rspList != null) {
            for (Rsp response : rspList.values()) {
                if (response.hasException()) {
                    Throwable e = response.getException();
                    ClusteringImplLogger.ROOT_LOGGER.debugf(e, "%s invocation failure from %s: %s(%s)", new Object[]{serviceName, response.getSender(), methodName, args != null ? Arrays.asList(args) : ""});
                    continue;
                }
                if (response.wasReceived()) {
                    result.add(response.getValue());
                    continue;
                }
                if (!trace) continue;
                ClusteringImplLogger.ROOT_LOGGER.tracef("Ignoring non-received response: %s", response);
            }
        }
        return result;
    }

    GroupView processViewChange(View newView) throws Exception {
        GroupView oldMembers = this.groupView;
        GroupView newGroupView = new GroupView(newView, oldMembers, this.nodeFactory);
        this.logHistory(ClusteringImplMessages.MESSAGES.viewCreated(newGroupView.allMembers, newGroupView.viewId, oldMembers), new Object[0]);
        this.groupView = newGroupView;
        if (oldMembers.viewId == -1L) {
            ClusteringImplLogger.ROOT_LOGGER.debugf("ViewAccepted: initial members set for partition %s: %s (%s)", this.getGroupName(), newGroupView.viewId, this.groupView);
            ClusteringImplLogger.ROOT_LOGGER.numberOfClusterMembers(newGroupView.allMembers.size());
            for (ClusterNode node : newGroupView.allMembers) {
                ClusteringImplLogger.ROOT_LOGGER.debug(node);
            }
        } else {
            int difference = newGroupView.allMembers.size() - oldMembers.allMembers.size();
            boolean merge = newView instanceof MergeView;
            if (this.isCoordinator()) {
                ClusteringImplLogger.ROOT_LOGGER.newClusterCurrentView(this.channel.getClusterName(), newGroupView.viewId, difference, merge, newGroupView.allMembers);
            } else {
                ClusteringImplLogger.ROOT_LOGGER.newClusterView(this.getGroupName(), newGroupView.viewId, this.groupView, difference, merge);
            }
            ClusteringImplLogger.ROOT_LOGGER.debugf("dead members: %s", newGroupView.deadMembers);
            ClusteringImplLogger.ROOT_LOGGER.debugf("membership changed from %d to %d", oldMembers.allMembers.size(), newGroupView.allMembers.size());
            this.asynchHandler.queueEvent(newGroupView);
            if (this.allowSyncListeners) {
                this.notifyListeners(this.syncMembershipListeners, newGroupView.viewId, newGroupView.allMembers, newGroupView.deadMembers, newGroupView.newMembers, newGroupView.originatingGroups);
            }
        }
        return newGroupView;
    }

    private void verifyNodeIsUnique() throws IllegalStateException {
        ClusterNodeImpl matched = null;
        for (ClusterNode member : this.getClusterNodes()) {
            if (!member.equals(this.me)) continue;
            if (matched == null) {
                matched = (ClusterNodeImpl)member;
                continue;
            }
            ClusterNodeImpl other = matched;
            if (other.getOriginalJGAddress().equals(((ClusterNodeImpl)this.me).getOriginalJGAddress())) {
                other = (ClusterNodeImpl)member;
            }
            throw ClusteringImplMessages.MESSAGES.duplicateViewFound(other, this.me);
        }
    }

    static List<ClusterNode> translateAddresses(List<Address> addresses, ClusterNodeFactory factory) {
        if (addresses == null) {
            return null;
        }
        ArrayList<ClusterNode> result = new ArrayList<ClusterNode>(addresses.size());
        for (Address address : addresses) {
            result.add(factory.getClusterNode(address));
        }
        return result;
    }

    static List<ClusterNode> getDeadMembers(List<ClusterNode> oldMembers, List<ClusterNode> newMembers) {
        if (oldMembers == null) {
            oldMembers = new ArrayList<ClusterNode>();
        }
        if (newMembers == null) {
            newMembers = new ArrayList<ClusterNode>();
        }
        ArrayList<ClusterNode> dead = new ArrayList<ClusterNode>(oldMembers);
        dead.removeAll(newMembers);
        return dead;
    }

    static List<ClusterNode> getNewMembers(List<ClusterNode> oldMembers, List<ClusterNode> allMembers) {
        if (oldMembers == null) {
            oldMembers = new ArrayList<ClusterNode>();
        }
        if (allMembers == null) {
            allMembers = new ArrayList<ClusterNode>();
        }
        ArrayList<ClusterNode> newMembers = new ArrayList<ClusterNode>(allMembers);
        newMembers.removeAll(oldMembers);
        return newMembers;
    }

    void notifyListeners(List<GroupMembershipListener> listeners, long viewID, List<ClusterNode> allMembers, List<ClusterNode> deadMembers, List<ClusterNode> newMembers, List<List<ClusterNode>> originatingGroups) {
        ClusteringImplLogger.ROOT_LOGGER.debugf("Begin notifyListeners, viewID: %d", viewID);
        for (GroupMembershipListener listener : listeners) {
            try {
                if (originatingGroups != null) {
                    listener.membershipChangedDuringMerge(deadMembers, newMembers, allMembers, originatingGroups);
                    continue;
                }
                listener.membershipChanged(deadMembers, newMembers, allMembers);
            }
            catch (Throwable e) {
                ClusteringImplLogger.ROOT_LOGGER.membershipListenerCallbackFailure(e, listener);
            }
        }
        ClusteringImplLogger.ROOT_LOGGER.debugf("End notifyListeners, viewID: %d", viewID);
    }

    private class NoHandlerForRPCRspFilter
    implements RspFilter {
        private final RspFilter filter;

        NoHandlerForRPCRspFilter() {
            this.filter = null;
        }

        NoHandlerForRPCRspFilter(ResponseFilter filter) {
            this.filter = filter != null ? new RspFilterAdapter(filter, CoreGroupCommunicationService.this.nodeFactory) : null;
        }

        public boolean isAcceptable(Object response, Address sender) {
            return !(response instanceof NoHandlerForRPC) && (this.filter == null || this.filter.isAcceptable(response, sender));
        }

        public boolean needMoreResponses() {
            return this.filter == null || this.filter.needMoreResponses();
        }
    }

    private class AsynchronousLocalInvocation
    implements Runnable {
        private final String serviceName;
        private final String methodName;
        private final Object[] args;
        private final Class<?>[] types;

        AsynchronousLocalInvocation(String serviceName, String methodName, Object[] args, Class<?>[] types) {
            this.serviceName = serviceName;
            this.methodName = methodName;
            this.args = args;
            this.types = types;
        }

        @Override
        public void run() {
            try {
                CoreGroupCommunicationService.this.invokeDirectly(this.serviceName, this.methodName, this.args, this.types, null, null);
            }
            catch (Exception e) {
                ClusteringImplLogger.ROOT_LOGGER.caughtErrorInvokingAsyncMethod(e, this.methodName, this.serviceName);
            }
        }

        public void invoke() {
            if (CoreGroupCommunicationService.this.threadPool != null) {
                CoreGroupCommunicationService.this.threadPool.execute(this);
            } else {
                this.run();
            }
        }
    }

    private class StreamStateTransferTask
    extends StateTransferTask<StreamStateTransferResult, InputStream> {
        StreamStateTransferTask(String serviceName) {
            super(serviceName);
        }

        @Override
        protected StreamStateTransferResult createStateTransferResult(final boolean gotState, final InputStream state, final Exception exception) {
            return new StreamStateTransferResult(){

                public InputStream getState() {
                    return state;
                }

                public Exception getStateTransferException() {
                    return exception;
                }

                public boolean stateReceived() {
                    return gotState;
                }
            };
        }

        @Override
        protected void setState(InputStream is) throws IOException, ClassNotFoundException {
            this.state = is;
        }
    }

    private class SerializableStateTransferTask
    extends StateTransferTask<SerializableStateTransferResult, Serializable> {
        private final WeakReference<ClassLoader> classloader;

        SerializableStateTransferTask(String serviceName, ClassLoader cl) {
            super(serviceName);
            this.classloader = cl != null ? null : new WeakReference<ClassLoader>(cl);
        }

        @Override
        protected SerializableStateTransferResult createStateTransferResult(final boolean gotState, final Serializable state, final Exception exception) {
            return new SerializableStateTransferResult(){

                public Serializable getState() {
                    return state;
                }

                public Exception getStateTransferException() {
                    return exception;
                }

                public boolean stateReceived() {
                    return gotState;
                }
            };
        }

        @Override
        protected void setState(InputStream is) throws IOException, ClassNotFoundException {
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)new SimpleClassResolver(this.getStateTransferClassLoader()));
            Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(config);
            unmarshaller.start(Marshalling.createByteInput((InputStream)is));
            this.state = unmarshaller.readObject(Serializable.class);
            unmarshaller.close();
        }

        private ClassLoader getStateTransferClassLoader() {
            ClassLoader loader = this.classloader != null ? (ClassLoader)this.classloader.get() : null;
            return loader != null ? loader : this.getClass().getClassLoader();
        }
    }

    private abstract class StateTransferTask<T extends StateTransferResult, V>
    implements Callable<T> {
        private final String serviceName;
        V state;
        private boolean isStateSet;
        private Exception setStateException;
        T result;
        private final Object callMutex = new Object();

        StateTransferTask(String serviceName) {
            this.serviceName = serviceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object object = this.callMutex;
            synchronized (object) {
                if (this.result != null) {
                    return this.result;
                }
                try {
                    this.isStateSet = false;
                    long start = System.currentTimeMillis();
                    try {
                        CoreGroupCommunicationService.this.channel.getState(null, CoreGroupCommunicationService.this.getStateTransferTimeout());
                        StateTransferTask stateTransferTask = this;
                        synchronized (stateTransferTask) {
                            while (!this.isStateSet) {
                                if (this.setStateException != null) {
                                    throw this.setStateException;
                                }
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException iex) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        long stop = System.currentTimeMillis();
                        ClusteringImplLogger.ROOT_LOGGER.debugf("serviceState was retrieved successfully (in %d milliseconds)", stop - start);
                        return this.createStateTransferResult(true, this.state, null);
                    }
                    catch (StateTransferException e) {
                        if (!CoreGroupCommunicationService.this.isCoordinator()) {
                            throw ClusteringImplMessages.MESSAGES.initialTransferFailed("serviceState");
                        }
                        ClusteringImplLogger.ROOT_LOGGER.debugf("State could not be retrieved for service %s (we are the first member in group)", this.serviceName);
                        return this.createStateTransferResult(false, this.state, null);
                    }
                }
                catch (Exception e) {
                    return this.createStateTransferResult(false, null, e);
                }
            }
        }

        protected abstract T createStateTransferResult(boolean var1, V var2, Exception var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setState(byte[] state) {
            Object bais;
            try {
                if (state == null) {
                    ClusteringImplLogger.ROOT_LOGGER.debugf("transferred state for service %s is null (may be first member in cluster)", this.serviceName);
                } else {
                    bais = new ByteArrayInputStream(state);
                    this.setState((InputStream)bais);
                    ((ByteArrayInputStream)bais).close();
                }
                this.isStateSet = true;
            }
            catch (Throwable t) {
                this.recordSetStateFailure(t);
            }
            finally {
                bais = this;
                synchronized (bais) {
                    this.notifyAll();
                }
            }
        }

        protected abstract void setState(InputStream var1) throws IOException, ClassNotFoundException;

        private void recordSetStateFailure(Throwable t) {
            ClusteringImplLogger.ROOT_LOGGER.failedSettingServiceProperty(t, "serviceState", this.serviceName);
            this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }

    class MessageListenerImpl
    implements MessageListener {
        MessageListenerImpl() {
        }

        public void receive(Message msg) {
        }

        public void getState(OutputStream stream) {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(stream));
            try {
                for (Map.Entry<String, StateTransferProvider> entry : CoreGroupCommunicationService.this.stateProviders.entrySet()) {
                    String serviceName = entry.getKey();
                    out.writeUTF(serviceName);
                    StateTransferProvider provider = entry.getValue();
                    Marshaller marshaller = marshallerFactory.createMarshaller(new MarshallingConfiguration());
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                    marshaller.writeObject((Object)provider.getCurrentState());
                    marshaller.close();
                    byte[] bytes = output.toByteArray();
                    out.writeInt(bytes.length);
                    out.write(bytes);
                }
            }
            catch (IOException e) {
                ClusteringImplLogger.ROOT_LOGGER.methodFailure(e, "getState");
            }
        }

        public void setState(InputStream stream) {
            DataInputStream input = new DataInputStream(stream);
            try {
                while (input.available() > 0) {
                    String serviceName = input.readUTF();
                    StateTransferTask<?, ?> task = CoreGroupCommunicationService.this.stateTransferTasks.remove(serviceName);
                    int length = input.readInt();
                    if (task != null) {
                        byte[] bytes = new byte[length];
                        input.read(bytes);
                        task.setState(bytes);
                        continue;
                    }
                    input.skipBytes(length);
                }
            }
            catch (IOException e) {
                ClusteringImplLogger.ROOT_LOGGER.methodFailure(e, "setState");
            }
        }
    }

    class MembershipListenerImpl
    implements MembershipListener {
        MembershipListenerImpl() {
        }

        public void suspect(Address suspected_mbr) {
            CoreGroupCommunicationService.this.logHistory(ClusteringImplMessages.MESSAGES.nodeSuspected(suspected_mbr), new Object[0]);
            ClusteringImplLogger.ROOT_LOGGER.suspectedMember(suspected_mbr);
        }

        public void block() {
            CoreGroupCommunicationService.this.flushBlockGate.close();
            ClusteringImplLogger.ROOT_LOGGER.debugf("Block processed at %s", CoreGroupCommunicationService.this.me);
        }

        public void unblock() {
            CoreGroupCommunicationService.this.flushBlockGate.open();
            ClusteringImplLogger.ROOT_LOGGER.debugf("Unblock processed at %s", CoreGroupCommunicationService.this.me);
        }

        public void viewAccepted(View newView) {
            try {
                CoreGroupCommunicationService.this.processViewChange(newView);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                ClusteringImplLogger.ROOT_LOGGER.methodFailure(ex, "ViewAccepted");
            }
            catch (Exception ex) {
                ClusteringImplLogger.ROOT_LOGGER.methodFailure(ex, "ViewAccepted");
            }
        }
    }

    public static class NoHandlerForRPC
    implements Serializable {
        static final long serialVersionUID = -1263095408483622838L;
    }

    class ClusterNodeFactoryImpl
    implements ClusterNodeFactory {
        private final ConcurrentMap<Address, IpAddress> addressMap = new ConcurrentHashMap<Address, IpAddress>();

        ClusterNodeFactoryImpl() {
        }

        @Override
        public ClusterNode getClusterNode(Address a) {
            IpAddress result = (IpAddress)this.addressMap.get(a);
            if (result == null) {
                result = (IpAddress)CoreGroupCommunicationService.this.channel.down(new Event(87, (Object)a));
                if (result == null) {
                    throw ClusteringImplMessages.MESSAGES.addressNotRegistered(a);
                }
                this.addressMap.put(a, result);
            }
            InetSocketAddress socketAddress = new InetSocketAddress(result.getIpAddress(), result.getPort());
            String id = CoreGroupCommunicationService.this.channel.getName(a);
            if (id == null) {
                id = socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
            }
            return new ClusterNodeImpl(id, a, socketAddress);
        }
    }

    static class ThreadGate {
        private static final int OPEN = 1;
        private static final int CLOSED = -1;
        private final Sync sync = new Sync(-1);

        ThreadGate() {
        }

        public void open() {
            this.sync.releaseShared(1);
        }

        public void close() {
            this.sync.releaseShared(-1);
        }

        public boolean await(long timeout) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(0, TimeUnit.MILLISECONDS.toNanos(timeout));
        }

        private static class Sync
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 1L;

            Sync(int state) {
                this.setState(state);
            }

            @Override
            protected int tryAcquireShared(int ignored) {
                return this.getState();
            }

            @Override
            protected boolean tryReleaseShared(int state) {
                this.setState(state);
                return true;
            }
        }
    }

    class ViewChangeEventProcessor
    implements AsynchEventHandler.AsynchEventProcessor {
        ViewChangeEventProcessor() {
        }

        @Override
        public void processEvent(Object event) {
            GroupView vce = (GroupView)event;
            CoreGroupCommunicationService.this.notifyListeners(CoreGroupCommunicationService.this.asyncMembershipListeners, vce.viewId, vce.allMembers, vce.deadMembers, vce.newMembers, vce.originatingGroups);
        }
    }

    private class RpcHandler
    extends MuxRpcDispatcher {
        RpcHandler(short scopeId, Channel channel, MessageListener messageListener, MembershipListener membershipListener, RpcDispatcher.Marshaller reqMarshaller, RpcDispatcher.Marshaller rspMarshaller) {
            super(scopeId);
            this.setMessageListener(messageListener);
            this.setMembershipListener(membershipListener);
            this.setRequestMarshaller(reqMarshaller);
            this.setResponseMarshaller(rspMarshaller);
            this.setChannel(channel);
            channel.addChannelListener((ChannelListener)this);
            this.start();
        }

        public Object handle(Message req) {
            Object body = null;
            Object retval = null;
            Object handler = null;
            boolean trace = ClusteringImplLogger.ROOT_LOGGER.isTraceEnabled();
            String service = null;
            byte[] request_bytes = null;
            if (trace) {
                ClusteringImplLogger.ROOT_LOGGER.tracef("Partition %s received msg", CoreGroupCommunicationService.this.getGroupName());
            }
            if (req == null || req.getRawBuffer() == null) {
                ClusteringImplLogger.ROOT_LOGGER.nullPartitionMessage(CoreGroupCommunicationService.this.getGroupName());
                return null;
            }
            try {
                Object wrapper = CoreGroupCommunicationService.this.objectFromByteBufferInternal(req.getRawBuffer(), req.getOffset(), req.getLength());
                if (wrapper == null || !(wrapper instanceof Object[])) {
                    ClusteringImplLogger.ROOT_LOGGER.invalidPartitionMessageWrapper(CoreGroupCommunicationService.this.getGroupName());
                    return null;
                }
                Object[] temp = (Object[])wrapper;
                service = (String)temp[0];
                request_bytes = (byte[])temp[1];
                handler = CoreGroupCommunicationService.this.rpcHandlers.get(service);
                if (handler == null) {
                    if (trace) {
                        ClusteringImplLogger.ROOT_LOGGER.tracef("Partition %s no rpc handler registered under service %s", CoreGroupCommunicationService.this.getGroupName(), service);
                    }
                    return new NoHandlerForRPC();
                }
            }
            catch (Exception e) {
                ClusteringImplLogger.ROOT_LOGGER.partitionFailedDeserializing(e, CoreGroupCommunicationService.this.getGroupName(), req);
                return null;
            }
            try {
                body = CoreGroupCommunicationService.this.objectFromByteBufferInternal(request_bytes, 0, request_bytes.length);
            }
            catch (Exception e) {
                ClusteringImplLogger.ROOT_LOGGER.partitionFailedExtractingMessageBody(e, CoreGroupCommunicationService.this.getGroupName());
                return null;
            }
            if (body == null || !(body instanceof MethodCall)) {
                ClusteringImplLogger.ROOT_LOGGER.invalidPartitionMessage(CoreGroupCommunicationService.this.getGroupName());
                return null;
            }
            MethodCall method_call = (MethodCall)body;
            String methodName = method_call.getName();
            if (trace) {
                ClusteringImplLogger.ROOT_LOGGER.tracef("full methodName: %s", methodName);
            }
            int idx = methodName.lastIndexOf(46);
            String handlerName = methodName.substring(0, idx);
            String newMethodName = methodName.substring(idx + 1);
            if (trace) {
                ClusteringImplLogger.ROOT_LOGGER.tracef("handlerName: %s methodName: %s", handlerName, newMethodName);
                ClusteringImplLogger.ROOT_LOGGER.tracef("Handle: %s", methodName);
            }
            method_call.setName(newMethodName);
            try {
                retval = method_call.invoke(handler);
                if (trace) {
                    ClusteringImplLogger.ROOT_LOGGER.tracef("rpc call return value: %s", retval);
                }
            }
            catch (Throwable t) {
                if (trace) {
                    ClusteringImplLogger.ROOT_LOGGER.tracef(t, "Partition %s rpc call threw exception", CoreGroupCommunicationService.this.getGroupName());
                }
                retval = t;
            }
            return retval;
        }
    }

    class ResponseMarshallerImpl
    implements RpcDispatcher.Marshaller {
        ResponseMarshallerImpl() {
        }

        public Buffer objectToBuffer(Object obj) throws Exception {
            return new Buffer(CoreGroupCommunicationService.this.objectToByteBufferResponseInternal(obj));
        }

        public Object objectFromBuffer(byte[] buf, int offset, int length) throws Exception {
            return CoreGroupCommunicationService.this.objectFromByteBufferResponseInternal(buf, offset, length);
        }
    }

    class RequestMarshallerImpl
    implements RpcDispatcher.Marshaller {
        RequestMarshallerImpl() {
        }

        public Buffer objectToBuffer(Object obj) throws Exception {
            if (obj instanceof MethodCall) {
                String name = ((MethodCall)obj).getName();
                int idx = name.lastIndexOf(46);
                String serviceName = name.substring(0, idx);
                return new Buffer(CoreGroupCommunicationService.this.objectToByteBufferInternal(new Object[]{serviceName, CoreGroupCommunicationService.this.objectToByteBufferInternal(obj)}));
            }
            return new Buffer(CoreGroupCommunicationService.this.objectToByteBufferInternal(obj));
        }

        public Object objectFromBuffer(byte[] buf, int offset, int length) throws Exception {
            return CoreGroupCommunicationService.this.objectFromByteBufferInternal(buf, offset, length);
        }
    }

    protected static class GroupView {
        protected final long viewId;
        protected final List<ClusterNode> deadMembers;
        protected final List<ClusterNode> newMembers;
        protected final List<ClusterNode> allMembers;
        protected final List<List<ClusterNode>> originatingGroups;
        protected final List<Address> jgmembers;
        protected final Address coordinator;

        GroupView() {
            this.viewId = -1L;
            this.deadMembers = new ArrayList<ClusterNode>();
            this.allMembers = new ArrayList<ClusterNode>();
            this.newMembers = this.allMembers;
            this.jgmembers = new ArrayList<Address>();
            this.coordinator = null;
            this.originatingGroups = null;
        }

        GroupView(View newView, GroupView previousView, ClusterNodeFactory factory) {
            this.viewId = newView.getVid().getId();
            this.jgmembers = new ArrayList<Address>(newView.getMembers());
            this.coordinator = this.jgmembers.size() == 0 ? null : this.jgmembers.get(0);
            this.allMembers = CoreGroupCommunicationService.translateAddresses(newView.getMembers(), factory);
            this.deadMembers = CoreGroupCommunicationService.getDeadMembers(previousView.allMembers, this.allMembers);
            this.newMembers = CoreGroupCommunicationService.getNewMembers(previousView.allMembers, this.allMembers);
            if (newView instanceof MergeView) {
                MergeView mergeView = (MergeView)newView;
                List subgroups = mergeView.getSubgroups();
                this.originatingGroups = new ArrayList<List<ClusterNode>>(subgroups.size());
                for (View view : subgroups) {
                    this.originatingGroups.add(CoreGroupCommunicationService.translateAddresses(view.getMembers(), factory));
                }
            } else {
                this.originatingGroups = null;
            }
        }
    }
}

