/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.impl;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Class<?> loadClass(final Class<?> theClass, final String fullQualifiedName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    ClassLoader classLoader = theClass.getClassLoader();
                    Class<?> clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
                    if (clazz == null) {
                        classLoader = Thread.currentThread().getContextClassLoader();
                        clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
                    }
                    return clazz;
                }
            });
        }
        ClassLoader classLoader = theClass.getClassLoader();
        Class<?> clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
        if (clazz == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            clazz = SecurityActions.loadClass(classLoader, fullQualifiedName);
        }
        return clazz;
    }

    static Class<?> loadClass(final ClassLoader classLoader, final String fullQualifiedName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return classLoader.loadClass(fullQualifiedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
        }
        try {
            return classLoader.loadClass(fullQualifiedName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key, defaultValue);
                }
            });
        }
        return System.getProperty(key, defaultValue);
    }

    static URL loadResource(final Class<?> clazz, final String resourceName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    URL url = null;
                    ClassLoader clazzLoader = clazz.getClassLoader();
                    url = clazzLoader.getResource(resourceName);
                    if (url == null) {
                        clazzLoader = Thread.currentThread().getContextClassLoader();
                        url = clazzLoader.getResource(resourceName);
                    }
                    return url;
                }
            });
        }
        URL url = null;
        ClassLoader clazzLoader = clazz.getClassLoader();
        url = clazzLoader.getResource(resourceName);
        if (url == null) {
            clazzLoader = Thread.currentThread().getContextClassLoader();
            url = clazzLoader.getResource(resourceName);
        }
        return url;
    }

    static String getProperty(final String key, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key, defaultValue);
                }
            });
        }
        return System.getProperty(key, defaultValue);
    }
}

