/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.interceptor;

import java.util.HashSet;
import java.util.Set;
import org.jboss.osgi.deployment.DeploymentMessages;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.spi.AttachmentKey;

public class InterceptorWrapper
implements LifecycleInterceptor {
    private LifecycleInterceptor delegate;

    public InterceptorWrapper(LifecycleInterceptor delegate) {
        if (delegate == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("delegate");
        }
        this.delegate = delegate;
    }

    @Override
    public Set<AttachmentKey<?>> getInput() {
        return this.delegate.getInput();
    }

    @Override
    public Set<AttachmentKey<?>> getOutput() {
        return this.delegate.getOutput();
    }

    @Override
    public int getRelativeOrder() {
        return this.delegate.getRelativeOrder();
    }

    @Override
    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        this.delegate.invoke(state, context);
    }

    public String toLongString() {
        String classToken = this.delegate.getClass().getSimpleName();
        HashSet<String> input = null;
        if (this.getInput() != null) {
            input = new HashSet<String>();
            for (AttachmentKey<?> aux : this.getInput()) {
                input.add(aux.getType().getSimpleName());
            }
        }
        HashSet<String> output = null;
        if (this.getOutput() != null) {
            output = new HashSet<String>();
            for (AttachmentKey<?> aux : this.getOutput()) {
                output.add(aux.getType().getSimpleName());
            }
        }
        return "[" + classToken + ",order=" + this.getRelativeOrder() + ",input=" + input + ",output=" + output + "]";
    }

    public String toString() {
        String className = this.delegate.getClass().getName();
        return "[" + className + ",order=" + this.getRelativeOrder() + "]";
    }
}

