/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bean.interceptor.CdiInterceptorFactory;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.messages.BeanMessage;

public class InterceptorBindingsAdapter
implements InterceptorBindings {
    private InterceptionModel<ClassMetadata<?>> interceptionModel;

    public InterceptorBindingsAdapter(InterceptionModel<ClassMetadata<?>> interceptionModel) {
        if (interceptionModel == null) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_MODEL_NULL, new Object[0]);
        }
        this.interceptionModel = interceptionModel;
    }

    public Collection<Interceptor<?>> getAllInterceptors() {
        Set<InterceptorMetadata<?>> interceptorMetadataSet = this.interceptionModel.getAllInterceptors();
        return this.extractCdiInterceptors(interceptorMetadataSet);
    }

    public List<Interceptor<?>> getMethodInterceptors(javax.enterprise.inject.spi.InterceptionType interceptionType, Method method) {
        if (interceptionType == null) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_NULL, new Object[0]);
        }
        if (method == null) {
            throw new IllegalArgumentException(BeanMessage.METHOD_NULL, new Object[0]);
        }
        InterceptionType internalInterceptionType = InterceptionType.valueOf(interceptionType.name());
        if (internalInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_LIFECYCLE, interceptionType.name());
        }
        return this.extractCdiInterceptors(this.interceptionModel.getInterceptors(internalInterceptionType, method));
    }

    public List<Interceptor<?>> getLifecycleInterceptors(javax.enterprise.inject.spi.InterceptionType interceptionType) {
        if (interceptionType == null) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_NULL, new Object[0]);
        }
        InterceptionType internalInterceptionType = InterceptionType.valueOf(interceptionType.name());
        if (!internalInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException(BeanMessage.INTERCEPTION_TYPE_NOT_LIFECYCLE, interceptionType.name());
        }
        return this.extractCdiInterceptors(this.interceptionModel.getInterceptors(internalInterceptionType, null));
    }

    private List<Interceptor<?>> extractCdiInterceptors(Collection<? extends InterceptorMetadata<?>> interceptorMetadatas) {
        ArrayList interceptors = new ArrayList();
        for (InterceptorMetadata<?> interceptorMetadata : interceptorMetadatas) {
            InterceptorFactory<?> interceptorFactory = interceptorMetadata.getInterceptorFactory();
            if (!(interceptorFactory instanceof CdiInterceptorFactory)) continue;
            CdiInterceptorFactory cdiInterceptorFactory = (CdiInterceptorFactory)interceptorFactory;
            interceptors.add(cdiInterceptorFactory.getInterceptor());
        }
        return interceptors;
    }
}

