/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.bytecode.StaticMethodInformation;

public class DecoratorProxyFactory<T>
extends ProxyFactory<T> {
    public static final String PROXY_SUFFIX = "DecoratorProxy";
    private static final String INIT_MH_METHOD_NAME = "_initMH";
    private final WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private final Field delegateField;

    public DecoratorProxyFactory(Class<T> proxyType, WeldInjectionPoint<?, ?> delegateInjectionPoint, Bean<?> bean) {
        super(proxyType, Collections.emptySet(), bean);
        this.delegateInjectionPoint = delegateInjectionPoint;
        this.delegateField = delegateInjectionPoint instanceof FieldInjectionPoint ? (Field)((FieldInjectionPoint)delegateInjectionPoint).getMember() : null;
    }

    private void addHandlerInitializerMethod(ClassFile proxyClassType) throws Exception {
        ClassMethod classMethod = proxyClassType.addMethod(2, INIT_MH_METHOD_NAME, "V", new String[]{"Ljava/lang/Object;"});
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        StaticMethodInformation methodInfo = new StaticMethodInformation(INIT_MH_METHOD_NAME, new Class[]{Object.class}, Void.TYPE, classMethod.getClassFile().getName());
        DecoratorProxyFactory.invokeMethodHandler(classMethod, methodInfo, false, DEFAULT_METHOD_RESOLVER);
        b.checkcast(MethodHandler.class);
        b.putfield(classMethod.getClassFile().getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.returnInstruction();
        log.trace("Created MH initializer body for decorator proxy: {}", this.getBeanType());
    }

    @Override
    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
        interfaces.add(DecoratorProxy.class);
    }

    @Override
    protected void addMethodsFromClass(ClassFile proxyClassType) {
        ParameterInjectionPoint parameterIP;
        Method initializerMethod = null;
        int delegateParameterPosition = -1;
        if (this.delegateInjectionPoint instanceof ParameterInjectionPoint && (parameterIP = (ParameterInjectionPoint)this.delegateInjectionPoint).getMember() instanceof Method) {
            initializerMethod = (Method)parameterIP.getMember();
            delegateParameterPosition = parameterIP.getAnnotated().getPosition();
        }
        try {
            if (delegateParameterPosition >= 0) {
                this.addHandlerInitializerMethod(proxyClassType);
            }
            Class<?> cls = this.getBeanType();
            LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
            this.decoratorMethods(cls, methods);
            for (Method method : methods) {
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                if (method.getDeclaringClass().getName().equals("java.lang.Object") && !method.getName().equals("toString")) continue;
                if (delegateParameterPosition >= 0 && initializerMethod.equals(method)) {
                    this.createDelegateInitializerCode(proxyClassType.addMethod(method), methodInfo, delegateParameterPosition);
                }
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                this.createAbstractMethodCode(proxyClassType.addMethod(method), methodInfo);
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void decoratorMethods(Class<?> cls, Set<Method> all) {
        if (cls == null) {
            return;
        }
        all.addAll(Arrays.asList((Object[])AccessController.doPrivileged(new GetDeclaredMethodsAction(cls))));
        this.decoratorMethods(cls.getSuperclass(), all);
        for (Class<?> ifc : cls.getInterfaces()) {
            Method[] methods;
            for (Method m : methods = ifc.getMethods()) {
                boolean isEqual = false;
                for (Method a : all) {
                    if (!DecoratorProxyFactory.isEqual(m, a)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                all.add(m);
            }
        }
    }

    private static boolean isEqual(Method m, Method a) {
        if (m.getName().equals(a.getName()) && m.getParameterTypes().length == a.getParameterTypes().length && m.getReturnType().isAssignableFrom(a.getReturnType())) {
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i].isAssignableFrom(a.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void createAbstractMethodCode(ClassMethod classMethod, MethodInformation method) {
        if (this.delegateField != null && !Modifier.isPrivate(this.delegateField.getModifiers())) {
            CodeAttribute b = classMethod.getCodeAttribute();
            b.aload(0);
            b.getfield(classMethod.getClassFile().getName(), this.delegateField.getName(), DescriptorUtils.classToStringRepresentation(this.delegateField.getType()));
            b.loadMethodParameters();
            b.invokeinterface(this.delegateField.getType().getName(), method.getName(), method.getDescriptor());
            b.returnInstruction();
        } else if (!Modifier.isPrivate(method.getMethod().getModifiers())) {
            DecoratorProxyFactory.invokeMethodHandler(classMethod, method, true, TargetInstanceBytecodeMethodResolver.INSTANCE);
        } else {
            this.createInterceptorBody(classMethod, method);
        }
    }

    private void createDelegateInitializerCode(ClassMethod classMethod, MethodInformation intializerMethodInfo, int delegateParameterPosition) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        int localVariables = 1;
        int actualDelegateParamterPosition = 0;
        for (int i = 0; i < intializerMethodInfo.getMethod().getParameterTypes().length; ++i) {
            if (i == delegateParameterPosition) {
                actualDelegateParamterPosition = localVariables;
            }
            Class<?> type = intializerMethodInfo.getMethod().getParameterTypes()[i];
            BytecodeUtils.addLoadInstruction(b, DescriptorUtils.classToStringRepresentation(type), localVariables);
            if (type == Long.TYPE || type == Double.TYPE) {
                localVariables += 2;
                continue;
            }
            ++localVariables;
        }
        b.invokespecial(classMethod.getClassFile().getSuperclass(), intializerMethodInfo.getName(), intializerMethodInfo.getDescriptor());
        b.aload(0);
        b.aload(actualDelegateParamterPosition);
        b.invokevirtual(classMethod.getClassFile().getName(), INIT_MH_METHOD_NAME, "(Ljava/lang/Object;)V");
        b.returnInstruction();
    }

    protected static class TargetInstanceBytecodeMethodResolver
    implements BytecodeMethodResolver {
        private static final String JAVA_LANG_CLASS_CLASS_NAME = "java.lang.Class";
        static final TargetInstanceBytecodeMethodResolver INSTANCE = new TargetInstanceBytecodeMethodResolver();

        protected TargetInstanceBytecodeMethodResolver() {
        }

        @Override
        public void getDeclaredMethod(ClassMethod classMethod, String declaringClass, String methodName, String[] parameterTypes) {
            StaticMethodInformation methodInfo = new StaticMethodInformation("getTargetClass", new String[0], "Ljava/lang/Class;", TargetInstanceProxy.class.getName());
            ProxyFactory.invokeMethodHandler(classMethod, methodInfo, false, ProxyFactory.DEFAULT_METHOD_RESOLVER);
            CodeAttribute code = classMethod.getCodeAttribute();
            code.checkcast("java/lang/Class");
            code.ldc(methodName);
            code.iconst(parameterTypes.length);
            code.anewarray(JAVA_LANG_CLASS_CLASS_NAME);
            for (int i = 0; i < parameterTypes.length; ++i) {
                code.dup();
                code.iconst(i);
                String type = parameterTypes[i];
                BytecodeUtils.pushClassType(code, type);
                code.aastore();
            }
            code.invokevirtual(JAVA_LANG_CLASS_CLASS_NAME, "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        }
    }
}

