/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.injection.attributes.FieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ForwardingInjectionPointAttributes;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="The bean cache is loaded lazily.")
public class FieldInjectionPoint<T, X>
extends ForwardingInjectionPointAttributes<T, Field>
implements WeldInjectionPoint<T, Field>,
Serializable {
    private static final long serialVersionUID = 6645272914499045953L;
    private final boolean cacheable;
    private transient Bean<?> cachedBean;
    private final transient Field accessibleField;
    private final FieldInjectionPointAttributes<T, X> attributes;

    public static <T, X> FieldInjectionPoint<T, X> silent(FieldInjectionPointAttributes<T, X> attributes) {
        return new FieldInjectionPoint<T, X>(attributes);
    }

    protected FieldInjectionPoint(FieldInjectionPointAttributes<T, X> attributes) {
        this.attributes = attributes;
        this.cacheable = FieldInjectionPoint.isCacheableInjectionPoint(attributes);
        this.accessibleField = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Field>(attributes.getMember()));
    }

    protected static boolean isCacheableInjectionPoint(WeldInjectionPointAttributes<?, ?> attributes) {
        if (attributes.isDelegate()) {
            return false;
        }
        Class rawType = Reflections.getRawType(attributes.getType());
        return !InjectionPoint.class.isAssignableFrom(rawType) && !Instance.class.isAssignableFrom(rawType);
    }

    public void inject(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            Object objectToInject;
            Object instanceToInject = declaringInstance;
            if (!(instanceToInject instanceof DecoratorProxy) && declaringInstance instanceof TargetInstanceProxy) {
                instanceToInject = ((TargetInstanceProxy)Reflections.cast(declaringInstance)).getTargetInstance();
            }
            if (!this.cacheable) {
                objectToInject = manager.getInjectableReference(this, creationalContext);
            } else {
                if (this.cachedBean == null) {
                    this.cachedBean = manager.resolve(manager.getBeans(this));
                }
                objectToInject = manager.getReference(this, this.cachedBean, creationalContext);
            }
            this.accessibleField.set(instanceToInject, objectToInject);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            Object instanceToInject = declaringInstance;
            if (!(instanceToInject instanceof DecoratorProxy) && instanceToInject instanceof TargetInstanceProxy) {
                instanceToInject = ((TargetInstanceProxy)Reflections.cast(declaringInstance)).getTargetInstance();
            }
            this.accessibleField.set(instanceToInject, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    protected FieldInjectionPointAttributes<T, X> delegate() {
        return this.attributes;
    }

    public AnnotatedField<X> getAnnotated() {
        return this.attributes.getAnnotated();
    }

    private Object readResolve() throws ObjectStreamException {
        return new FieldInjectionPoint<T, X>(this.attributes);
    }
}

