/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.builder.InterceptionModelImpl;
import org.jboss.weld.interceptor.builder.MethodReference;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public class InterceptionModelBuilder<T> {
    private boolean isModelBuilt = false;
    private final T interceptedEntity;
    private boolean hasTargetClassInterceptors;
    private boolean hasExternalNonConstructorInterceptors;
    private final Set<MethodReference> methodsIgnoringGlobalInterceptors = new HashSet<MethodReference>();
    private final Set<InterceptorMetadata<?>> allInterceptors = new LinkedHashSet();
    private final Map<InterceptionType, List<InterceptorMetadata<?>>> globalInterceptors = new HashMap();
    private final Map<InterceptionType, Map<MethodReference, List<InterceptorMetadata<?>>>> methodBoundInterceptors = new HashMap();

    private InterceptionModelBuilder(T interceptedEntity) {
        this.interceptedEntity = interceptedEntity;
    }

    public static <T> InterceptionModelBuilder<T> newBuilderFor(T entity) {
        return new InterceptionModelBuilder<T>(entity);
    }

    public InterceptionModel<T> build() {
        this.checkModelNotBuilt();
        this.isModelBuilt = true;
        return new InterceptionModelImpl(this);
    }

    public MethodInterceptorDescriptor interceptAll() {
        this.checkModelNotBuilt();
        return new MethodInterceptorDescriptor(null, InterceptionType.values());
    }

    public MethodInterceptorDescriptor interceptAroundInvoke(Method method) {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, method);
    }

    public MethodInterceptorDescriptor interceptAroundTimeout(Method method) {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, method);
    }

    public MethodInterceptorDescriptor intercept(javax.enterprise.inject.spi.InterceptionType interceptionType, Method method) {
        this.checkModelNotBuilt();
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        if (weldInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Illegal interception type: " + interceptionType);
        }
        return new MethodInterceptorDescriptor(method, weldInterceptionType);
    }

    public MethodInterceptorDescriptor interceptPostConstruct() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT);
    }

    public MethodInterceptorDescriptor interceptPreDestroy() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY);
    }

    public MethodInterceptorDescriptor interceptPrePassivate() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE);
    }

    public MethodInterceptorDescriptor interceptPostActivate() {
        return this.intercept(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE);
    }

    public MethodInterceptorDescriptor intercept(javax.enterprise.inject.spi.InterceptionType interceptionType) {
        this.checkModelNotBuilt();
        InterceptionType weldInterceptionType = InterceptionType.valueOf(interceptionType);
        return new MethodInterceptorDescriptor(null, weldInterceptionType);
    }

    public void setHasTargetClassInterceptors(boolean hasTargetClassInterceptors) {
        this.checkModelNotBuilt();
        this.hasTargetClassInterceptors = hasTargetClassInterceptors;
    }

    public void addMethodIgnoringGlobalInterceptors(Method method) {
        this.checkModelNotBuilt();
        this.methodsIgnoringGlobalInterceptors.add(MethodReference.of(method, true));
    }

    private void appendInterceptors(InterceptionType interceptionType, Method method, InterceptorMetadata<?> ... interceptors) {
        this.checkModelNotBuilt();
        if (interceptionType != InterceptionType.AROUND_CONSTRUCT) {
            this.hasExternalNonConstructorInterceptors = true;
        }
        if (null == method) {
            List<InterceptorMetadata<?>> interceptorsList = this.globalInterceptors.get((Object)interceptionType);
            if (interceptorsList == null) {
                interceptorsList = new ArrayList();
                this.globalInterceptors.put(interceptionType, interceptorsList);
            }
            interceptorsList.addAll(Arrays.asList(interceptors));
        } else {
            List<InterceptorMetadata<?>> interceptorsList;
            MethodReference methodHolder = MethodReference.of(method, true);
            if (null == this.methodBoundInterceptors.get((Object)interceptionType)) {
                this.methodBoundInterceptors.put(interceptionType, new HashMap());
            }
            if ((interceptorsList = this.methodBoundInterceptors.get((Object)interceptionType).get(methodHolder)) == null) {
                interceptorsList = new ArrayList();
                this.methodBoundInterceptors.get((Object)interceptionType).put(methodHolder, interceptorsList);
            }
            interceptorsList.addAll(Arrays.asList(interceptors));
        }
        this.allInterceptors.addAll(Arrays.asList(interceptors));
    }

    T getInterceptedEntity() {
        return this.interceptedEntity;
    }

    boolean isHasTargetClassInterceptors() {
        return this.hasTargetClassInterceptors;
    }

    boolean isHasExternalNonConstructorInterceptors() {
        return this.hasExternalNonConstructorInterceptors;
    }

    Set<MethodReference> getMethodsIgnoringGlobalInterceptors() {
        return this.methodsIgnoringGlobalInterceptors;
    }

    Set<InterceptorMetadata<?>> getAllInterceptors() {
        return this.allInterceptors;
    }

    Map<InterceptionType, List<InterceptorMetadata<?>>> getGlobalInterceptors() {
        return this.globalInterceptors;
    }

    Map<InterceptionType, Map<MethodReference, List<InterceptorMetadata<?>>>> getMethodBoundInterceptors() {
        return this.methodBoundInterceptors;
    }

    private void checkModelNotBuilt() {
        if (this.isModelBuilt) {
            throw new IllegalStateException("InterceptionModelBuilder cannot be reused");
        }
    }

    public final class MethodInterceptorDescriptor {
        private final Method method;
        private final InterceptionType[] interceptionTypes;

        public MethodInterceptorDescriptor(Method m, InterceptionType ... interceptionType) {
            this.method = m;
            this.interceptionTypes = interceptionType;
        }

        public void with(InterceptorMetadata<?> ... interceptors) {
            for (InterceptionType interceptionType : this.interceptionTypes) {
                InterceptionModelBuilder.this.appendInterceptors(interceptionType, this.method, interceptors);
            }
        }
    }
}

