/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class NameBasedResolver {
    private LoadingCache<String, Set<Bean<?>>> resolvedNames;

    public NameBasedResolver(BeanManagerImpl manager, Iterable<? extends Bean<?>> allBeans) {
        this.resolvedNames = CacheBuilder.newBuilder().build((CacheLoader)new NameToBeanSet(manager, allBeans));
    }

    public void clear() {
        this.resolvedNames.invalidateAll();
    }

    public Set<Bean<?>> resolve(String name) {
        return LoadingCacheUtils.getCacheValue(this.resolvedNames, name);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }

    private static class NameToBeanSet
    extends CacheLoader<String, Set<Bean<?>>> {
        private final BeanManagerImpl beanManager;
        private final Iterable<? extends Bean<?>> allBeans;
        private final SpecializationAndEnablementRegistry registry;

        private NameToBeanSet(BeanManagerImpl beanManager, Iterable<? extends Bean<?>> allBeans) {
            this.beanManager = beanManager;
            this.allBeans = allBeans;
            this.registry = (SpecializationAndEnablementRegistry)beanManager.getServices().get(SpecializationAndEnablementRegistry.class);
        }

        public Set<Bean<?>> load(String from) {
            HashSet matchedBeans = new HashSet();
            for (Bean<?> bean : this.allBeans) {
                if ((bean.getName() != null || from != null) && (bean.getName() == null || !bean.getName().equals(from))) continue;
                matchedBeans.add(bean);
            }
            return ImmutableSet.copyOf(Beans.removeDisabledAndSpecializedBeans(matchedBeans, this.beanManager, this.registry));
        }
    }
}

