/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractSerializableHolder;

public class MethodHolder
extends AbstractSerializableHolder<Method>
implements PrivilegedAction<Method> {
    private static final long serialVersionUID = -3033089710155551280L;
    private final Class<?> declaringClass;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodHolder(Method method) {
        super(method);
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    @Override
    protected Method initialize() {
        return AccessController.doPrivileged(this);
    }

    @Override
    public Method run() {
        try {
            return this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes);
        }
        catch (Exception e) {
            throw new WeldException(ReflectionMessage.UNABLE_TO_GET_METHOD_ON_DESERIALIZATION, (Throwable)e, this.declaringClass, this.parameterTypes);
        }
    }
}

