/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.ConstantContextSelector;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.DaemonThreadFactory;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientContextInitializer;
import org.jboss.ejb.client.EJBClientContextListener;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientPropertiesLoader;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.IdentityEJBClientContextSelector;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.RandomDeploymentNodeSelector;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;

public final class EJBClientContext
extends Attachable
implements Closeable {
    private static final Logger logger = Logger.getLogger(EJBClientContext.class);
    private static final RuntimePermission SET_SELECTOR_PERMISSION = new RuntimePermission("setEJBClientContextSelector");
    private static final RuntimePermission ADD_INTERCEPTOR_PERMISSION = new RuntimePermission("registerInterceptor");
    private static final RuntimePermission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createEJBClientContext");
    private static final AtomicReferenceFieldUpdater<EJBClientContext, EJBClientInterceptor.Registration[]> registrationsUpdater = AtomicReferenceFieldUpdater.newUpdater(EJBClientContext.class, EJBClientInterceptor.Registration[].class, "registrations");
    private static final EJBClientInterceptor.Registration[] NO_INTERCEPTORS = new EJBClientInterceptor.Registration[0];
    private static volatile ContextSelector<EJBClientContext> SELECTOR;
    private static volatile boolean SELECTOR_LOCKED;
    private final Map<EJBReceiver, ReceiverAssociation> ejbReceiverAssociations = new IdentityHashMap<EJBReceiver, ReceiverAssociation>();
    private final Map<EJBReceiverContext, EJBReceiverContextCloseHandler> receiverContextCloseHandlers = Collections.synchronizedMap(new IdentityHashMap());
    private volatile EJBClientInterceptor.Registration[] registrations = NO_INTERCEPTORS;
    private Set<EJBClientInterceptor> clientInterceptorsInClasspath;
    private final Map<String, ClusterContext> clusterContexts = Collections.synchronizedMap(new HashMap());
    private final EJBClientConfiguration ejbClientConfiguration;
    private final ClusterFormationNotifier clusterFormationNotifier = new ClusterFormationNotifier();
    private final DeploymentNodeSelector deploymentNodeSelector;
    private final ExecutorService ejbClientContextTasksExecutorService = Executors.newCachedThreadPool(new DaemonThreadFactory("ejb-client-context-tasks"));
    private final List<ReconnectHandler> reconnectHandlers = new ArrayList<ReconnectHandler>();
    private final Collection<EJBClientContextListener> ejbClientContextListeners = Collections.synchronizedSet(new HashSet());
    private volatile boolean closed;

    private EJBClientContext(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
        this.deploymentNodeSelector = ejbClientConfiguration != null && ejbClientConfiguration.getDeploymentNodeSelector() != null ? ejbClientConfiguration.getDeploymentNodeSelector() : new RandomDeploymentNodeSelector();
    }

    private void init(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = EJBClientContext.class.getClassLoader();
        }
        for (EJBClientContextInitializer contextInitializer : SecurityActions.loadService(EJBClientContextInitializer.class, classLoader)) {
            try {
                contextInitializer.initialize(this);
            }
            catch (Throwable ignored) {
                logger.debug((Object)("EJB client context initializer " + contextInitializer + " failed to initialize context " + this), ignored);
            }
        }
        try {
            for (EJBClientInterceptor interceptor : SecurityActions.loadService(EJBClientInterceptor.class, classLoader)) {
                if (this.clientInterceptorsInClasspath == null) {
                    this.clientInterceptorsInClasspath = new LinkedHashSet<EJBClientInterceptor>();
                }
                this.clientInterceptorsInClasspath.add(interceptor);
            }
        }
        catch (Throwable t) {
            logger.debug((Object)("Failed to load EJB client interceptor(s) from the classpath via classloader " + classLoader + " for EJB client context " + this), t);
        }
    }

    public static EJBClientContext create() {
        return EJBClientContext.create(null, EJBClientContext.class.getClassLoader());
    }

    public static EJBClientContext create(ClassLoader classLoader) {
        return EJBClientContext.create(null, classLoader);
    }

    public static EJBClientContext create(EJBClientConfiguration ejbClientConfiguration) {
        return EJBClientContext.create(ejbClientConfiguration, EJBClientContext.class.getClassLoader());
    }

    public static EJBClientContext create(EJBClientConfiguration ejbClientConfiguration, ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        EJBClientContext context = new EJBClientContext(ejbClientConfiguration);
        context.init(classLoader);
        return context;
    }

    public static ContextSelector<EJBClientContext> setSelector(ContextSelector<EJBClientContext> newSelector) {
        if (newSelector == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB client context selector");
        }
        if (SELECTOR_LOCKED) {
            throw Logs.MAIN.ejbClientContextSelectorMayNotBeChanged();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        ContextSelector<EJBClientContext> oldSelector = SELECTOR;
        SELECTOR = newSelector;
        return oldSelector;
    }

    public static ContextSelector<EJBClientContext> setConstantContext(EJBClientContext context) {
        return EJBClientContext.setSelector(new ConstantContextSelector<EJBClientContext>(context));
    }

    public static ContextSelector<EJBClientContext> getSelector() {
        return SELECTOR;
    }

    public static void lockSelector() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        SELECTOR_LOCKED = true;
    }

    public static boolean isSelectorLocked() {
        return SELECTOR_LOCKED;
    }

    public static EJBClientContext getCurrent() {
        return SELECTOR.getCurrent();
    }

    public static EJBClientContext requireCurrent() throws IllegalStateException {
        EJBClientContext clientContext = EJBClientContext.getCurrent();
        if (clientContext == null) {
            throw Logs.MAIN.noEJBClientContextAvailable();
        }
        return clientContext;
    }

    public static EJBClientContext require(EJBClientContextIdentifier ejbClientContextIdentifier) throws IllegalStateException {
        ContextSelector<EJBClientContext> currentSelector = SELECTOR;
        if (!(currentSelector instanceof IdentityEJBClientContextSelector)) {
            throw new IllegalStateException("No EJB client context available for context identifier: " + ejbClientContextIdentifier + ",since the " + " current EJB client context selector " + currentSelector + " is not capable of returning identity based EJB client contexts");
        }
        EJBClientContext identityEjbClientContext = ((IdentityEJBClientContextSelector)currentSelector).getContext(ejbClientContextIdentifier);
        if (identityEjbClientContext == null) {
            throw new IllegalStateException("No EJB client context available for context identifier: " + ejbClientContextIdentifier);
        }
        return identityEjbClientContext;
    }

    public boolean registerEJBReceiver(EJBReceiver receiver) {
        return this.registerEJBReceiver(receiver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerEJBReceiver(final EJBReceiver receiver, EJBReceiverContextCloseHandler receiverContextCloseHandler) {
        EJBReceiverContext ejbReceiverContext;
        this.assertNotClosed();
        if (receiver == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB receiver");
        }
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            if (this.ejbReceiverAssociations.containsKey(receiver)) {
                logger.debug((Object)("Skipping registration of receiver " + receiver + " since the same instance already exists in this client context " + this));
                return false;
            }
            EJBReceiver existingReceiverForNode = this.getNodeEJBReceiver(receiver.getNodeName(), false);
            if (existingReceiverForNode != null) {
                logger.debug((Object)("Skipping registration of receiver " + receiver + " since an EJB receiver already exists for " + "node name " + receiver.getNodeName() + " in client context " + this));
                return false;
            }
            ejbReceiverContext = new EJBReceiverContext(receiver, this);
            ReceiverAssociation association = new ReceiverAssociation(ejbReceiverContext);
            this.ejbReceiverAssociations.put(receiver, association);
            if (receiverContextCloseHandler != null) {
                this.receiverContextCloseHandlers.put(ejbReceiverContext, receiverContextCloseHandler);
            }
        }
        receiver.associate(ejbReceiverContext);
        map = this.ejbReceiverAssociations;
        synchronized (map) {
            boolean registered;
            association.associated = true;
            boolean bl = registered = this.ejbReceiverAssociations.get(receiver) != null;
            if (registered) {
                ArrayList<EJBClientContextListener> listeners = new ArrayList<EJBClientContextListener>(this.ejbClientContextListeners);
                for (final EJBClientContextListener listener : listeners) {
                    this.ejbClientContextTasksExecutorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                listener.receiverRegistered(ejbReceiverContext);
                            }
                            catch (Throwable t) {
                                logger.debug((Object)("Exception trying to invoke EJBClientContextListener " + listener + " for EJB client context " + EJBClientContext.this + " on registertation of EJBReceiver " + receiver), t);
                            }
                        }
                    });
                }
            }
            return registered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEJBReceiver(final EJBReceiver receiver) {
        if (receiver == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB receiver");
        }
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            ReceiverAssociation association = this.ejbReceiverAssociations.remove(receiver);
            if (association != null) {
                final EJBReceiverContext receiverContext = association.context;
                EJBReceiverContextCloseHandler receiverContextCloseHandler = this.receiverContextCloseHandlers.remove(receiverContext);
                if (receiverContextCloseHandler != null) {
                    receiverContextCloseHandler.receiverContextClosed(receiverContext);
                }
                ArrayList<EJBClientContextListener> listeners = new ArrayList<EJBClientContextListener>(this.ejbClientContextListeners);
                for (final EJBClientContextListener listener : listeners) {
                    this.ejbClientContextTasksExecutorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                listener.receiverUnRegistered(receiverContext);
                            }
                            catch (Throwable t) {
                                logger.debug((Object)("Exception trying to invoke EJBClientContextListener " + listener + " for EJB client context " + EJBClientContext.this + " on un-registertation of EJBReceiver " + receiver), t);
                            }
                        }
                    });
                }
            }
        }
    }

    public void registerConnection(Connection connection) {
        this.registerEJBReceiver(new RemotingConnectionEJBReceiver(connection));
    }

    public EJBClientInterceptor.Registration registerInterceptor(int priority, EJBClientInterceptor clientInterceptor) throws IllegalArgumentException {
        Object[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        this.assertNotClosed();
        if (clientInterceptor == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB client interceptor");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_INTERCEPTOR_PERMISSION);
        }
        EJBClientInterceptor.Registration newRegistration = new EJBClientInterceptor.Registration(this, clientInterceptor, priority);
        do {
            for (EJBClientInterceptor.Registration oldRegistration : oldRegistrations = this.registrations) {
                if (oldRegistration.getInterceptor() != clientInterceptor) continue;
                if (oldRegistration.compareTo(newRegistration) == 0) {
                    return oldRegistration;
                }
                throw Logs.MAIN.ejbClientInterceptorAlreadyRegistered(clientInterceptor);
            }
            int length = oldRegistrations.length;
            newRegistrations = Arrays.copyOf(oldRegistrations, length + 1);
            newRegistrations[length] = newRegistration;
            Arrays.sort(newRegistrations);
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, (EJBClientInterceptor.Registration[])newRegistrations));
        return newRegistration;
    }

    public EJBClientConfiguration getEJBClientConfiguration() {
        return this.ejbClientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReconnectHandler(ReconnectHandler reconnectHandler) {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, reconnect handler " + reconnectHandler + " will not be added to the context"));
            }
            return;
        }
        if (reconnectHandler == null) {
            throw Logs.MAIN.paramCannotBeNull("Reconnect handler");
        }
        List<ReconnectHandler> list = this.reconnectHandlers;
        synchronized (list) {
            this.reconnectHandlers.add(reconnectHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReconnectHandler(ReconnectHandler reconnectHandler) {
        List<ReconnectHandler> list = this.reconnectHandlers;
        synchronized (list) {
            this.reconnectHandlers.remove(reconnectHandler);
        }
    }

    public boolean registerEJBClientContextListener(EJBClientContextListener listener) {
        if (listener == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB client context listener");
        }
        return this.ejbClientContextListeners.add(listener);
    }

    void removeInterceptor(EJBClientInterceptor.Registration registration) {
        EJBClientInterceptor.Registration[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        do {
            block5: {
                int newLength;
                int length;
                block4: {
                    oldRegistrations = this.registrations;
                    newRegistrations = null;
                    length = oldRegistrations.length;
                    newLength = length - 1;
                    if (length != 1) break block4;
                    if (oldRegistrations[0] != registration) break block5;
                    newRegistrations = NO_INTERCEPTORS;
                    break block5;
                }
                for (int i = 0; i < length; ++i) {
                    if (oldRegistrations[i] != registration) continue;
                    if (i == newLength) {
                        newRegistrations = Arrays.copyOf(oldRegistrations, newLength);
                        break;
                    }
                    newRegistrations = new EJBClientInterceptor.Registration[newLength];
                    if (i > 0) {
                        System.arraycopy(oldRegistrations, 0, newRegistrations, 0, i);
                    }
                    System.arraycopy(oldRegistrations, i + 1, newRegistrations, i, newLength - i);
                    break;
                }
            }
            if (newRegistrations != null) continue;
            return;
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, newRegistrations));
    }

    Collection<EJBReceiver> getEJBReceivers(String appName, String moduleName, String distinctName) {
        return this.getEJBReceivers(appName, moduleName, distinctName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<EJBReceiver> getEJBReceivers(String appName, String moduleName, String distinctName, boolean attemptReconnect) {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, returning an empty collection of EJB receivers"));
            }
            return Collections.emptySet();
        }
        HashSet<EJBReceiver> eligibleEJBReceivers = new HashSet<EJBReceiver>();
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (Map.Entry<EJBReceiver, ReceiverAssociation> entry : this.ejbReceiverAssociations.entrySet()) {
                EJBReceiver ejbReceiver;
                if (!entry.getValue().associated || !(ejbReceiver = entry.getKey()).acceptsModule(appName, moduleName, distinctName)) continue;
                eligibleEJBReceivers.add(ejbReceiver);
            }
        }
        if (eligibleEJBReceivers.isEmpty() && attemptReconnect) {
            this.attemptReconnections();
            eligibleEJBReceivers.addAll(this.getEJBReceivers(appName, moduleName, distinctName, false));
        }
        return eligibleEJBReceivers;
    }

    EJBReceiver getEJBReceiver(String appName, String moduleName, String distinctName) {
        return this.getEJBReceiver((Collection<String>)null, appName, moduleName, distinctName);
    }

    EJBReceiver requireEJBReceiver(String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver ejbReceiver = this.getEJBReceiver(appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw Logs.MAIN.noEJBReceiverAvailableForDeployment(appName, moduleName, distinctName);
        }
        return ejbReceiver;
    }

    EJBReceiver getEJBReceiver(EJBClientInvocationContext invocationContext, String appName, String moduleName, String distinctName) {
        Iterator<EJBReceiver> iterator = this.getEJBReceivers(appName, moduleName, distinctName).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Set<String> excludedNodes = invocationContext == null ? Collections.EMPTY_SET : invocationContext.getExcludedNodes();
        HashMap<String, EJBReceiver> eligibleReceivers = new HashMap<String, EJBReceiver>();
        while (iterator.hasNext()) {
            EJBReceiver receiver = iterator.next();
            String nodeName = receiver.getNodeName();
            if (excludedNodes.contains(nodeName)) {
                logger.debug((Object)(nodeName + " is excluded from handling appname=" + appName + ",modulename=" + moduleName + ",distinctname=" + distinctName + " in invocation context " + invocationContext));
                continue;
            }
            eligibleReceivers.put(receiver.getNodeName(), receiver);
        }
        if (eligibleReceivers.isEmpty()) {
            return null;
        }
        String selectedNode = this.deploymentNodeSelector.selectNode(eligibleReceivers.keySet().toArray(new String[eligibleReceivers.size()]), appName, moduleName, distinctName);
        logger.debug((Object)(this.deploymentNodeSelector + " deployment node selector selected " + selectedNode + " node for appname=" + appName + ",modulename=" + moduleName + ",distinctname=" + distinctName));
        if (selectedNode == null || selectedNode.trim().isEmpty() || !eligibleReceivers.containsKey(selectedNode)) {
            logger.debug((Object)("Selected node " + selectedNode + " doesn't belong to eligible receivers. Continuing with a random eligible receiver"));
            return iterator.next();
        }
        return (EJBReceiver)eligibleReceivers.get(selectedNode);
    }

    EJBReceiver requireEJBReceiver(EJBClientInvocationContext clientInvocationContext, String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver ejbReceiver = this.getEJBReceiver(clientInvocationContext, appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw Logs.MAIN.noEJBReceiverAvailableForDeploymentDuringInvocation(appName, moduleName, distinctName, clientInvocationContext);
        }
        return ejbReceiver;
    }

    EJBReceiver getEJBReceiver(Collection<String> excludedNodeNames, String appName, String moduleName, String distinctName) {
        Iterator<EJBReceiver> iterator = this.getEJBReceivers(appName, moduleName, distinctName).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        HashMap<String, EJBReceiver> eligibleReceivers = new HashMap<String, EJBReceiver>();
        while (iterator.hasNext()) {
            EJBReceiver receiver = iterator.next();
            String nodeName = receiver.getNodeName();
            if (excludedNodeNames != null && excludedNodeNames.contains(nodeName)) {
                logger.debugf("%s has been asked to be excluded from handling appName=%s, moduleName=%s=, distinctName=%s", new Object[]{nodeName, appName, moduleName, distinctName});
                continue;
            }
            eligibleReceivers.put(receiver.getNodeName(), receiver);
        }
        if (eligibleReceivers.isEmpty()) {
            return null;
        }
        String selectedNode = this.deploymentNodeSelector.selectNode(eligibleReceivers.keySet().toArray(new String[eligibleReceivers.size()]), appName, moduleName, distinctName);
        logger.debugf("%s deployment node selector selected %s node for appname=%s, modulename=%s, distinctName=%s", new Object[]{this.deploymentNodeSelector, selectedNode, appName, moduleName, distinctName});
        if (selectedNode == null || selectedNode.trim().isEmpty() || !eligibleReceivers.containsKey(selectedNode)) {
            logger.debugf("Selected node %s doesn't belong to eligible receivers. Continuing with a random eligible receiver", (Object)selectedNode);
            return iterator.next();
        }
        return (EJBReceiver)eligibleReceivers.get(selectedNode);
    }

    EJBReceiver requireEJBReceiver(Collection<String> excludedNodeNames, String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver ejbReceiver = this.getEJBReceiver(excludedNodeNames, appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw Logs.MAIN.noEJBReceiverAvailableForDeployment(appName, moduleName, distinctName);
        }
        return ejbReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiverContext requireEJBReceiverContext(EJBReceiver receiver) throws IllegalStateException {
        this.assertNotClosed();
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            ReceiverAssociation association = this.ejbReceiverAssociations.get(receiver);
            if (association == null) {
                throw Logs.MAIN.receiverNotAssociatedWithClientContext(receiver, this);
            }
            return association.context;
        }
    }

    EJBReceiver requireNodeEJBReceiver(String nodeName) {
        EJBReceiver receiver = this.getNodeEJBReceiver(nodeName);
        if (receiver != null) {
            return receiver;
        }
        throw Logs.MAIN.noEJBReceiverForNode(nodeName);
    }

    EJBReceiver getNodeEJBReceiver(String nodeName) {
        return this.getNodeEJBReceiver(nodeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBReceiver getNodeEJBReceiver(String nodeName, boolean attemptReconnect) {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, no EJB receiver will be returned for node name " + nodeName));
            }
            return null;
        }
        if (nodeName == null) {
            throw Logs.MAIN.paramCannotBeNull("Node name");
        }
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (Map.Entry<EJBReceiver, ReceiverAssociation> entry : this.ejbReceiverAssociations.entrySet()) {
                EJBReceiver ejbReceiver;
                if (!entry.getValue().associated || !nodeName.equals((ejbReceiver = entry.getKey()).getNodeName())) continue;
                return ejbReceiver;
            }
        }
        if (attemptReconnect) {
            this.attemptReconnections();
            return this.getNodeEJBReceiver(nodeName, false);
        }
        return null;
    }

    EJBReceiverContext requireNodeEJBReceiverContext(String nodeName) {
        EJBReceiver ejbReceiver = this.requireNodeEJBReceiver(nodeName);
        return this.requireEJBReceiverContext(ejbReceiver);
    }

    EJBReceiverContext getNodeEJBReceiverContext(String nodeName) {
        EJBReceiver ejbReceiver = this.getNodeEJBReceiver(nodeName);
        return ejbReceiver == null ? null : this.requireEJBReceiverContext(ejbReceiver);
    }

    boolean clusterContains(String clusterName, String nodeName) {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, node named " + nodeName + " is not considered part of cluster named " + clusterName));
            }
            return false;
        }
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            return false;
        }
        return clusterContext.isNodeAvailable(nodeName);
    }

    EJBReceiverContext getClusterEJBReceiverContext(String clusterName) throws IllegalArgumentException {
        return this.getClusterEJBReceiverContext(null, clusterName);
    }

    EJBReceiverContext getClusterEJBReceiverContext(EJBClientInvocationContext invocationContext, String clusterName) throws IllegalArgumentException {
        return this.getClusterEJBReceiverContext(invocationContext, clusterName, true);
    }

    private EJBReceiverContext getClusterEJBReceiverContext(EJBClientInvocationContext invocationContext, String clusterName, boolean attemptReconnect) throws IllegalArgumentException {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, returning no EJB receiver for cluster named " + clusterName));
            }
            return null;
        }
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            return null;
        }
        EJBReceiverContext ejbReceiverContext = clusterContext.getEJBReceiverContext(invocationContext);
        if (ejbReceiverContext == null && attemptReconnect) {
            this.attemptReconnections();
            return this.getClusterEJBReceiverContext(invocationContext, clusterName, false);
        }
        return ejbReceiverContext;
    }

    EJBReceiverContext requireClusterEJBReceiverContext(String clusterName) throws IllegalArgumentException {
        return this.requireClusterEJBReceiverContext(null, clusterName);
    }

    EJBReceiverContext requireClusterEJBReceiverContext(EJBClientInvocationContext invocationContext, String clusterName) throws IllegalArgumentException {
        EJBReceiverContext ejbReceiverContext;
        this.assertNotClosed();
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            logger.debug((Object)("Waiting for cluster topology information to be available for cluster named " + clusterName));
            this.waitForClusterTopology(clusterName);
            clusterContext = this.clusterContexts.get(clusterName);
            if (clusterContext == null) {
                throw Logs.MAIN.noClusterContextAvailable(clusterName);
            }
        }
        if ((ejbReceiverContext = this.getClusterEJBReceiverContext(invocationContext, clusterName)) == null) {
            throw Logs.MAIN.noReceiverContextsInCluster(clusterName);
        }
        return ejbReceiverContext;
    }

    EJBClientInterceptor[] getInterceptorChain() {
        int i;
        EJBClientInterceptor.Registration[] registeredInterceptors = this.registrations;
        int totalInterceptorLength = this.clientInterceptorsInClasspath != null ? registeredInterceptors.length + this.clientInterceptorsInClasspath.size() : registeredInterceptors.length;
        EJBClientInterceptor[] interceptors = new EJBClientInterceptor[totalInterceptorLength];
        for (i = 0; i < registeredInterceptors.length; ++i) {
            interceptors[i] = registeredInterceptors[i].getInterceptor();
        }
        if (this.clientInterceptorsInClasspath != null && !this.clientInterceptorsInClasspath.isEmpty()) {
            i = registeredInterceptors.length;
            for (EJBClientInterceptor interceptor : this.clientInterceptorsInClasspath) {
                interceptors[i++] = interceptor;
            }
        }
        return interceptors;
    }

    public synchronized ClusterContext getOrCreateClusterContext(String clusterName) {
        this.assertNotClosed();
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            clusterContext = new ClusterContext(clusterName, this, this.ejbClientConfiguration);
            clusterContext.registerListener(this.clusterFormationNotifier);
            this.clusterContexts.put(clusterName, clusterContext);
        }
        return clusterContext;
    }

    public synchronized ClusterContext getClusterContext(String clusterName) {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, returning no cluster context for cluster named " + clusterName));
            }
            return null;
        }
        return this.clusterContexts.get(clusterName);
    }

    public synchronized void removeCluster(String clusterName) {
        ClusterContext clusterContext = this.clusterContexts.remove(clusterName);
        if (clusterContext == null) {
            return;
        }
        try {
            clusterContext.close();
        }
        catch (Throwable t) {
            logger.debug((Object)("Ignoring an error that occured while closing a cluster context for cluster named " + clusterName), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClusterTopology(String clusterName) {
        CountDownLatch clusterFormationLatch = new CountDownLatch(1);
        this.clusterFormationNotifier.registerForClusterFormation(clusterName, clusterFormationLatch);
        try {
            boolean receivedClusterTopology = clusterFormationLatch.await(5L, TimeUnit.SECONDS);
            if (receivedClusterTopology) {
                logger.debug((Object)("Received the cluster topology for cluster named " + clusterName + " during the wait time"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.clusterFormationNotifier.unregisterFromClusterNotification(clusterName, clusterFormationLatch);
        }
    }

    private synchronized void attemptReconnections() {
        if (this.closed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EJB client context " + this + " has been closed, no reconnections, to register EJB receivers, will be attempted"));
            }
            return;
        }
        ArrayList<ReconnectHandler> reconnectHandlersToAttempt = new ArrayList<ReconnectHandler>(this.reconnectHandlers);
        if (reconnectHandlersToAttempt.isEmpty()) {
            return;
        }
        CountDownLatch reconnectTasksCompletionNotifierLatch = new CountDownLatch(reconnectHandlersToAttempt.size());
        for (ReconnectHandler reconnectHandler : reconnectHandlersToAttempt) {
            this.ejbClientContextTasksExecutorService.submit(new ReconnectAttempt(reconnectHandler, reconnectTasksCompletionNotifierLatch));
        }
        try {
            long reconnectWaitTimeout = 10000L;
            if (this.ejbClientConfiguration != null && this.ejbClientConfiguration.getReconnectTasksTimeout() > 0L) {
                reconnectWaitTimeout = this.ejbClientConfiguration.getReconnectTasksTimeout();
            }
            reconnectTasksCompletionNotifierLatch.await(reconnectWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (EJBClientContextListener listener : this.ejbClientContextListeners) {
            try {
                listener.contextClosed(this);
            }
            catch (Throwable t) {
                logger.debug((Object)("Ignoring the exception thrown by an EJB client context listener while closing the context " + this), t);
            }
        }
        this.ejbClientContextTasksExecutorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw Logs.MAIN.ejbClientContextIsClosed(this);
        }
    }

    static {
        Properties ejbClientProperties = EJBClientPropertiesLoader.loadEJBClientProperties();
        if (ejbClientProperties == null) {
            SELECTOR = new ConfigBasedEJBClientContextSelector(null);
        } else {
            PropertiesBasedEJBClientConfiguration clientConfiguration = new PropertiesBasedEJBClientConfiguration(ejbClientProperties);
            SELECTOR = new ConfigBasedEJBClientContextSelector(clientConfiguration);
        }
    }

    private class ReconnectAttempt
    implements Runnable {
        private final ReconnectHandler reconnectHandler;
        private final CountDownLatch taskCompletionNotifierLatch;

        ReconnectAttempt(ReconnectHandler reconnectHandler, CountDownLatch taskCompletionNotifierLatch) {
            this.reconnectHandler = reconnectHandler;
            this.taskCompletionNotifierLatch = taskCompletionNotifierLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.reconnectHandler.reconnect();
            }
            catch (Exception e) {
                logger.debug((Object)("Exception trying to re-establish a connection from EJB client context " + EJBClientContext.this), (Throwable)e);
            }
            finally {
                this.taskCompletionNotifierLatch.countDown();
            }
        }
    }

    private final class ClusterFormationNotifier
    implements ClusterContext.ClusterContextListener {
        private final Map<String, List<CountDownLatch>> clusterFormationListeners = new HashMap<String, List<CountDownLatch>>();

        private ClusterFormationNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerForClusterFormation(String clusterName, CountDownLatch latch) {
            Map<String, List<CountDownLatch>> map = this.clusterFormationListeners;
            synchronized (map) {
                List<CountDownLatch> listeners = this.clusterFormationListeners.get(clusterName);
                if (listeners == null) {
                    listeners = new ArrayList<CountDownLatch>();
                    this.clusterFormationListeners.put(clusterName, listeners);
                }
                listeners.add(latch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyClusterFormation(String clusterName) {
            List<CountDownLatch> listeners;
            Map<String, List<CountDownLatch>> map = this.clusterFormationListeners;
            synchronized (map) {
                listeners = this.clusterFormationListeners.remove(clusterName);
            }
            if (listeners == null) {
                return;
            }
            for (CountDownLatch latch : listeners) {
                latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterFromClusterNotification(String clusterName, CountDownLatch latch) {
            Map<String, List<CountDownLatch>> map = this.clusterFormationListeners;
            synchronized (map) {
                List<CountDownLatch> listeners = this.clusterFormationListeners.get(clusterName);
                if (listeners == null) {
                    return;
                }
                listeners.remove(latch);
            }
        }

        @Override
        public void clusterNodesAdded(String clusterName, ClusterNodeManager ... nodes) {
            this.notifyClusterFormation(clusterName);
        }
    }

    private static final class ReceiverAssociation {
        final EJBReceiverContext context;
        boolean associated = false;

        private ReceiverAssociation(EJBReceiverContext context) {
            this.context = context;
        }
    }

    static interface EJBReceiverContextCloseHandler {
        public void receiverContextClosed(EJBReceiverContext var1);
    }
}

