/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.ManifestBuilder;
import org.jboss.osgi.metadata.MetadataLogger;
import org.jboss.osgi.metadata.MetadataMessages;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public final class OSGiManifestBuilder
implements Asset {
    private final ManifestBuilder delegate = ManifestBuilder.newInstance();
    private final Map<String, String> importPackages = new LinkedHashMap<String, String>();
    private final Map<String, String> exportPackages = new LinkedHashMap<String, String>();
    private final Map<String, String> dynamicImportPackages = new LinkedHashMap<String, String>();
    private final Map<String, String> requiredBundles = new LinkedHashMap<String, String>();
    private final Map<String, String> requiredEnvironments = new LinkedHashMap<String, String>();
    private final List<String> providedCapabilities = new ArrayList<String>();
    private final List<String> requiredCapabilities = new ArrayList<String>();
    private Manifest manifest;

    public static OSGiManifestBuilder newInstance() {
        return new OSGiManifestBuilder();
    }

    private OSGiManifestBuilder() {
    }

    public OSGiManifestBuilder addBundleManifestVersion(int version) {
        this.delegate.append("Bundle-ManifestVersion: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleSymbolicName(String symbolicName) {
        this.delegate.append("Bundle-SymbolicName: " + symbolicName);
        return this;
    }

    public OSGiManifestBuilder addBundleName(String name) {
        this.delegate.append("Bundle-Name: " + name);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(Version version) {
        this.delegate.append("Bundle-Version: " + version);
        return this;
    }

    public OSGiManifestBuilder addBundleVersion(String version) {
        return this.addBundleVersion(Version.parseVersion((String)version));
    }

    public OSGiManifestBuilder addBundleActivator(Class<?> bundleActivator) {
        return this.addBundleActivator(bundleActivator.getName());
    }

    public OSGiManifestBuilder addBundleActivator(String bundleActivator) {
        this.delegate.append("Bundle-Activator: " + bundleActivator);
        return this;
    }

    public OSGiManifestBuilder addBundleActivationPolicy(String activationPolicy) {
        this.delegate.append("Bundle-ActivationPolicy: " + activationPolicy);
        return this;
    }

    public OSGiManifestBuilder addBundleClasspath(String classpath) {
        this.delegate.append("Bundle-ClassPath: " + classpath);
        return this;
    }

    public OSGiManifestBuilder addRequiredExecutionEnvironment(String execenv) {
        this.delegate.append("Bundle-RequiredExecutionEnvironment: " + execenv);
        return this;
    }

    public OSGiManifestBuilder addFragmentHost(String fragmentHost) {
        this.delegate.append("Fragment-Host: " + fragmentHost);
        return this;
    }

    public OSGiManifestBuilder addFragmentHost(String fragmentHost, VersionRange version) {
        String bundleSpec = fragmentHost;
        if (version != null) {
            bundleSpec = bundleSpec + ";bundle-version=\"" + version + "\"";
        }
        this.delegate.append("Fragment-Host: " + bundleSpec);
        return this;
    }

    public OSGiManifestBuilder addManifestHeader(String key, String value) {
        this.delegate.addManifestHeader(key, value);
        return this;
    }

    public OSGiManifestBuilder addRequireBundle(String requiredBundle) {
        return this.addRequireBundle(requiredBundle, null);
    }

    public OSGiManifestBuilder addRequireBundle(String requiredBundle, VersionRange version) {
        String entry = requiredBundle;
        if (version != null) {
            entry = entry + ";bundle-version=\"" + version + "\"";
        }
        this.addEntry(this.requiredBundles, entry);
        return this;
    }

    public OSGiManifestBuilder addRequireExecutionEnvironment(String ... environments) {
        for (String entry : environments) {
            this.addEntry(this.requiredEnvironments, entry);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addImportPackage(aux.getPackage(), null);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(Package ... packages) {
        for (Package aux : packages) {
            this.addImportPackage(aux, null);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackages(String ... packages) {
        for (String aux : packages) {
            this.addImportPackage(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addImportPackage(Class<?> imported, VersionRange version) {
        return this.addImportPackage(imported.getPackage(), version);
    }

    public OSGiManifestBuilder addImportPackage(Package imported, VersionRange version) {
        return this.addImportPackage(imported.getName(), version);
    }

    public OSGiManifestBuilder addImportPackage(String packageName, VersionRange version) {
        String packageSpec = packageName;
        if (version != null) {
            packageSpec = packageSpec + ";version=\"" + version + "\"";
        }
        this.addImportPackage(packageSpec);
        return this;
    }

    public OSGiManifestBuilder addImportPackage(String packageSpec) {
        this.addEntry(this.importPackages, packageSpec);
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(Class<?> ... imported) {
        for (Class<?> clazz : imported) {
            this.addDynamicImportPackages(clazz.getPackage());
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(Package ... imported) {
        for (Package aux : imported) {
            this.addDynamicImportPackage(aux.getName());
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackages(String ... imported) {
        for (String entry : imported) {
            this.addDynamicImportPackage(entry);
        }
        return this;
    }

    public OSGiManifestBuilder addDynamicImportPackage(String imported) {
        this.addEntry(this.dynamicImportPackages, imported);
        return this;
    }

    public OSGiManifestBuilder addExportPackages(Class<?> ... packages) {
        for (Class<?> aux : packages) {
            this.addExportPackage(aux.getPackage(), null);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(Package ... packages) {
        for (Package aux : packages) {
            this.addExportPackage(aux, null);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackages(String ... packages) {
        for (String aux : packages) {
            this.addExportPackage(aux);
        }
        return this;
    }

    public OSGiManifestBuilder addExportPackage(Class<?> exported, Version version) {
        return this.addExportPackage(exported.getPackage(), version);
    }

    public OSGiManifestBuilder addExportPackage(Package exported, Version version) {
        return this.addExportPackage(exported.getName(), version);
    }

    public OSGiManifestBuilder addExportPackage(String packageName, Version version) {
        String packageSpec = packageName;
        if (version != null) {
            packageSpec = packageSpec + ";version=" + version;
        }
        this.addExportPackage(packageSpec);
        return this;
    }

    public OSGiManifestBuilder addExportPackage(String packageSpec) {
        this.addEntry(this.exportPackages, packageSpec);
        return this;
    }

    public OSGiManifestBuilder addProvidedCapabilities(String ... capabilities) {
        for (String entry : capabilities) {
            this.providedCapabilities.add(entry);
        }
        return this;
    }

    public OSGiManifestBuilder addProvidedCapability(String namespace, Map<String, String> atts, Map<String, String> dirs) {
        this.providedCapabilities.add(this.getCapabilitySpec(namespace, atts, dirs));
        return this;
    }

    public OSGiManifestBuilder addRequiredCapabilities(String ... capabilities) {
        for (String entry : capabilities) {
            this.requiredCapabilities.add(entry);
        }
        return this;
    }

    public OSGiManifestBuilder addRequiredCapability(String namespace, Map<String, String> atts, Map<String, String> dirs) {
        this.requiredCapabilities.add(this.getCapabilitySpec(namespace, atts, dirs));
        return this;
    }

    private String getCapabilitySpec(String namespace, Map<String, String> atts, Map<String, String> dirs) {
        StringBuffer buffer = new StringBuffer(namespace);
        if (atts != null && !atts.isEmpty()) {
            for (Map.Entry<String, String> entry : atts.entrySet()) {
                buffer.append(";" + entry.getKey() + "=\"" + entry.getValue() + "\"");
            }
        }
        if (dirs != null && !dirs.isEmpty()) {
            for (Map.Entry<String, String> entry : dirs.entrySet()) {
                buffer.append(";" + entry.getKey() + ":=\"" + entry.getValue() + "\"");
            }
        }
        return buffer.toString();
    }

    private void addEntry(Map<String, String> target, String entry) {
        String key = entry;
        int index = entry.indexOf(";");
        if (index > 0) {
            key = entry.substring(0, index);
        }
        if (target.get(key) == null) {
            target.put(key, entry);
        } else {
            MetadataLogger.LOGGER.warnIgnoreDuplicateEntry(entry);
        }
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            this.addManifestHeader("Require-Bundle", this.requiredBundles);
            this.addManifestHeader("Bundle-RequiredExecutionEnvironment", this.requiredEnvironments);
            this.addManifestHeader("Export-Package", this.exportPackages);
            this.addManifestHeader("Import-Package", this.importPackages);
            this.addManifestHeader("DynamicImport-Package", this.dynamicImportPackages);
            this.addManifestHeader("Provide-Capability", this.providedCapabilities);
            this.addManifestHeader("Require-Capability", this.requiredCapabilities);
            Manifest aux = this.delegate.getManifest();
            try {
                OSGiManifestBuilder.validateBundleManifest(aux);
            }
            catch (BundleException ex) {
                throw new IllegalStateException(ex);
            }
            this.manifest = aux;
        }
        return this.manifest;
    }

    private void addManifestHeader(String header, Map<String, String> source) {
        if (source.size() > 0) {
            int i = 0;
            StringBuffer buffer = new StringBuffer();
            for (String entry : source.values()) {
                buffer.append(i++ > 0 ? "," : "");
                buffer.append(entry);
            }
            this.delegate.addManifestHeader(header, buffer.toString());
        }
    }

    private void addManifestHeader(String header, List<String> source) {
        if (source.size() > 0) {
            int i = 0;
            StringBuffer buffer = new StringBuffer();
            for (String entry : source) {
                buffer.append(i++ > 0 ? "," : "");
                buffer.append(entry);
            }
            this.delegate.addManifestHeader(header, buffer.toString());
        }
    }

    public static boolean isValidBundleManifest(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        try {
            OSGiManifestBuilder.validateBundleManifest(manifest);
            return true;
        }
        catch (BundleException e) {
            return false;
        }
    }

    public static void validateBundleManifest(Manifest manifest) throws BundleException {
        int manifestVersion;
        if (manifest == null) {
            MetadataMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        if ((manifestVersion = OSGiManifestBuilder.getBundleManifestVersion(manifest)) < 0) {
            throw MetadataMessages.MESSAGES.bundleCannotObtainBundleManifestVersion();
        }
        if (manifestVersion > 2) {
            throw MetadataMessages.MESSAGES.bundleUnsupportedBundleManifestVersion(manifestVersion);
        }
        String symbolicName = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        if (manifestVersion == 1 && symbolicName != null) {
            throw MetadataMessages.MESSAGES.bundleInvalidBundleManifestVersion(symbolicName);
        }
        if (manifestVersion == 2 && symbolicName == null) {
            throw MetadataMessages.MESSAGES.bundleCannotObtainBundleSymbolicName();
        }
    }

    public static int getBundleManifestVersion(Manifest manifest) {
        if (manifest == null) {
            throw MetadataMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        String manifestVersion = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-ManifestVersion");
        if (manifestVersion != null) {
            return Integer.parseInt(manifestVersion);
        }
        String bundleName = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-Name");
        String bundleSymbolicName = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        String bundleVersion = OSGiManifestBuilder.getManifestHeaderInternal(manifest, "Bundle-Version");
        if (bundleName == null && bundleSymbolicName == null && bundleVersion == null) {
            return -1;
        }
        return 1;
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw MetadataMessages.MESSAGES.illegalStateCannotProvideManifestInputStream(ex);
        }
    }

    private static String getManifestHeaderInternal(Manifest manifest, String key) {
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value != null ? value.trim() : null;
    }
}

