/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.JavaNamespaceSetup;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.UserTransactionService;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.CdiAnnotationMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.weld.services.TCCLSingletonService;
import org.jboss.as.weld.services.bootstrap.WeldEjbInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldEjbServices;
import org.jboss.as.weld.services.bootstrap.WeldJaxwsInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldResourceInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldSecurityServices;
import org.jboss.as.weld.services.bootstrap.WeldTransactionServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class WeldDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            if (deploymentUnit.getParent() == null && CdiAnnotationMarker.cdiAnnotationsPresent(deploymentUnit)) {
                WeldLogger.DEPLOYMENT_LOGGER.cdiAnnotationsButNoBeansXML(deploymentUnit);
            }
            return;
        }
        ServiceName weldBootstrapServiceName = parent.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)weldBootstrapServiceName);
        HashSet<ServiceName> jpaServices = new HashSet<ServiceName>();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        WeldLogger.DEPLOYMENT_LOGGER.startingServicesForCDIDeployment(phaseContext.getDeploymentUnit().getName());
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        HashSet<BeanDeploymentArchiveImpl> beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>();
        HashMap<ModuleIdentifier, BeanDeploymentModule> bdmsByIdentifier = new HashMap<ModuleIdentifier, BeanDeploymentModule>();
        HashMap<ModuleIdentifier, ModuleSpecification> moduleSpecByIdentifier = new HashMap<ModuleIdentifier, ModuleSpecification>();
        BeanDeploymentModule rootBeanDeploymentModule = (BeanDeploymentModule)deploymentUnit.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationDescription eeApplicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_DESCRIPTION);
        bdmsByIdentifier.put(module.getIdentifier(), rootBeanDeploymentModule);
        for (BeanDeploymentModule additional : deploymentUnit.getAttachmentList(WeldAttachments.VISIBLE_ADDITIONAL_BEAN_DEPLOYMENT_MODULE)) {
            additional.addBeanDeploymentModule(rootBeanDeploymentModule);
            rootBeanDeploymentModule.addBeanDeploymentModule(additional);
        }
        moduleSpecByIdentifier.put(module.getIdentifier(), moduleSpecification);
        beanDeploymentArchives.addAll(rootBeanDeploymentModule.getBeanDeploymentArchives());
        List subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        HashSet<ClassLoader> subDeploymentLoaders = new HashSet<ClassLoader>();
        this.getJpaDependencies(deploymentUnit, jpaServices);
        for (DeploymentUnit deploymentUnit2 : subDeployments) {
            this.getJpaDependencies(deploymentUnit, jpaServices);
            Module subDeploymentModule = (Module)deploymentUnit2.getAttachment(Attachments.MODULE);
            if (subDeploymentModule == null) continue;
            subDeploymentLoaders.add((ClassLoader)subDeploymentModule.getClassLoader());
            ModuleSpecification subDeploymentModuleSpec = (ModuleSpecification)deploymentUnit2.getAttachment(Attachments.MODULE_SPECIFICATION);
            BeanDeploymentModule bdm = (BeanDeploymentModule)deploymentUnit2.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
            if (bdm == null) continue;
            beanDeploymentArchives.addAll(bdm.getBeanDeploymentArchives());
            List additionalModules = deploymentUnit2.getAttachmentList(WeldAttachments.VISIBLE_ADDITIONAL_BEAN_DEPLOYMENT_MODULE);
            bdmsByIdentifier.put(subDeploymentModule.getIdentifier(), bdm);
            moduleSpecByIdentifier.put(subDeploymentModule.getIdentifier(), subDeploymentModuleSpec);
            ResourceRoot subDeploymentRoot = (ResourceRoot)deploymentUnit2.getAttachment(Attachments.DEPLOYMENT_ROOT);
            WeldEjbInjectionServices ejbInjectionServices = new WeldEjbInjectionServices(deploymentUnit.getServiceRegistry(), eeModuleDescription, eeApplicationDescription, subDeploymentRoot.getRoot());
            bdm.addService(EjbInjectionServices.class, ejbInjectionServices);
            WeldResourceInjectionServices resourceInjectionServices = new WeldResourceInjectionServices(deploymentUnit.getServiceRegistry(), eeModuleDescription);
            bdm.addService(ResourceInjectionServices.class, resourceInjectionServices);
            for (BeanDeploymentModule additional : additionalModules) {
                additional.addBeanDeploymentModule(bdm);
                bdm.addBeanDeploymentModule(additional);
                bdm.addService(EjbInjectionServices.class, ejbInjectionServices);
                bdm.addService(ResourceInjectionServices.class, resourceInjectionServices);
            }
        }
        for (Map.Entry entry : bdmsByIdentifier.entrySet()) {
            ModuleSpecification bdmSpec = (ModuleSpecification)moduleSpecByIdentifier.get(entry.getKey());
            BeanDeploymentModule bdm = (BeanDeploymentModule)entry.getValue();
            if (bdm == rootBeanDeploymentModule) continue;
            for (ModuleDependency dependency : bdmSpec.getSystemDependencies()) {
                BeanDeploymentModule other = (BeanDeploymentModule)bdmsByIdentifier.get(dependency.getIdentifier());
                if (other == null || other == bdm) continue;
                bdm.addBeanDeploymentModule(other);
            }
        }
        WeldEjbInjectionServices ejbInjectionServices = new WeldEjbInjectionServices(deploymentUnit.getServiceRegistry(), eeModuleDescription, eeApplicationDescription, deploymentRoot.getRoot());
        WeldResourceInjectionServices weldResourceInjectionServices = new WeldResourceInjectionServices(deploymentUnit.getServiceRegistry(), eeModuleDescription);
        rootBeanDeploymentModule.addService(EjbInjectionServices.class, ejbInjectionServices);
        rootBeanDeploymentModule.addService(ResourceInjectionServices.class, weldResourceInjectionServices);
        for (BeanDeploymentModule additional : deploymentUnit.getAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES)) {
            beanDeploymentArchives.addAll(additional.getBeanDeploymentArchives());
            additional.addService(EjbInjectionServices.class, ejbInjectionServices);
            additional.addService(ResourceInjectionServices.class, weldResourceInjectionServices);
        }
        Collection<Metadata<Extension>> extensions = WeldPortableExtensions.getPortableExtensions(deploymentUnit).getExtensions();
        WeldDeployment deployment = new WeldDeployment(beanDeploymentArchives, extensions, module, subDeploymentLoaders, deploymentUnit);
        WeldBootstrapService weldBootstrapService = new WeldBootstrapService(deployment, (Environment)Environments.EE_INJECT, deploymentUnit.getName());
        weldBootstrapService.addWeldService(EjbInjectionServices.class, ejbInjectionServices);
        weldBootstrapService.addWeldService(ResourceInjectionServices.class, weldResourceInjectionServices);
        weldBootstrapService.addWeldService(EjbServices.class, new WeldEjbServices(deploymentUnit.getServiceRegistry()));
        WeldJpaInjectionServices rootJpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit, deploymentUnit.getServiceRegistry());
        WeldJaxwsInjectionServices rootJaxWsInjectionServices = new WeldJaxwsInjectionServices(deploymentUnit);
        weldBootstrapService.addWeldService(JpaInjectionServices.class, rootJpaInjectionServices);
        weldBootstrapService.addWeldService(JaxwsInjectionServices.class, rootJaxWsInjectionServices);
        ServiceBuilder weldBootstrapServiceBuilder = serviceTarget.addService(weldBootstrapServiceName, (Service)weldBootstrapService);
        weldBootstrapServiceBuilder.addDependencies(new ServiceName[]{TCCLSingletonService.SERVICE_NAME});
        this.installSecurityService(serviceTarget, deploymentUnit, weldBootstrapService, (ServiceBuilder<WeldBootstrapService>)weldBootstrapServiceBuilder);
        this.installTransactionService(serviceTarget, deploymentUnit, weldBootstrapService, (ServiceBuilder<WeldBootstrapService>)weldBootstrapServiceBuilder);
        weldBootstrapServiceBuilder.install();
        ArrayList<SetupAction> setupActions = new ArrayList<SetupAction>();
        JavaNamespaceSetup naming = (JavaNamespaceSetup)deploymentUnit.getAttachment(org.jboss.as.ee.naming.Attachments.JAVA_NAMESPACE_SETUP_ACTION);
        if (naming != null) {
            setupActions.add((SetupAction)naming);
        }
        WeldStartService weldStartService = new WeldStartService(setupActions, (ClassLoader)module.getClassLoader());
        serviceTarget.addService(deploymentUnit.getServiceName().append(WeldStartService.SERVICE_NAME), (Service)weldStartService).addDependency(weldBootstrapServiceName, WeldBootstrapService.class, weldStartService.getBootstrap()).addDependency(JndiNamingDependencyProcessor.serviceName((DeploymentUnit)deploymentUnit)).addDependencies(jpaServices).install();
    }

    private void getJpaDependencies(DeploymentUnit deploymentUnit, Set<ServiceName> jpaServices) {
        for (ResourceRoot root : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
            PersistenceUnitMetadataHolder persistenceUnits = (PersistenceUnitMetadataHolder)root.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
            if (persistenceUnits == null || persistenceUnits.getPersistenceUnits() == null) continue;
            for (PersistenceUnitMetadata pu : persistenceUnits.getPersistenceUnits()) {
                Properties properties = pu.getProperties();
                String jpaContainerManaged = properties.getProperty("jboss.as.jpa.managed");
                boolean deployPU = jpaContainerManaged == null || Boolean.parseBoolean(jpaContainerManaged);
                if (!deployPU) continue;
                ServiceName serviceName = PersistenceUnitServiceImpl.getPUServiceName((PersistenceUnitMetadata)pu);
                jpaServices.add(serviceName);
            }
        }
    }

    private ServiceName installSecurityService(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, WeldBootstrapService weldService, ServiceBuilder<WeldBootstrapService> weldServiceBuilder) {
        WeldSecurityServices service = new WeldSecurityServices();
        ServiceName serviceName = deploymentUnit.getServiceName().append(WeldSecurityServices.SERVICE_NAME);
        serviceTarget.addService(serviceName, (Service)service).addDependency(ServiceBuilder.DependencyType.OPTIONAL, SimpleSecurityManagerService.SERVICE_NAME, SimpleSecurityManager.class, service.getSecurityManagerValue()).install();
        weldServiceBuilder.addDependency(serviceName, WeldSecurityServices.class, weldService.getSecurityServices());
        return serviceName;
    }

    private ServiceName installTransactionService(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, WeldBootstrapService weldService, ServiceBuilder<WeldBootstrapService> weldServiceBuilder) {
        WeldTransactionServices weldTransactionServices = new WeldTransactionServices();
        ServiceName weldTransactionServiceName = deploymentUnit.getServiceName().append(WeldTransactionServices.SERVICE_NAME);
        serviceTarget.addService(weldTransactionServiceName, (Service)weldTransactionServices).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, weldTransactionServices.getInjectedTransactionManager()).addDependency(UserTransactionService.SERVICE_NAME, UserTransaction.class, weldTransactionServices.getInjectedTransaction()).install();
        weldServiceBuilder.addDependency(weldTransactionServiceName, WeldTransactionServices.class, weldService.getWeldTransactionServices());
        return weldTransactionServiceName;
    }

    public void undeploy(DeploymentUnit context) {
        ServiceName weldTransactionServiceName = context.getServiceName().append(WeldTransactionServices.SERVICE_NAME);
        ServiceController serviceController = context.getServiceRegistry().getService(weldTransactionServiceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

